/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class LWCListener
implements Listener {
    private PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.HIGH)
    public void onProtectionRegister(LWCProtectionRegisterEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (player == null || block == null) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PROTECT_LWC);
        if (field != null && FieldFlag.PROTECT_LWC.applies(field, player)) {
            event.setCancelled(true);
            ChatBlock.send((CommandSender)player, "notAllowedToCreateLWC", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProtectionRemove(LWCProtectionDestroyEvent event) {
        Player player = event.getPlayer();
        Block block = event.getProtection().getBlock();
        if (player == null || block == null) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PROTECT_LWC);
        if (field != null && FieldFlag.PROTECT_LWC.applies(field, player)) {
            event.setCancelled(true);
            ChatBlock.send((CommandSender)player, "notAllowedToDestroyLWC", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getProtection().getBlock();
        if (player == null || block == null) {
            return;
        }
        this.plugin.getSnitchManager().recordSnitchLWC(player, block, event.getActions());
    }
}

