/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import java.util.List;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class PSBlockListener
implements Listener {
    private PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockFade(BlockFadeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getForceFieldManager().isField(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockSpreadEvent(BlockSpreadEvent event) {
        if (event.getBlock() == null) {
            return;
        }
        Block source = event.getSource();
        Block destination = event.getBlock();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(source.getWorld())) {
            return;
        }
        if (Helper.isSameBlock(source.getLocation(), destination.getLocation())) {
            return;
        }
        Field destField = this.plugin.getForceFieldManager().getEnabledSourceField(destination.getLocation(), FieldFlag.PREVENT_FIRE);
        if (destField == null) {
            return;
        }
        Field sourceField = this.plugin.getForceFieldManager().getEnabledSourceField(source.getLocation(), FieldFlag.PREVENT_FIRE);
        if (sourceField == null || !sourceField.getOwner().equalsIgnoreCase(destField.getOwner())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockFromTo(BlockFromToEvent event) {
        Field destField;
        if (event.isCancelled()) {
            return;
        }
        Block source = event.getBlock();
        Block destination = event.getToBlock();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(source.getWorld())) {
            return;
        }
        if (Helper.isSameBlock(source.getLocation(), destination.getLocation())) {
            return;
        }
        Field blockField = this.plugin.getForceFieldManager().getField(source);
        if (blockField != null) {
            event.setCancelled(true);
        }
        if ((destField = this.plugin.getForceFieldManager().getEnabledSourceField(destination.getLocation(), FieldFlag.PREVENT_FLOW)) == null) {
            return;
        }
        Field sourceField = this.plugin.getForceFieldManager().getEnabledSourceField(source.getLocation(), FieldFlag.PREVENT_FLOW);
        if (sourceField == null || !sourceField.getOwner().equalsIgnoreCase(destField.getOwner())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null) {
            return;
        }
        if (player != null) {
            this.plugin.getSnitchManager().recordSnitchIgnite(player, block);
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_FIRE)) != null) {
            if (player == null) {
                event.setCancelled(true);
            } else if (FieldFlag.PREVENT_FIRE.applies(field, player)) {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnFire(player, block, field);
            }
        }
        if (player != null && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TELEPORT_ON_FIRE)) != null && FieldFlag.TELEPORT_ON_FIRE.applies(field, player)) {
            event.setCancelled(true);
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceFire");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block block = this.plugin.getForceFieldManager().touchingFieldBlock(event.getBlock());
        if (block == null) {
            return;
        }
        final Field field = this.plugin.getForceFieldManager().getField(block);
        if (!this.plugin.getForceFieldManager().powersField(field, event.getBlock())) {
            return;
        }
        if (!field.hasFlag(FieldFlag.ENABLE_WITH_REDSTONE)) {
            return;
        }
        if (event.getNewCurrent() > event.getOldCurrent()) {
            if (field.isDisabled()) {
                field.setDisabled(false);
            }
            PreciousStones.debug("redstone enabled", new Object[0]);
        } else if (event.getNewCurrent() == 0) {
            if (!field.isDisabled() && !field.isRented()) {
                field.setDisabled(true);
            }
            PreciousStones.debug("redstone disabled", new Object[0]);
        }
        if (!(field.getSettings().hasDefaultFlag(FieldFlag.LAUNCH) || field.getSettings().hasDefaultFlag(FieldFlag.CANNON) || field.getSettings().hasDefaultFlag(FieldFlag.POTIONS) || field.getSettings().hasDefaultFlag(FieldFlag.TRANSLOCATION) || field.getSettings().hasDefaultFlag(FieldFlag.CONFISCATE_ITEMS))) {
            return;
        }
        if (field.hasFlag(FieldFlag.TRANSLOCATION) && !field.isTranslocating()) {
            if (field.isNamed()) {
                if (field.isDisabled()) {
                    if (!field.isOverRedstoneMax()) {
                        this.plugin.getTranslocationManager().applyTranslocation(field);
                        field.setDisabled(false);
                        field.dirtyFlags();
                    }
                } else {
                    this.plugin.getTranslocationManager().clearTranslocation(field);
                    field.setDisabled(true);
                    field.dirtyFlags();
                }
            }
            return;
        }
        Set<Player> inhabitants = this.plugin.getForceFieldManager().getFieldInhabitants(field);
        for (final Player player : inhabitants) {
            if (player == null) continue;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (field.isDisabled()) {
                        if (FieldFlag.POTIONS.applies(field, player)) {
                            PSBlockListener.this.plugin.getPotionManager().removePotions(player, field);
                        }
                        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
                            PSBlockListener.this.plugin.getConfiscationManager().returnItems(player);
                        }
                    } else {
                        if (FieldFlag.LAUNCH.applies(field, player)) {
                            PSBlockListener.this.plugin.getVelocityManager().launchPlayer(player, field);
                        }
                        if (FieldFlag.CANNON.applies(field, player)) {
                            PSBlockListener.this.plugin.getVelocityManager().shootPlayer(player, field);
                        }
                        if (FieldFlag.POTIONS.applies(field, player)) {
                            PSBlockListener.this.plugin.getPotionManager().applyPotions(player, field);
                        }
                        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
                            PSBlockListener.this.plugin.getConfiscationManager().confiscateItems(field, player);
                        }
                    }
                }
            }, 0L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null || player == null) {
            return;
        }
        this.handleBreak(player, block, (Cancellable)event);
    }

    private void handleBreak(Player player, Block block, Cancellable event) {
        Field f;
        FieldSign s;
        Field field;
        if (this.plugin.getCuboidManager().hasOpenCuboid(player) && !this.plugin.getForceFieldManager().isField(block)) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(block.getWorld())) {
            return;
        }
        if (this.plugin.getSettingsManager().isBypassBlock(block)) {
            return;
        }
        this.plugin.getSnitchManager().recordSnitchBlockBreak(player, block);
        if (this.plugin.getSettingsManager().isPreventDestroyEverywhere(block.getWorld().getName()) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy") && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy-everywhere")) {
            boolean isAllowBlock = false;
            Field field2 = this.plugin.getForceFieldManager().getField(block);
            if (field2 != null && (field2.hasFlag(FieldFlag.ALLOW_DESTROY) || field2.hasFlag(FieldFlag.ALLOW_PLACE))) {
                isAllowBlock = true;
            }
            if (!isAllowBlock) {
                field2 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.ALLOW_DESTROY);
                if (field2 != null) {
                    boolean applies = FieldFlag.ALLOW_DESTROY.applies(field2, player);
                    if (!applies) {
                        event.setCancelled(true);
                        return;
                    }
                } else {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (SignHelper.cannotBreakFieldSign(block, player)) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getForceFieldManager().isField(block)) {
            Field field3 = this.plugin.getForceFieldManager().getField(block);
            if (this.breakingFieldChecks(player, block, field3, event)) {
                return;
            }
        } else if (this.plugin.getUnbreakableManager().isUnbreakable(block)) {
            if (this.plugin.getUnbreakableManager().isOwner(block, player.getName())) {
                this.plugin.getCommunicationManager().notifyDestroyU(player, block);
                this.plugin.getUnbreakableManager().release(block);
            } else if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unbreakable")) {
                this.plugin.getCommunicationManager().notifyBypassDestroyU(player, block);
                this.plugin.getUnbreakableManager().release(block);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyU(player, block);
            }
            return;
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_DESTROY)) != null && !field.getSettings().inDestroyBlacklist(block) && FieldFlag.PREVENT_DESTROY.applies(field, player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                this.plugin.getCommunicationManager().notifyBypassDestroy(player, block, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyArea(player, block, field);
                return;
            }
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.GRIEF_REVERT)) != null && !this.plugin.getPermissionsManager().lwcProtected(player, block) && !this.plugin.getPermissionsManager().locketteProtected(player, block)) {
            if (FieldFlag.GRIEF_REVERT.applies(field, player)) {
                if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy") || field.getSettings().canGrief(block.getTypeId())) {
                    PreciousStones.debug("bypassed", new Object[0]);
                    if (field.getSettings().canGrief(block.getTypeId())) {
                        PreciousStones.debug("can-grief", new Object[0]);
                    }
                    this.plugin.getCommunicationManager().notifyBypassDestroy(player, block, field);
                    this.plugin.getStorageManager().deleteBlockGrief(block);
                    return;
                }
                PreciousStones.debug("is grief", new Object[0]);
                if (!this.plugin.getSettingsManager().isGriefUndoBlackListType(block.getTypeId())) {
                    PreciousStones.debug("adding block", new Object[0]);
                    boolean clear = !field.hasFlag(FieldFlag.GRIEF_REVERT_DROP);
                    this.plugin.getGriefUndoManager().addBlock(field, block, clear);
                    this.plugin.getStorageManager().offerGrief(field);
                    if (clear) {
                        PreciousStones.debug("cleared", new Object[0]);
                        event.setCancelled(true);
                    }
                }
            } else {
                this.plugin.getStorageManager().deleteBlockGrief(block);
            }
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) != null && field.isNamed()) {
            this.plugin.getTranslocationManager().removeBlock(field, block);
            this.plugin.getTranslocationManager().flashFieldBlock(field, player);
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.TELEPORT_ON_BLOCK_BREAK)) != null && FieldFlag.TELEPORT_ON_BLOCK_BREAK.applies(field, player)) {
            event.setCancelled(true);
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceBreak");
        }
        if ((s = SignHelper.getFieldSign(block)) != null && (f = s.getField()) != null && !s.isBuyable()) {
            f.clearRents();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean breakingFieldChecks(Player player, Block block, Field field, Cancellable event) {
        int count;
        if (field.isRented() || field.isBought()) {
            ChatBlock.send((CommandSender)player, "fieldSignCannotDestroy", new Object[0]);
            event.setCancelled(true);
            return true;
        }
        field.unHide();
        if (!this.plugin.getSettingsManager().isFieldType(block)) {
            return false;
        }
        if (this.plugin.getCuboidManager().isOpenCuboidField(player, block)) {
            this.plugin.getCuboidManager().cancelOpenCuboid(player, block);
            this.removeAndRefundBlock(player, block, field, event);
            return true;
        }
        if (field.isOwner(player.getName())) {
            this.plugin.getCommunicationManager().notifyDestroyFF(player, block);
        } else if (field.hasFlag(FieldFlag.BREAKABLE)) {
            this.plugin.getCommunicationManager().notifyDestroyBreakableFF(player, block);
        } else if (field.hasFlag(FieldFlag.ALLOWED_CAN_BREAK)) {
            if (!this.plugin.getForceFieldManager().isAllowed(block, player.getName())) {
                event.setCancelled(true);
                return true;
            }
            this.plugin.getCommunicationManager().notifyDestroyOthersFF(player, block);
        } else {
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.forcefield")) {
                this.plugin.getCommunicationManager().warnDestroyFF(player, block);
                event.setCancelled(true);
                return true;
            }
            this.plugin.getCommunicationManager().notifyBypassDestroyFF(player, block);
        }
        if (this.plugin.getForceFieldManager().hasSubFields(field)) {
            ChatBlock.send((CommandSender)player, "cannotRemoveWithSubplots", new Object[0]);
            event.setCancelled(true);
            return true;
        }
        if (field.hasFlag(FieldFlag.TRANSLOCATION) && field.isNamed() && (count = this.plugin.getStorageManager().appliedTranslocationCount(field)) > 0) {
            this.plugin.getTranslocationManager().clearTranslocation(field);
        }
        this.removeAndRefundBlock(player, block, field, event);
        return true;
    }

    private void removeAndRefundBlock(Player player, Block block, Field field, Cancellable event) {
        int refund;
        PreciousStones.debug("releasing field", new Object[0]);
        if (field.hasFlag(FieldFlag.SINGLE_USE)) {
            event.setCancelled(true);
            this.plugin.getForceFieldManager().releaseWipe(block);
        } else if (block.getTypeId() == field.getTypeId()) {
            if (this.plugin.getSettingsManager().isFragileBlock(block)) {
                PreciousStones.debug("fragile block broken", new Object[0]);
                event.setCancelled(true);
                this.plugin.getForceFieldManager().release(block);
            } else {
                PreciousStones.debug("silent break", new Object[0]);
                event.setCancelled(false);
                this.plugin.getForceFieldManager().releaseNoDrop(block);
            }
        } else if (this.plugin.getSettingsManager().isFragileBlock(new BlockTypeEntry(field.getTypeId(), field.getData()))) {
            PreciousStones.debug("fragile block broken", new Object[0]);
            this.plugin.getForceFieldManager().releaseNoClean(field);
        } else {
            PreciousStones.debug("silent break", new Object[0]);
            this.plugin.getForceFieldManager().releaseNoDrop(block);
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.purchase") && !this.plugin.getSettingsManager().isNoRefunds() && (refund = field.getSettings().getRefund()) > -1) {
            if (field.isChild() || field.isParent()) {
                Field parent = field;
                if (field.isChild()) {
                    parent = field.getParent();
                }
                this.plugin.getForceFieldManager().refund(player, refund);
                for (Field child : parent.getChildren()) {
                    refund = child.getSettings().getRefund();
                    this.plugin.getForceFieldManager().refund(player, refund);
                }
            } else {
                this.plugin.getForceFieldManager().refund(player, refund);
            }
        }
        this.plugin.getVisualizationManager().revert(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null || player == null) {
            return;
        }
        this.handlePlace(player, block, (Cancellable)event);
    }

    private void handlePlace(final Player player, final Block block, Cancellable event) {
        FieldSettings settings;
        FieldSettings fs;
        boolean allowed;
        Field field;
        Block fieldBlock;
        if (this.plugin.getSettingsManager().isBlacklistedWorld(block.getWorld())) {
            return;
        }
        if (this.plugin.getSettingsManager().isBypassBlock(block)) {
            return;
        }
        if (event instanceof BlockPlaceEvent) {
            BlockPlaceEvent e = (BlockPlaceEvent)event;
            BlockState state = e.getBlockReplacedState();
            Field existingField = this.plugin.getForceFieldManager().getField(state.getLocation());
            if (existingField != null && state.getTypeId() > 0) {
                if (!this.breakingFieldChecks(player, block, existingField, event)) {
                    event.setCancelled(true);
                }
                return;
            }
        }
        if ((fieldBlock = this.plugin.getForceFieldManager().touchingFieldBlock(block)) != null && (field = this.plugin.getForceFieldManager().getField(fieldBlock)).hasFlag(FieldFlag.ENABLE_WITH_REDSTONE) && !(allowed = this.plugin.getForceFieldManager().isAllowed(field, player.getName()))) {
            ChatBlock.send((CommandSender)player, "cannotPlaceNextToRedstone", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            if (!this.plugin.getSettingsManager().isFieldType(block)) {
                event.setCancelled(true);
                return;
            }
            CuboidEntry ce = this.plugin.getCuboidManager().getOpenCuboid(player);
            fs = this.plugin.getSettingsManager().getFieldSettings(block);
            if (ce.getField().getSettings().getMixingGroup() != fs.getMixingGroup()) {
                event.setCancelled(true);
                ChatBlock.send((CommandSender)player, "fieldsDontMix", new Object[0]);
                return;
            }
        }
        if (this.plugin.getSettingsManager().isPreventPlaceEverywhere(block.getWorld().getName()) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place") && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place-everywhere")) {
            boolean isAllowBlock = false;
            if (this.plugin.getSettingsManager().isFieldType(block) && this.plugin.getSettingsManager().getFieldSettings(block) != null && ((fs = this.plugin.getSettingsManager().getFieldSettings(block)).hasDefaultFlag(FieldFlag.ALLOW_DESTROY) || fs.hasDefaultFlag(FieldFlag.ALLOW_PLACE))) {
                isAllowBlock = true;
            }
            if (!isAllowBlock) {
                Field field2 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.ALLOW_PLACE);
                if (field2 != null) {
                    boolean applies = FieldFlag.ALLOW_PLACE.applies(field2, player);
                    if (!applies) {
                        event.setCancelled(true);
                        return;
                    }
                } else {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        boolean isDisabled = false;
        if (this.plugin.getSettingsManager().isSneakPlaceFields() && !player.isSneaking()) {
            isDisabled = true;
        }
        if (this.plugin.getSettingsManager().isSneakNormalBlock() && player.isSneaking()) {
            isDisabled = true;
        }
        if ((settings = this.plugin.getSettingsManager().getFieldSettings(block)) != null && settings.hasDefaultFlag(FieldFlag.SNEAK_TO_PLACE)) {
            boolean bl = isDisabled = !player.isSneaking();
        }
        if (this.plugin.getPlayerManager().getPlayerEntry(player.getName()).isDisabled()) {
            isDisabled = true;
        }
        if (!isDisabled && this.plugin.getSettingsManager().isFieldType(block) && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.create.forcefield")) {
            if (this.placingFieldChecks(player, block, event)) {
                this.plugin.getForceFieldManager().add(block, player, (BlockPlaceEvent)event);
            }
            if (event.isCancelled()) {
                return;
            }
        } else {
            Field field3;
            if (!isDisabled && this.plugin.getSettingsManager().isUnbreakableType(block) && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.create.unbreakable")) {
                Field conflictField = this.plugin.getForceFieldManager().unbreakableConflicts(block, player);
                if (conflictField != null) {
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                        if (this.plugin.getUnbreakableManager().add(block, player)) {
                            this.plugin.getCommunicationManager().notifyBypassPlaceU(player, block, conflictField);
                        }
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnConflictU(player, block, conflictField);
                    }
                } else if (this.plugin.getUnprotectableManager().touchingUnprotectableBlock(block)) {
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                        if (this.plugin.getUnbreakableManager().add(block, player)) {
                            this.plugin.getCommunicationManager().notifyBypassTouchingUnprotectable(player, block);
                        }
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnUnbreakablePlaceTouchingUnprotectable(player, block);
                    }
                } else if (this.plugin.getUnbreakableManager().add(block, player)) {
                    this.plugin.getCommunicationManager().notifyPlaceU(player, block);
                }
                return;
            }
            if (this.plugin.getSettingsManager().isUnprotectableType(block)) {
                Field field4;
                Block fieldblock;
                Block unbreakableblock = this.plugin.getUnbreakableManager().touchingUnbrakableBlock(block);
                if (unbreakableblock != null) {
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                        this.plugin.getCommunicationManager().notifyUnbreakableBypassUnprotectableTouching(player, block, unbreakableblock);
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnUnbreakablePlaceUnprotectableTouching(player, block, unbreakableblock);
                        return;
                    }
                }
                if ((fieldblock = this.plugin.getForceFieldManager().touchingFieldBlock(block)) != null) {
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                        this.plugin.getCommunicationManager().notifyFieldBypassUnprotectableTouching(player, block, fieldblock);
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnFieldPlaceUnprotectableTouching(player, block, fieldblock);
                        return;
                    }
                }
                if ((field4 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_UNPROTECTABLE)) != null) {
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                        this.plugin.getCommunicationManager().notifyBypassPlaceUnprotectableInField(player, block, field4);
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnPlaceUnprotectableInField(player, block, field4);
                    }
                }
                if ((field4 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) != null) {
                    ChatBlock.send((CommandSender)player, "noUnbreakableInsideTranslocation", new Object[0]);
                    event.setCancelled(true);
                }
            }
            if (block.getTypeId() == 54) {
                Field field4;
                Field field32;
                Field field2;
                Field field1;
                Field field5 = this.plugin.getForceFieldManager().getConflictSourceField(block.getLocation(), player.getName(), FieldFlag.ALL);
                boolean conflicted = false;
                if (block.getRelative(BlockFace.EAST).getTypeId() == 54 && (field1 = this.plugin.getForceFieldManager().getConflictSourceField(block.getRelative(BlockFace.EAST).getLocation(), player.getName(), FieldFlag.ALL)) != null && (field5 == null || field5 != field1)) {
                    conflicted = true;
                }
                if (block.getRelative(BlockFace.WEST).getTypeId() == 54 && (field2 = this.plugin.getForceFieldManager().getConflictSourceField(block.getRelative(BlockFace.WEST).getLocation(), player.getName(), FieldFlag.ALL)) != null && (field5 == null || field5 != field2)) {
                    conflicted = true;
                }
                if (block.getRelative(BlockFace.NORTH).getTypeId() == 54 && (field32 = this.plugin.getForceFieldManager().getConflictSourceField(block.getRelative(BlockFace.NORTH).getLocation(), player.getName(), FieldFlag.ALL)) != null && (field5 == null || field5 != field32)) {
                    conflicted = true;
                }
                if (block.getRelative(BlockFace.SOUTH).getTypeId() == 54 && (field4 = this.plugin.getForceFieldManager().getConflictSourceField(block.getRelative(BlockFace.SOUTH).getLocation(), player.getName(), FieldFlag.ALL)) != null && (field5 == null || field5 != field4)) {
                    conflicted = true;
                }
                if (conflicted) {
                    ChatBlock.send((CommandSender)player, "noChestNextToField", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            if ((field3 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_PLACE)) != null && !field3.getSettings().inPlaceBlacklist(block) && FieldFlag.PREVENT_PLACE.applies(field3, player)) {
                if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                    this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field3);
                } else {
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().warnPlace(player, block, field3);
                }
            }
            if ((field3 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.GRIEF_REVERT)) != null) {
                if (FieldFlag.GRIEF_REVERT.applies(field3, player)) {
                    if (field3.hasFlag(FieldFlag.PLACE_GRIEF)) {
                        if (!this.plugin.getSettingsManager().isGriefUndoBlackListType(block.getTypeId())) {
                            if (event instanceof BlockPlaceEvent) {
                                BlockPlaceEvent e = (BlockPlaceEvent)event;
                                BlockState blockState = e.getBlockReplacedState();
                                this.plugin.getGriefUndoManager().addBlock(field3, blockState);
                            }
                            this.plugin.getStorageManager().offerGrief(field3);
                        }
                    } else if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                        this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field3);
                        this.plugin.getStorageManager().deleteBlockGrief(block);
                    } else {
                        event.setCancelled(true);
                        this.plugin.getCommunicationManager().warnPlace(player, block, field3);
                    }
                } else {
                    this.plugin.getStorageManager().deleteBlockGrief(block);
                }
            }
            if ((field3 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) != null && FieldFlag.TRANSLOCATION.applies(field3, player) && field3.getSettings().canTranslocate(new BlockTypeEntry(block))) {
                if (field3.getName().length() == 0) {
                    ChatBlock.send((CommandSender)player, "translocatorNameToBegin", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (field3.isOverTranslocationMax(1)) {
                    ChatBlock.send((CommandSender)player, "translocationReachedSize", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                final Field finalField = field3;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        PSBlockListener.this.plugin.getTranslocationManager().addBlock(finalField, block);
                        PSBlockListener.this.plugin.getTranslocationManager().flashFieldBlock(finalField, player);
                    }
                }, 10L);
            }
            if ((field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.TELEPORT_ON_BLOCK_PLACE)) != null && FieldFlag.TELEPORT_ON_BLOCK_PLACE.applies(field3, player)) {
                event.setCancelled(true);
                this.plugin.getTeleportationManager().teleport((Entity)player, field3, "teleportAnnouncePlace");
            }
        }
        this.plugin.getSnitchManager().recordSnitchBlockPlace(player, block);
    }

    private boolean placingFieldChecks(Player player, Block block, Cancellable event) {
        List<Field> fields;
        Block floor;
        Block foundblock;
        boolean hasPlayers;
        Field conflictField;
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(block);
        if (fs == null) {
            return false;
        }
        if (!fs.isSurface(block)) {
            ChatBlock.send((CommandSender)player, "surfaceWarning", fs.getSurfaceString());
            event.setCancelled(true);
            return false;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_PLACE);
        if (field != null && !field.getSettings().inPlaceBlacklist(block) && FieldFlag.PREVENT_PLACE.applies(field, player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field);
            } else {
                this.plugin.getCommunicationManager().warnPlace(player, block, field);
                event.setCancelled(true);
                return false;
            }
        }
        if ((conflictField = this.plugin.getForceFieldManager().fieldConflicts(block, player)) != null) {
            event.setCancelled(true);
            this.plugin.getCommunicationManager().warnConflictFF(player, block, conflictField);
            return false;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.world") && !fs.allowedWorld(block.getWorld())) {
            return false;
        }
        if (!(fs.getRequiredPermission().isEmpty() || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.required-permission") || this.plugin.getPermissionsManager().has(player, fs.getRequiredPermission()))) {
            return false;
        }
        if (this.plugin.getUnprotectableManager().touchingUnprotectableBlock(block)) {
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                this.plugin.getCommunicationManager().warnFieldPlaceTouchingUnprotectable(player, block);
                event.setCancelled(true);
                return false;
            }
            this.plugin.getCommunicationManager().notifyBypassTouchingUnprotectable(player, block);
        }
        if (fs.hasDefaultFlag(FieldFlag.MUST_BE_ABOVE) && block.getLocation().getBlockY() <= fs.getMustBeAbove()) {
            ChatBlock.send((CommandSender)player, "mustBeAbove", fs.getMustBeAbove());
            event.setCancelled(true);
            return false;
        }
        if (fs.hasDefaultFlag(FieldFlag.MUST_BE_BELOW) && block.getLocation().getBlockY() >= fs.getMustBeBelow()) {
            ChatBlock.send((CommandSender)player, "mustBeBelow", fs.getMustBeBelow());
            event.setCancelled(true);
            return false;
        }
        if (fs.hasDefaultFlag(FieldFlag.CONFISCATE_ITEMS)) {
            Block north = block.getRelative(BlockFace.NORTH);
            if (this.plugin.getForceFieldManager().isField(north)) {
                ChatBlock.send((CommandSender)player, "noConfiscatingBelowField", new Object[0]);
                event.setCancelled(true);
                return false;
            }
            if (this.plugin.getUnbreakableManager().isUnbreakable(north)) {
                ChatBlock.send((CommandSender)player, "noConfiscatingBelowUnbreakable", new Object[0]);
                event.setCancelled(true);
                return false;
            }
        }
        if (fs.hasDefaultFlag(FieldFlag.NO_PLAYER_PLACE) && (hasPlayers = this.plugin.getForceFieldManager().fieldTouchesPlayers(block, player))) {
            ChatBlock.send((CommandSender)player, "noFieldNearPlayer", new Object[0]);
            event.setCancelled(true);
            return false;
        }
        if (fs.hasDefaultFlag(FieldFlag.WORLDGUARD_REPELLENT) && this.plugin.getWorldGuardManager().isWGRegion(block)) {
            ChatBlock.send((CommandSender)player, "noPlaceInWG", new Object[0]);
            event.setCancelled(true);
            return false;
        }
        if (fs.hasDefaultFlag(FieldFlag.PREVENT_UNPROTECTABLE) && (foundblock = this.plugin.getUnprotectableManager().existsUnprotectableBlock(block)) != null) {
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                this.plugin.getCommunicationManager().warnPlaceFieldInUnprotectable(player, foundblock, block);
                event.setCancelled(true);
                return false;
            }
            this.plugin.getCommunicationManager().notifyBypassFieldInUnprotectable(player, foundblock, block);
        }
        if (fs.hasDefaultFlag(FieldFlag.FORESTER) && !fs.isFertileType((floor = block.getRelative(BlockFace.DOWN)).getTypeId()) && floor.getTypeId() != fs.getGroundBlock()) {
            ChatBlock.send((CommandSender)player, "foresterNeedsFertile", fs.getTitle());
            return false;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.allowed-only-inside") && fs.hasAllowedOnlyInside()) {
            fields = this.plugin.getForceFieldManager().getSourceFields(block.getLocation(), FieldFlag.ALL);
            boolean allowed = false;
            for (Field surroundingField : fields) {
                if (!fs.isAllowedOnlyInside(surroundingField)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                ChatBlock.send((CommandSender)player, "fieldInsideAllowedInside", fs.getTitle(), fs.getAllowedOnlyInsideString());
                event.setCancelled(true);
                return false;
            }
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.allowed-only-outside") && fs.hasAllowedOnlyOutside()) {
            fields = this.plugin.getForceFieldManager().getSourceFields(block.getLocation(), FieldFlag.ALL);
            boolean notAllowed = false;
            for (Field surroundingField : fields) {
                if (!fs.isAllowedOnlyOutside(surroundingField)) continue;
                notAllowed = true;
                break;
            }
            if (notAllowed) {
                ChatBlock.send((CommandSender)player, "fieldOutsideAllowedOutside", fs.getTitle(), fs.getAllowedOnlyOutsideString());
                event.setCancelled(true);
                return false;
            }
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) != null) {
            ChatBlock.send((CommandSender)player, "translocationNoFields", new Object[0]);
            event.setCancelled(true);
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockGrow(BlockGrowEvent event) {
        if (event.getBlock() == null) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getBlock().getLocation(), FieldFlag.NO_GROWTH);
        if (field != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(piston.getWorld())) {
            return;
        }
        Field pistonField = this.plugin.getForceFieldManager().getEnabledSourceField(piston.getLocation(), FieldFlag.PREVENT_DESTROY);
        List blocks = event.getBlocks();
        for (Block block : blocks) {
            if (SignHelper.cannotBreakFieldSign(block, null)) {
                event.setCancelled(true);
                PreciousStones.debug("Cancelling field sign move", new Object[0]);
                return;
            }
            if (this.plugin.getForceFieldManager().isField(block)) {
                PreciousStones.debug("Cancelling field move", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getSettingsManager().isUnbreakableType(block) && this.plugin.getUnbreakableManager().isUnbreakable(block)) {
                event.setCancelled(true);
                PreciousStones.debug("Cancelling unbreakable move", new Object[0]);
                return;
            }
            Field blockField = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_DESTROY);
            if (pistonField != null && blockField != null && blockField.isAllowed(pistonField.getOwner()) || blockField == null || blockField.getSettings().inDestroyBlacklist(block)) continue;
            event.setCancelled(true);
            PreciousStones.debug("Cancelling field conflict move", new Object[0]);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block block;
        boolean unprotected = false;
        Block piston = event.getBlock();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(piston.getWorld())) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(piston.getLocation(), FieldFlag.PREVENT_DESTROY);
        if (field == null) {
            unprotected = true;
        }
        if (SignHelper.cannotBreakFieldSign(block = piston.getRelative(event.getDirection()).getRelative(event.getDirection()), null)) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getForceFieldManager().isField(block)) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getSettingsManager().isUnbreakableType(block) && this.plugin.getUnbreakableManager().isUnbreakable(block)) {
            event.setCancelled(true);
            return;
        }
        if (unprotected && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_DESTROY)) != null && !field.getSettings().inDestroyBlacklist(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        String[] lines;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        FieldSign s = new FieldSign(block, lines = event.getLines(), player);
        if (s.isValid()) {
            Block fieldBlock = SignHelper.getAttachedBlock(block);
            FieldSign attachedFieldSign = SignHelper.getAttachedFieldSign(fieldBlock);
            if (attachedFieldSign != null) {
                ChatBlock.send((CommandSender)player, "fieldSignOnlyOne", new Object[0]);
                event.setCancelled(true);
                return;
            }
            event.setLine(0, ChatColor.BLACK + "" + ChatColor.BOLD + ChatColor.stripColor((String)lines[0]));
            if (s.isRentable()) {
                ChatBlock.send((CommandSender)player, "fieldSignRentCreated", new Object[0]);
            }
            if (s.isBuyable()) {
                ChatBlock.send((CommandSender)player, "fieldSignBuyCreated", new Object[0]);
            }
        } else if (s.isFieldSign()) {
            ChatBlock.send((CommandSender)player, s.getFailReason(), new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        if (event.getInventory() == null || !(event.getPlayer() instanceof Player)) {
            return;
        }
        InventoryType type = event.getInventory().getType();
        if (!(type.equals((Object)InventoryType.PLAYER) || type.equals((Object)InventoryType.ENDER_CHEST) || type.equals((Object)InventoryType.ANVIL))) {
            Player player;
            Location location;
            InventoryHolder holder = event.getInventory().getHolder();
            if (holder == null) {
                return;
            }
            if (holder instanceof Horse) {
                if (event.getPlayer().equals(((Horse)holder).getOwner())) {
                    return;
                }
                location = ((Horse)holder).getLocation();
            } else {
                location = holder instanceof Entity ? ((Entity)holder).getLocation() : (holder instanceof DoubleChest ? ((DoubleChest)holder).getLocation() : (holder instanceof BlockState ? ((BlockState)holder).getBlock().getLocation() : (holder instanceof Block ? ((Block)holder).getLocation() : event.getPlayer().getLocation())));
            }
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(location, FieldFlag.PROTECT_INVENTORIES);
            if (field != null && FieldFlag.PROTECT_INVENTORIES.applies(field, player = (Player)event.getPlayer())) {
                event.setCancelled(true);
                ChatBlock.send((CommandSender)player, "inventoryDeny", new Object[0]);
            }
        }
    }
}

