/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.RentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.SnitchEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Unbreakable;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.oliwali.HawkEye.util.HawkEyeAPI;

public class CommunicationManager {
    private PreciousStones plugin;
    private boolean useHawkEye;
    private HashMap<String, ChatBlock> chatBlocks = new HashMap();

    public CommunicationManager() {
        this.plugin = PreciousStones.getInstance();
        this.useHawkEye = this.useHawkEye();
    }

    private boolean useHawkEye() {
        Plugin plug;
        return this.plugin.getSettingsManager().isLogToHawkEye() && (plug = this.plugin.getServer().getPluginManager().getPlugin("HawkEye")) != null;
    }

    public void debug(String msg) {
        PreciousStones.log("[debug] ***************** {message}", msg);
    }

    public ChatBlock getChatBlock(Player player) {
        ChatBlock cb = this.chatBlocks.get(player.getName());
        if (cb == null) {
            cb = new ChatBlock();
            this.chatBlocks.put(player.getName(), cb);
        }
        return cb;
    }

    public ChatBlock getNewChatBlock(CommandSender sender) {
        ChatBlock cb = new ChatBlock();
        if (sender instanceof Player) {
            this.chatBlocks.put(sender.getName(), cb);
        } else {
            this.chatBlocks.put("console", cb);
        }
        return cb;
    }

    private boolean canNotify(Player player) {
        return !this.plugin.getPermissionsManager().has(player, "preciousstones.override.notify") || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.isadmin");
    }

    private boolean canWarn(Player player) {
        return !this.plugin.getPermissionsManager().has(player, "preciousstones.override.warn") || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.isadmin");
    }

    private boolean canAlert(Player player) {
        return !this.plugin.getSettingsManager().isDisableAlertsForAdmins() || !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.isadmin");
    }

    private boolean canBypassAlert(Player player) {
        return !this.plugin.getSettingsManager().isDisableBypassAlertsForAdmins() || !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.isadmin");
    }

    public void logPayment(String owner, String renter, FieldSign s) {
        if (this.plugin.getSettingsManager().isLogRentsAndPurchases()) {
            PreciousStones.log("logPayment", renter, s.getPeriod(), owner, s.getField().getType(), s.getPrice(), s.getItem() != null ? s.getItem().getFriendly() : "", s.getField().getCoords());
        }
    }

    public void logPaymentCollect(String owner, String renter, FieldSign s) {
        if (this.plugin.getSettingsManager().isLogRentsAndPurchases()) {
            PreciousStones.log("logPaymentCollect", owner, s.getPrice(), s.getItem() != null ? s.getItem().getFriendly() : "", renter, s.getField().getCoords());
        }
    }

    public void logPurchase(String owner, String renter, FieldSign s) {
        if (this.plugin.getSettingsManager().isLogRentsAndPurchases()) {
            PreciousStones.log("logPurchase", renter, owner, s.getField().getType(), s.getPrice(), s.getItem() != null ? s.getItem().getFriendly() : "", s.getField().getCoords());
        }
    }

    public void logPurchaseCollect(String owner, String renter, FieldSign s) {
        if (this.plugin.getSettingsManager().isLogRentsAndPurchases()) {
            PreciousStones.log("logPurchaseCollect", owner, s.getPrice(), s.getItem() != null ? s.getItem().getFriendly() : "", renter, s.getField().getCoords());
        }
    }

    public void notifyPlaceU(Player player, Block unbreakableblock) {
        Unbreakable unbreakable = this.plugin.getUnbreakableManager().getUnbreakable(unbreakableblock);
        if (this.plugin.getSettingsManager().isNotifyPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyUnbreakablePlaced", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Place", (Player)player, (Location)unbreakableblock.getLocation(), (String)unbreakableblock.getType().toString());
            } else {
                PreciousStones.log("logUnbreakablePlace", player.getName(), unbreakable.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logUnbreakablePlace", player.getName(), unbreakable.getDetails());
        }
    }

    public void notifyRollBack(Field field, int count) {
        if (field == null) {
            return;
        }
        Player player = this.plugin.getServer().getPlayerExact(field.getOwner());
        if (player != null && this.plugin.getSettingsManager().isNotifyRollback() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyRollbackGrief", count, field.getCoords());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogRollback()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Grief-Reversion", (Player)player, (Location)field.getLocation(), (String)("blocks:" + count));
            } else {
                PreciousStones.log("logBlockReverted", field.getOwner(), field.getSettings().getTitle(), count, field.getCoords());
            }
        }
    }

    public boolean notifyStoredTranslocations(Player player) {
        ChatBlock cb = this.getNewChatBlock((CommandSender)player);
        cb.setAlignment("l", "c");
        cb.addRow("  " + ChatColor.YELLOW + "Name", "Blocks");
        Map<String, Integer> details = this.plugin.getStorageManager().getTranslocationDetails(player.getName());
        for (String name : details.keySet()) {
            int count = details.get(name);
            cb.addRow("  " + ChatColor.WHITE + name, ChatColor.WHITE + " " + count);
        }
        if (cb.size() > 1) {
            ChatBlock.sendBlank((CommandSender)player);
            ChatBlock.saySingle((CommandSender)player, "sepStoredTranslocations", new Object[0]);
            ChatBlock.sendBlank((CommandSender)player);
            boolean more = cb.sendBlock((CommandSender)player, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.send((CommandSender)player, "moreNextPage", new Object[0]);
            }
            ChatBlock.sendBlank((CommandSender)player);
            return true;
        }
        ChatBlock.send((CommandSender)player, "translocationNotFound", new Object[0]);
        return false;
    }

    public void notifyApplyTranslocation(Field field, Player player, int count) {
        if (field == null) {
            return;
        }
        if (player != null && this.plugin.getSettingsManager().isNotifyTranslocation() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyTranslocatorEnabled", field.getName());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogTranslocation()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Translocation", (Player)player, (Location)field.getLocation(), (String)("blocks:" + count));
            } else {
                PreciousStones.log("logTranslocationTranslocated", field.getOwner(), field.getName(), count, field.getCoords());
            }
        }
    }

    public void notifyClearTranslocation(Field field, Player player, int count) {
        if (field == null) {
            return;
        }
        if (player != null && this.plugin.getSettingsManager().isNotifyTranslocation() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyTranslocatorDisabled", field.getName());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogTranslocation()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Stored", (Player)player, (Location)field.getLocation(), (String)"");
            } else {
                PreciousStones.log("logTranslocationStored", field.getOwner(), field.getName(), count, field.getCoords());
            }
        }
    }

    public void notifyPlaceFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyFieldPlaced", fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Place", (Player)player, (Location)fieldblock.getLocation(), (String)fs.getTitle());
            } else {
                PreciousStones.log("logFieldPlaced", player.getName(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logFieldPlaced", player.getName(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyPlaceCuboid(Player player, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyCuboidClosed", fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Cuboid Field close", (Player)player, (Location)field.getBlock().getLocation(), (String)fs.getTitle());
            } else {
                PreciousStones.log("logCuboidFieldPlaced", player.getName(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logCuboidFieldPlaced", player.getName(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyPlaceBreakableFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyBreakablePlaced", fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Place", (Player)player, (Location)fieldblock.getLocation(), (String)(fs.getTitle() + " (Breakable)"));
            } else {
                PreciousStones.log("logBreakablePlaced", player.getName(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBreakablePlaced", player.getName(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyDestroyU(Player player, Block unbreakableblock) {
        if (this.plugin.getSettingsManager().isNotifyDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyUnbreakableDestroyed", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Break", (Player)player, (Location)unbreakableblock.getLocation(), (String)unbreakableblock.getType().toString());
            } else {
                PreciousStones.log("logDestroyedOwnUnbreakable", player.getName(), Helper.getDetails(unbreakableblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.destroy") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyedOwnUnbreakable", player.getName(), Helper.getDetails(unbreakableblock));
        }
    }

    public void notifyDestroyFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyFieldDestroyed", fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Break", (Player)player, (Location)fieldblock.getLocation(), (String)fs.getTitle());
            } else {
                PreciousStones.log("logDestroyedOwnField", player.getName(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.destroy") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyedOwnField", player.getName(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyDestroyOthersFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyFieldDestroyed", fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Break", (Player)player, (Location)fieldblock.getLocation(), (String)fs.getTitle());
            } else {
                PreciousStones.log("logDestroyOthers", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.destroy") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyOthers", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyDestroyBreakableFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyBreakableDestroyed", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Break", (Player)player, (Location)fieldblock.getLocation(), (String)(fs.getTitle() + " (Breakable)"));
            } else {
                PreciousStones.log("logDestroyBreakableField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.destroy") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyBreakableField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyBypassPlace(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyBypassPlaced", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Bypass Place in Field", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + " " + field.toString() + ")"));
            } else {
                PreciousStones.log("logDestroyedOthersField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-place") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyedOthersField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyPaintingBypassPlace(Player player, Location loc, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyBypassPlaced", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Bypass Place in Field", (Player)player, (Location)loc, (String)("PAINTING (conflict: " + field.getOwner() + " " + fs.getTitle() + " " + field.toString() + ")"));
            } else {
                PreciousStones.log("logBypassPlacedPainting", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-place") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassPlacedPainting", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyBypassPlaceU(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassPlace() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyUnbreakableBypassPlaced", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Bypass Place in Field", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + " " + field.toString() + ")"));
            } else {
                PreciousStones.log("logBypassPlacedUnbreakable", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-place") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassPlacedUnbreakable", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyBypassDestroy(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyBypassDestroyed", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Bypass Destroy in Field", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + " " + field.toString() + ")"));
            } else {
                PreciousStones.log("logBypassDestroy", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-destroy") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassDestroy", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyBypassDestroyVehicle(Player player, Vehicle block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyVehicleBypassDestroyed", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Bypass Destroy in Field", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + " " + field.toString() + ")"));
            } else {
                PreciousStones.log("logBypassDestroyVehicle", player.getName(), new Vec(block.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-destroy") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassDestroyVehicle", player.getName(), new Vec(block.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void notifyBypassDestroyU(Player player, Block unbreakableblock) {
        Unbreakable unbreakable = this.plugin.getUnbreakableManager().getUnbreakable(unbreakableblock);
        if (this.plugin.getSettingsManager().isNotifyBypassDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyUnbreakableBypassDestroyed", unbreakable.getOwner());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Bypass Destroy", (Player)player, (Location)unbreakableblock.getLocation(), (String)(unbreakableblock.getType().toString() + " (owner: " + unbreakable.getOwner() + ")"));
            } else {
                PreciousStones.log("logBypassDestroyUnbreakable", player.getName(), unbreakable.getOwner(), unbreakable.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass-destroy") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassDestroyUnbreakable", player.getName(), unbreakable.getOwner(), unbreakable.getDetails());
        }
    }

    public void notifyBypassDestroyFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassDestroy() && this.canNotify(player)) {
            ChatBlock.send((CommandSender)player, "notifyFieldBypassDestroyed", field.getOwner(), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log-destroy")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Bypass Destroy", (Player)player, (Location)fieldblock.getLocation(), (String)(fs.getTitle() + " (owner: " + field.getOwner() + ")"));
            } else {
                PreciousStones.log("logBypassDestroyField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.notify.bypass") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassDestroyField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnEntry(Player player, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnEntry() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnEnterProtectedArea", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogEntry()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Entry Attempt", (Player)player, (Location)player.getLocation(), (String)("(field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logEntry", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log") || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.entry") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logEntry", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnFire(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnFire() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnPlaceFires", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogFire()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Fire Attempt", (Player)player, (Location)block.getLocation(), (String)("(field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("warnFire", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.fire") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "warnFire", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnPlace(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnPlace() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnPlace", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlaceArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Block Place Attempt", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPlace", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlace", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnPlaceHanging(Player player, Hanging hanging, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnPlace() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnPlace", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlaceArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Block Place Attempt", (Player)player, (Location)hanging.getLocation(), (String)(hanging.toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPlace", player.getName(), new Vec(hanging.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlace", player.getName(), new Vec(hanging.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnPlacePainting(Player player, Painting painting, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnPlace() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnPlace", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlaceArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Block Place Attempt", (Player)player, (Location)painting.getLocation(), (String)(painting.toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPlace", player.getName(), new Vec(painting.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlace", player.getName(), new Vec(painting.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnUse(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnUse() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnUse", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUse()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Use Attempt", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logUse", player.getName(), block.getType().toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.use") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logUse", player.getName(), block.getType().toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnEmpty(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnPlace() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnEmpty", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPlaceArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Block Place Attempt", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logBucketEmpty", player.getName(), block.getType().toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.place") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBucketEmpty", player.getName(), block.getType().toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnDestroyU(Player player, Block unbreakableblock) {
        Unbreakable unbreakable = this.plugin.getUnbreakableManager().getUnbreakable(unbreakableblock);
        if (this.plugin.getSettingsManager().isWarnDestroy() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnDestroyUnbreakable", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroy()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Destroy", (Player)player, (Location)unbreakableblock.getLocation(), (String)unbreakableblock.getType().toString());
            } else {
                PreciousStones.log("logDestroyUnbreakable", player.getName(), unbreakable.getOwner(), unbreakable.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroy") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyUnbreakable", player.getName(), unbreakable.getOwner(), unbreakable.getDetails());
        }
    }

    public void warnDestroyFF(Player player, Block fieldblock) {
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field != null) {
            FieldSettings fs = field.getSettings();
            if (this.plugin.getSettingsManager().isWarnDestroy() && this.canWarn(player)) {
                ChatBlock.send((CommandSender)player, "warnOwnerRemove", new Object[0]);
            }
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
                return;
            }
            if (this.plugin.getSettingsManager().isLogDestroy()) {
                if (this.useHawkEye) {
                    HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Destroy", (Player)player, (Location)fieldblock.getLocation(), (String)fs.getTitle());
                } else {
                    PreciousStones.log("logDestroyField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
                }
            }
            for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
                if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroy") || !this.canAlert(pl)) continue;
                ChatBlock.sendPs((CommandSender)pl, "logDestroyField", player.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
    }

    public void warnDestroyArea(Player player, Block damagedblock, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnDestroyArea() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnDestroy", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroyArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Destroy Attempt", (Player)player, (Location)damagedblock.getLocation(), (String)(damagedblock.getType().toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logDestroyInField", player.getName(), new Vec(damagedblock).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroyarea") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyInField", player.getName(), new Vec(damagedblock).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnDestroyHanging(Player player, Hanging hanging, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnDestroyArea() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnDestroy", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroyArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Destroy Attempt", (Player)player, (Location)hanging.getLocation(), (String)(hanging.toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logDestroyInField", player.getName(), new Vec(hanging.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroyarea") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyInField", player.getName(), new Vec(hanging.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnDestroyPainting(Player player, Painting painting, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnDestroyArea() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnDestroy", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroyArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Destroy Attempt", (Player)player, (Location)painting.getLocation(), (String)(painting.toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logDestroyInField", player.getName(), new Vec(painting.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroyarea") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyInField", player.getName(), new Vec(painting.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnDestroyVehicle(Player player, Vehicle vehicle, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnDestroyArea() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnDestroyVehicle", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogDestroyArea()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Vehicle destroy Attempt", (Player)player, (Location)vehicle.getLocation(), (String)(vehicle.getType().toString() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logDestroyVehicle", player.getName(), new Vec(vehicle.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.destroyarea") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logDestroyVehicle", player.getName(), new Vec(vehicle.getLocation()).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnConflictU(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.canWarn(player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.viewconflicting")) {
                ChatBlock.send((CommandSender)player, "warnConflictUnbreakablePlace", field.getOwner(), field.getSettings().getTitle(), field.getDetails());
            } else {
                ChatBlock.send((CommandSender)player, "warnConflictUnbreakablePlace2", new Object[0]);
            }
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogConflictPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unbreakable Conflict Place", (Player)player, (Location)block.getLocation(), (String)(block.getType().toString() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPlaceUnbreakableConflict", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.conflict") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceUnbreakableConflict", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnConflictFF(Player player, Block block, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        FieldSettings fsconflict = this.plugin.getSettingsManager().getFieldSettings(block);
        if (fsconflict == null) {
            return;
        }
        if (this.canWarn(player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.viewconflicting")) {
                ChatBlock.send((CommandSender)player, "warnConflictFieldPlace", field.getOwner(), field.getSettings().getTitle(), field.getDetails());
            } else {
                ChatBlock.send((CommandSender)player, "warnConflictFieldPlace2", new Object[0]);
            }
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogConflictPlace()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Field Conflict Place", (Player)player, (Location)block.getLocation(), (String)(fsconflict.getTitle() + " (conflict: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPlaceFieldConflit", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.conflict") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceFieldConflit", player.getName(), new Vec(block).toString(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnPvP(Player attacker, Player victim, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnPvp() && this.canWarn(attacker)) {
            ChatBlock.send((CommandSender)attacker, "warnPvP", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(attacker, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogPvp()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"PvP Attempt", (Player)attacker, (Location)victim.getLocation(), (String)(victim.getName() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logPvP", attacker.getName(), victim.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(attacker) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.pvp") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPvP", attacker.getName(), victim.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnBypassPvPDueToCombat(Player attacker, Player victim) {
        if (this.canNotify(attacker)) {
            ChatBlock.send((CommandSender)attacker, "warnProtectionIgnored", new Object[0]);
        }
        if (this.canNotify(victim)) {
            ChatBlock.send((CommandSender)victim, "warnProtectionIgnored", new Object[0]);
        }
    }

    public void warnBypassPvP(Player attacker, Player victim, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isNotifyBypassPvp() && this.canNotify(attacker)) {
            ChatBlock.send((CommandSender)attacker, "notifyPvPBypass", new Object[0]);
        }
        if (this.plugin.getPermissionsManager().has(attacker, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogBypassPvp()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"PvP Bypass", (Player)attacker, (Location)victim.getLocation(), (String)(victim.getName() + " (field: " + field.getOwner() + " " + fs.getTitle() + ")"));
            } else {
                PreciousStones.log("logBypassAttack", attacker.getName(), victim.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(attacker) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.pvp") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassAttack", attacker.getName(), victim.getName(), field.getOwner(), fs.getTitle(), field.getDetails());
        }
    }

    public void warnFieldPlaceUnprotectableTouching(Player player, Block unprotectableblock, Block protectionblock) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(protectionblock);
        if (fs == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnFieldPlaceUnprotectableTouching", Helper.friendlyBlockType(unprotectableblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)protectionblock.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceUnprotectableTouchingField", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceUnprotectableTouchingField", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
        }
    }

    public void warnUnbreakablePlaceUnprotectableTouching(Player player, Block unprotectableblock, Block protectionblock) {
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnUnbreakablePlaceUnprotectableTouching", Helper.friendlyBlockType(unprotectableblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)protectionblock.getLocation(), (String)(protectionblock.getType().toString() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceUnprotectableTouchingUnbreakable", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceUnprotectableTouchingUnbreakable", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
        }
    }

    public void warnUnbreakablePlaceTouchingUnprotectable(Player player, Block placedblock) {
        Block touchingblock = this.plugin.getUnprotectableManager().getTouchingUnprotectableBlock(placedblock);
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnCannotProtect", Helper.friendlyBlockType(touchingblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)placedblock.getLocation(), (String)(placedblock.getType().toString() + " (unprotectable: " + touchingblock.getType().toString() + " " + Helper.toLocationString(touchingblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceTouchingUnbreakableUnprotectable", player.getName(), Helper.getDetails(touchingblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceTouchingUnbreakableUnprotectable", player.getName(), Helper.getDetails(touchingblock));
        }
    }

    public void warnFieldPlaceTouchingUnprotectable(Player player, Block placedblock) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(placedblock);
        if (fs == null) {
            return;
        }
        Block touchingblock = this.plugin.getUnprotectableManager().getTouchingUnprotectableBlock(placedblock);
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnCannotProtect", Helper.friendlyBlockType(touchingblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)placedblock.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + touchingblock.getType().toString() + " " + Helper.toLocationString(touchingblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceTouchingFieldUnprotectable", player.getName(), Helper.getDetails(touchingblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceTouchingFieldUnprotectable", player.getName(), Helper.getDetails(touchingblock));
        }
    }

    public void warnPlaceUnprotectableInField(Player player, Block unprotectableblock, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnCannotProtectInside", Helper.friendlyBlockType(unprotectableblock.getType().toString()), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)field.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceUnprotectableInField", player.getName(), Helper.getDetails(unprotectableblock), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceUnprotectableInField", player.getName(), Helper.getDetails(unprotectableblock), field.getDetails());
        }
    }

    public void warnPlaceFieldInUnprotectable(Player player, Block unprotectableblock, Block fieldtypeblock) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(fieldtypeblock);
        if (fs == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnPlaceFieldInUnprotectable", fs.getTitle(), Helper.friendlyBlockType(unprotectableblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Protect Attempt", (Player)player, (Location)fieldtypeblock.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logPlaceFieldUnprotectableInArea", player.getName(), fieldtypeblock.getType(), Helper.getDetails(unprotectableblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logPlaceFieldUnprotectableInArea", player.getName(), fieldtypeblock.getType(), Helper.getDetails(unprotectableblock));
        }
    }

    public void notifyUnbreakableBypassUnprotectableTouching(Player player, Block unprotectableblock, Block protectionblock) {
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnBypassPlacedUnprotectableInUnbreakable", Helper.friendlyBlockType(unprotectableblock.getType().toString()), Helper.friendlyBlockType(protectionblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Bypass Protect", (Player)player, (Location)protectionblock.getLocation(), (String)(protectionblock.getType().toString() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logUnbreakableBypassUnprotectableTouching", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logUnbreakableBypassUnprotectableTouching", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
        }
    }

    public void notifyFieldBypassUnprotectableTouching(Player player, Block unprotectableblock, Block protectionblock) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(protectionblock);
        if (fs == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnBypassPlacedUnprotectableInField", Helper.friendlyBlockType(unprotectableblock.getType().toString()), Helper.friendlyBlockType(protectionblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Bypass Protect", (Player)player, (Location)protectionblock.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logFieldBypassUnprotectableTouching", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logFieldBypassUnprotectableTouching", player.getName(), Helper.getDetails(unprotectableblock), Helper.getDetails(protectionblock));
        }
    }

    public void notifyBypassTouchingUnprotectable(Player player, Block placedblock) {
        Block unprotectableblock = this.plugin.getUnprotectableManager().getTouchingUnprotectableBlock(placedblock);
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnUnprotectableBypassProtected", Helper.friendlyBlockType(unprotectableblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Bypass Protect", (Player)player, (Location)placedblock.getLocation(), (String)(placedblock.getType().toString() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logBypassTouchingUnprotectable", player.getName(), Helper.getDetails(placedblock), Helper.getDetails(unprotectableblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassTouchingUnprotectable", player.getName(), Helper.getDetails(placedblock), Helper.getDetails(unprotectableblock));
        }
    }

    public void notifyBypassPlaceUnprotectableInField(Player player, Block unprotectableblock, Field field) {
        if (field == null) {
            return;
        }
        FieldSettings fs = field.getSettings();
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnUnprotectableBypassPlaced", Helper.friendlyBlockType(unprotectableblock.getType().toString()), fs.getTitle());
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Bypass Protect", (Player)player, (Location)field.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logBypassPlaceUnprotectableInField", player.getName(), Helper.getDetails(unprotectableblock), field.getDetails());
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassPlaceUnprotectableInField", player.getName(), Helper.getDetails(unprotectableblock), field.getDetails());
        }
    }

    public void notifyBypassFieldInUnprotectable(Player player, Block unprotectableblock, Block fieldtypeblock) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(fieldtypeblock);
        if (fs == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isWarnUnprotectable() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "warnFieldBypassPlacedUnprotectable", fs.getTitle(), Helper.friendlyBlockType(unprotectableblock.getType().toString()));
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.bypass.log")) {
            return;
        }
        if (this.plugin.getSettingsManager().isLogUnprotectable()) {
            if (this.useHawkEye) {
                HawkEyeAPI.addCustomEntry((JavaPlugin)this.plugin, (String)"Unprotectable Bypass Protect", (Player)player, (Location)fieldtypeblock.getLocation(), (String)(fs.getTitle() + " (unprotectable: " + unprotectableblock.getType().toString() + " " + Helper.toLocationString(unprotectableblock.getLocation()) + ")"));
            } else {
                PreciousStones.log("logBypassFieldInUnprotectable", player.getName(), fieldtypeblock.getType(), Helper.getDetails(unprotectableblock));
            }
        }
        for (Player pl : this.plugin.getServer().getOnlinePlayers()) {
            if (pl.equals(player) || !this.plugin.getPermissionsManager().has(pl, "preciousstones.alert.warn.unprotectable") || !this.canBypassAlert(pl)) continue;
            ChatBlock.sendPs((CommandSender)pl, "logBypassFieldInUnprotectable", player.getName(), fieldtypeblock.getType(), Helper.getDetails(unprotectableblock));
        }
    }

    public void showWelcomeMessage(Player player, Field field) {
        if (field == null) {
            return;
        }
        if (field.isNamed()) {
            ChatBlock.send((CommandSender)player, "enteringNamedField", field.getName());
        } else if (this.plugin.getSettingsManager().isShowDefaultWelcomeFarewellMessages()) {
            ChatBlock.send((CommandSender)player, "enteringField", field.getOwner(), field.getSettings().getTitle());
        }
    }

    public void showFarewellMessage(Player player, Field field) {
        if (field == null) {
            return;
        }
        if (field.isNamed()) {
            ChatBlock.send((CommandSender)player, "leavingNamedField", field.getName());
        } else if (this.plugin.getSettingsManager().isShowDefaultWelcomeFarewellMessages()) {
            ChatBlock.send((CommandSender)player, "leavingField", field.getOwner(), field.getSettings().getTitle());
        }
    }

    public void showNotFound(CommandSender sender) {
        ChatBlock.send(sender, "noFieldsFound", new Object[0]);
    }

    public void showNoPotion(Player player, String potion) {
        if (this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "potionNeutralized", potion.toLowerCase().replace("_", " "));
        }
    }

    public void showDamage(Player player) {
        if (this.plugin.getSettingsManager().isWarnFastDamage() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoDamage", new Object[0]);
        }
    }

    public void showHeal(Player player) {
        if (this.plugin.getSettingsManager().isWarnInstantHeal() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoHealed", new Object[0]);
        }
    }

    public void showGiveAir(Player player) {
        if (this.plugin.getSettingsManager().isWarnGiveAir() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoAir", new Object[0]);
        }
    }

    public void showLaunch(Player player) {
        if (this.plugin.getSettingsManager().isWarnLaunch() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoLaunch", new Object[0]);
        }
    }

    public void showCannon(Player player) {
        if (this.plugin.getSettingsManager().isWarnCannon() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoCannon", new Object[0]);
        }
    }

    public void showMine(Player player) {
        if (this.plugin.getSettingsManager().isWarnMine() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoMine", new Object[0]);
        }
    }

    public void showLightning(Player player) {
        if (this.plugin.getSettingsManager().isWarnMine() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoLightning", new Object[0]);
        }
    }

    public void showThump(Player player) {
        ChatBlock.send((CommandSender)player, "notifyDoFall", new Object[0]);
    }

    public void showFeeding(Player player) {
        if (this.plugin.getSettingsManager().isWarnSlowFeeding() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyDoFeeding", new Object[0]);
        }
    }

    public void showRepair(Player player) {
        if (this.plugin.getSettingsManager().isWarnSlowRepair() && this.canWarn(player)) {
            ChatBlock.send((CommandSender)player, "notifyRepairing", new Object[0]);
        }
    }

    public void showUnbreakableDetails(Player player, Block block) {
        ChatBlock.send((CommandSender)player, "showOwner", this.plugin.getUnbreakableManager().getOwner(block));
    }

    public void showProtectedLocation(Player player, Block block) {
        List<Field> fields = this.plugin.getForceFieldManager().getSourceFields(block.getLocation(), FieldFlag.ALL);
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.send((CommandSender)player, "showProtected", new Object[0]);
        for (Field field : fields) {
            ChatBlock.send((CommandSender)player, "showProtectedLocations", field.getSettings().getTitle(), field.getCleanCoords());
        }
    }

    public void showFieldOwner(Player player, Block block) {
        ChatBlock.send((CommandSender)player, "showOwner", this.plugin.getForceFieldManager().getOwner(block));
    }

    public void showUnbreakableDetails(Unbreakable unbreakable, Player player) {
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.send((CommandSender)player, "showOwner", unbreakable.getOwner());
    }

    public void showFieldDetails(Player player, List<Field> fields) {
        ChatBlock cb = this.getNewChatBlock((CommandSender)player);
        for (Field field : fields) {
            ChatColor color;
            cb.addRow("", "", "");
            ChatColor chatColor = color = field.isDisabled() ? ChatColor.RED : ChatColor.YELLOW;
            if (field.isDisabled()) {
                cb.addRow("  " + ChatColor.RED + ChatBlock.format("_fieldDisabled", new Object[0]), "", "");
            }
            FieldSettings fs = field.getSettings();
            cb.addRow("  " + color + ChatBlock.format("_type", new Object[0]) + ": ", ChatColor.AQUA + fs.getTitle(), "");
            if (fs.hasNameableFlag() && field.isNamed()) {
                cb.addRow("  " + color + ChatBlock.format("_name", new Object[0]) + ": ", ChatColor.AQUA + field.getName(), "");
            }
            cb.addRow("  " + color + ChatBlock.format("_owner", new Object[0]) + ": ", ChatColor.AQUA + field.getOwner(), "");
            cb.addRow("  " + color + ChatBlock.format("_location", new Object[0]) + ": ", ChatColor.AQUA + "" + field.getX() + " " + field.getY() + " " + field.getZ(), "");
        }
        if (cb.size() > 0) {
            cb.addRow("", "", "", "");
            ChatBlock.sendBlank((CommandSender)player);
            ChatBlock.saySingle((CommandSender)player, "sepFieldInfo", new Object[0]);
            boolean more = cb.sendBlock((CommandSender)player, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.send((CommandSender)player, "moreNextPage", new Object[0]);
            }
        }
    }

    public boolean showFieldDetails(Player player, Field field) {
        if (field == null) {
            return false;
        }
        ChatBlock cb = this.getNewChatBlock((CommandSender)player);
        FieldSettings fs = field.getSettings();
        cb.addRow("", "", "");
        ChatColor color = field.isDisabled() ? ChatColor.RED : ChatColor.YELLOW;
        boolean showMessage = true;
        cb.addRow("  " + color + ChatBlock.format("_type", new Object[0]) + ": ", ChatColor.AQUA + fs.getTitle(), "");
        if (fs.hasNameableFlag()) {
            if (field.isNamed()) {
                cb.addRow("  " + color + ChatBlock.format("_name", new Object[0]) + ": ", ChatColor.AQUA + field.getName(), "");
            } else {
                cb.addRow("  " + color + ChatBlock.format("_name", new Object[0]) + ": ", ChatColor.GRAY + ChatBlock.format("_none", new Object[0]), "");
            }
        }
        cb.addRow("  " + color + ChatBlock.format("_owner", new Object[0]) + ": ", ChatColor.AQUA + field.getOwner(), "");
        if (field.getAllowed().size() > 0) {
            List<String> allowed = field.getAllowed();
            int rows = (int)Math.max(Math.ceil((double)allowed.size() / 2.0), 1.0);
            for (int i = 0; i < rows; ++i) {
                String title = "";
                if (i == 0) {
                    title = color + ChatBlock.format("_allowed", new Object[0]) + ": ";
                }
                cb.addRow("  " + title, ChatColor.WHITE + this.getAllowed(allowed, i * 2), this.getAllowed(allowed, i * 2 + 1));
            }
        }
        if (field.hasFlag(FieldFlag.CUBOID)) {
            cb.addRow("  " + color + ChatBlock.format("_dimensions", new Object[0]) + ": ", ChatColor.AQUA + "" + (field.getMaxx() - field.getMinx() + 1) + "x" + (field.getMaxy() - field.getMiny() + 1) + "x" + (field.getMaxz() - field.getMinz() + 1), "");
        } else {
            cb.addRow("  " + color + ChatBlock.format("_dimensions", new Object[0]) + ": ", ChatColor.AQUA + "" + (field.getRadius() * 2 + 1) + "x" + field.getHeight() + "x" + (field.getRadius() * 2 + 1), "");
        }
        if (field.getVelocity() > 0.0f) {
            cb.addRow("  " + color + ChatBlock.format("_velocity", new Object[0]) + ": ", ChatColor.AQUA + "" + field.getVelocity(), "");
        }
        if (field.getRevertSecs() > 0) {
            cb.addRow("  " + color + ChatBlock.format("_interval", new Object[0]) + ": ", ChatColor.AQUA + "" + field.getRevertSecs(), "");
        }
        if (field.hasBlacklistedComands()) {
            cb.addRow("  " + color + ChatBlock.format("_blacklistedCommands", new Object[0]) + ": ", ChatColor.AQUA + "" + field.getBlacklistedCommandsList(), "");
        }
        cb.addRow("  " + color + ChatBlock.format("_location", new Object[0]) + ": ", ChatColor.AQUA + "" + field.getX() + " " + field.getY() + " " + field.getZ(), "");
        ArrayList<FieldFlag> flags = new ArrayList<FieldFlag>(field.getFlags());
        List<FieldFlag> insertedFlags = field.getInsertedFlags();
        List<FieldFlag> disabledFlags = field.getDisabledFlags();
        flags.addAll(insertedFlags);
        flags.addAll(disabledFlags);
        for (FieldFlag hid : FieldFlag.getHidden()) {
            flags.remove((Object)hid);
        }
        boolean addedTitle = false;
        for (FieldFlag flag : flags) {
            if (flag == null) continue;
            String title = "";
            if (!addedTitle) {
                title = color + ChatBlock.format("_flags", new Object[0]) + ": ";
                addedTitle = true;
            }
            ChatColor c = ChatColor.WHITE;
            if (disabledFlags.contains((Object)flag)) {
                c = ChatColor.DARK_GRAY;
            }
            if (flag.isUnToggable()) {
                c = ChatColor.AQUA;
            }
            String flagStr = Helper.toFlagStr(flag);
            if (field.getSettings().isReversedFlag(flag)) {
                flagStr = "~" + flagStr;
            }
            if (field.getSettings().isAlledFlag(flag)) {
                flagStr = "^" + flagStr;
            }
            cb.addRow("  " + title, c + flagStr);
        }
        if (field.hasFlag(FieldFlag.POTIONS)) {
            cb.addRow("  " + color + ChatBlock.format("_potions", new Object[0]) + ": ", ChatColor.WHITE + field.getSettings().getPotionString(), "");
        }
        if (field.hasFlag(FieldFlag.NEUTRALIZE_POTIONS)) {
            cb.addRow("  " + color + ChatBlock.format("_neutralizes", new Object[0]) + ": ", ChatColor.WHITE + field.getSettings().getNeutralizePotionString(), "");
        }
        if (cb.size() > 0) {
            cb.addRow("", "", "");
            ChatBlock.sendBlank((CommandSender)player);
            if (field.isDisabled()) {
                ChatBlock.saySingle((CommandSender)player, "sepFieldInfoDisabled", new Object[0]);
            } else {
                ChatBlock.saySingle((CommandSender)player, "sepFieldInfo", new Object[0]);
            }
            boolean more = cb.sendBlock((CommandSender)player, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.send((CommandSender)player, "moreNextPage", new Object[0]);
            }
            if (field.isDisabled()) {
                ChatBlock.sendBlank((CommandSender)player);
                showMessage = false;
            }
        }
        return showMessage;
    }

    public void showRenterInfo(Player player, Field field) {
        if (field == null) {
            return;
        }
        ChatBlock cb = this.getNewChatBlock((CommandSender)player);
        if (field.getRenters().size() > 0) {
            List<String> renters = field.getRenters();
            int rows = (int)Math.max(Math.ceil((double)renters.size() / 2.0), 1.0);
            for (int i = 0; i < rows; ++i) {
                String title = "";
                if (i == 0) {
                    title = renters.size() == 1 ? ChatColor.YELLOW + ChatBlock.format("_tenant", new Object[0]) + ": " : ChatColor.YELLOW + ChatBlock.format("_tenants", new Object[0]) + ": ";
                }
                cb.addRow("  " + title, ChatColor.WHITE + this.getRenters(field, i * 2), this.getRenters(field, i * 2 + 1));
            }
        }
        if (field.getLimitSeconds() > 0) {
            cb.addRow("", "", "");
            cb.addRow("  " + ChatColor.YELLOW + ChatBlock.format("_rentingLimit", new Object[0]) + ": ", SignHelper.secondsToPeriods(field.getLimitSeconds()));
        }
        if (cb.size() > 0) {
            cb.sendBlock((CommandSender)player);
            ChatBlock.sendBlank((CommandSender)player);
        }
    }

    private String getAllowed(List<String> allowed, int index) {
        if (index < allowed.size()) {
            return allowed.get(index);
        }
        return "";
    }

    private String getRenters(Field field, int index) {
        List<RentEntry> entries = field.getRenterEntries();
        if (index < entries.size()) {
            RentEntry entry = entries.get(index);
            return ChatColor.WHITE + entry.getPlayerName() + ChatColor.DARK_AQUA + " (" + SignHelper.secondsToPeriods(entry.remainingRent()) + ")";
        }
        return "";
    }

    public void showConfiguredFields(CommandSender player) {
        ChatBlock cb = this.getNewChatBlock(player);
        HashMap<BlockTypeEntry, FieldSettings> fss = this.plugin.getSettingsManager().getFieldSettings();
        for (FieldSettings fs : fss.values()) {
            String customHeight = fs.getCustomHeight() > 0 ? " " + ChatBlock.format("headerConfiguredFieldsHeight", fs.getCustomHeight()) : "";
            String customVolume = fs.getCustomVolume() > 0 ? " " + ChatBlock.format("headerConfiguredFieldsVolume", fs.getCustomVolume()) : "";
            BlockTypeEntry entry = new BlockTypeEntry(fs.getTypeId(), fs.getData());
            cb.addRow(ChatBlock.format("headerConfiguredFields", fs.getTitle(), entry.toString(), fs.getRadius()) + customHeight + customVolume);
        }
        if (cb.size() > 0) {
            ChatBlock.sendBlank(player);
            ChatBlock.saySingle(player, "sepConfiguredFields", new Object[0]);
            ChatBlock.sendBlank(player);
            boolean more = cb.sendBlock(player, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank(player);
                ChatBlock.send(player, "moreNextPage", new Object[0]);
            }
            ChatBlock.sendBlank(player);
        }
    }

    public boolean showCounts(CommandSender sender, BlockTypeEntry type) {
        if (!(sender instanceof Player)) {
            sender = Bukkit.getServer().getConsoleSender();
        }
        ChatBlock cb = this.getNewChatBlock(sender);
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(type);
        if (fs == null) {
            return false;
        }
        TreeMap<String, PlayerEntry> players = this.plugin.getPlayerManager().getPlayers();
        cb.setAlignment("l", "c");
        cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_name", new Object[0]), ChatBlock.format("_count", new Object[0]));
        for (String playerName : players.keySet()) {
            int count = this.plugin.getForceFieldManager().getFieldCount(playerName, type);
            if (count <= 0) continue;
            cb.addRow("  " + ChatColor.AQUA + playerName, ChatColor.WHITE + " " + count);
        }
        if (cb.size() > 1) {
            ChatBlock.sendBlank(sender);
            ChatBlock.saySingle(sender, "sepCounts", fs.getTitle());
            ChatBlock.sendBlank(sender);
            boolean more = cb.sendBlock(sender, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank(sender);
                ChatBlock.send(sender, "moreNextPage", new Object[0]);
            }
            ChatBlock.sendBlank(sender);
        } else {
            ChatBlock.send(sender, "noFieldsFound", new Object[0]);
        }
        return true;
    }

    public boolean showFieldCounts(CommandSender sender, String target) {
        boolean showLimits;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            sender = Bukkit.getServer().getConsoleSender();
        }
        ChatBlock cb = this.getNewChatBlock(sender);
        boolean bl = showLimits = player != null && player.getName().equalsIgnoreCase(target) && this.plugin.getSettingsManager().haveLimits();
        if (showLimits) {
            cb.setAlignment("l", "c", "c");
            cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_field", new Object[0]), ChatBlock.format("_count", new Object[0]), ChatBlock.format("_limit", new Object[0]));
        } else {
            cb.setAlignment("l", "c");
            cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_field", new Object[0]), ChatBlock.format("_count", new Object[0]));
        }
        HashMap<BlockTypeEntry, Integer> fieldCounts = this.plugin.getForceFieldManager().getFieldCounts(target);
        for (BlockTypeEntry type : fieldCounts.keySet()) {
            String strLimit;
            FieldSettings fs;
            int count = fieldCounts.get(type);
            if (count == 0 || (fs = this.plugin.getSettingsManager().getFieldSettings(type)) == null) continue;
            int limit = this.plugin.getLimitManager().getLimit(player, fs);
            ChatColor color = count < limit || limit == -1 ? ChatColor.WHITE : ChatColor.DARK_RED;
            String string = strLimit = limit == -1 ? "-" : limit + "";
            if (this.plugin.getSettingsManager().haveLimits()) {
                cb.addRow("  " + ChatColor.AQUA + fs.getTitle(), "{yellow} " + count, ChatColor.WHITE + " " + strLimit);
                continue;
            }
            cb.addRow("  " + ChatColor.AQUA + fs.getTitle(), ChatColor.WHITE + " " + count);
        }
        String targetName = target;
        if (target.contains(":")) {
            targetName = target.substring(2);
        } else if (target.contains("*")) {
            targetName = ChatBlock.format("_everyone", new Object[0]);
        }
        if (cb.size() > 1) {
            ChatBlock.sendBlank(sender);
            ChatBlock.saySingle(sender, "sepFieldCounts", targetName);
            ChatBlock.sendBlank(sender);
            boolean more = cb.sendBlock(sender, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank(sender);
                ChatBlock.send(sender, "moreNextPage", new Object[0]);
            }
            ChatBlock.sendBlank(sender);
        } else {
            ChatBlock.send(sender, "noFieldsFound", new Object[0]);
        }
        return true;
    }

    public void showFieldLocations(CommandSender sender, int typeid, String target) {
        Location center;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            sender = Bukkit.getServer().getConsoleSender();
        }
        ChatBlock cb = this.getNewChatBlock(sender);
        boolean admin = player == null || !player.getName().equalsIgnoreCase(target);
        Location location = center = player == null ? new Location((World)this.plugin.getServer().getWorlds().get(0), 0.0, 0.0, 0.0) : player.getLocation();
        if (admin) {
            cb.setAlignment("l", "c", "c", "c");
            cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_field", new Object[0]), ChatBlock.format("_distance", new Object[0]), ChatBlock.format("_coords", new Object[0]), ChatBlock.format("_owner", new Object[0]));
        } else {
            cb.setAlignment("l", "c", "c");
            cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_field", new Object[0]), ChatBlock.format("_distance", new Object[0]), ChatBlock.format("_coords", new Object[0]));
        }
        ArrayList<Field> fields = new ArrayList();
        if (player != null) {
            fields = this.plugin.getForceFieldManager().getFields(target, player.getWorld());
        } else {
            for (World world : this.plugin.getServer().getWorlds()) {
                fields.addAll(this.plugin.getForceFieldManager().getFields(target, world));
            }
        }
        this.sortByDistance(fields, center);
        if (typeid != -1) {
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                Field testfield = (Field)iter.next();
                if (typeid == testfield.getTypeId()) continue;
                iter.remove();
            }
        }
        String targetName = target;
        if (target.contains(":")) {
            targetName = target.substring(2);
        } else if (target.contains("*")) {
            targetName = ChatBlock.format("_everyone", new Object[0]);
        }
        for (Field field : fields) {
            int distance = (int)field.distance(center);
            FieldSettings fs = field.getSettings();
            if (admin) {
                cb.addRow("  " + ChatColor.AQUA + fs.getTitle(), ChatColor.WHITE + "" + distance, ChatColor.YELLOW + Helper.toLocationString(field.getLocation()), ChatColor.WHITE + field.getOwner());
                continue;
            }
            cb.addRow("  " + ChatColor.AQUA + fs.getTitle(), ChatColor.WHITE + "" + distance, ChatColor.YELLOW + Helper.toLocationString(field.getLocation()));
        }
        if (cb.size() > 1) {
            ChatBlock.sendBlank(sender);
            if (player != null) {
                ChatBlock.saySingle(sender, "sepFieldLocations", targetName, player.getWorld().getName());
            } else {
                ChatBlock.saySingle(sender, "sepFieldLocations", targetName, "");
            }
            ChatBlock.sendBlank(sender);
            boolean more = cb.sendBlock(sender, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank(sender);
                ChatBlock.send(sender, "moreNextPage", new Object[0]);
            }
            ChatBlock.sendBlank(sender);
        } else {
            ChatBlock.send(sender, "noFieldsFound", new Object[0]);
        }
    }

    public void sortByDistance(List<Field> fields, final Location playerLocation) {
        Collections.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                Float o1 = Float.valueOf((float)f1.distance(playerLocation));
                Float o2 = Float.valueOf((float)f2.distance(playerLocation));
                return o1.compareTo(o2);
            }
        });
    }

    public boolean showSnitchList(Player player, Field field) {
        if (field != null) {
            List<SnitchEntry> snitches = field.getSnitches();
            if (snitches.isEmpty() || snitches.get(0).getAgeInSeconds() > 10) {
                snitches = this.plugin.getStorageManager().getSnitchEntries(field);
                field.updateLastUsed();
                this.plugin.getStorageManager().offerField(field);
            }
            String title = ChatBlock.format("_intruderLog", new Object[0]) + " ";
            if (!snitches.isEmpty()) {
                ChatBlock cb = this.getNewChatBlock((CommandSender)player);
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.saySingle((CommandSender)player, ChatColor.WHITE + title + ChatColor.DARK_GRAY + " ----------------------------------------------------------------------------------------", new Object[0]);
                ChatBlock.sendBlank((CommandSender)player);
                cb.addRow("  " + ChatColor.GRAY + ChatBlock.format("_name", new Object[0]), ChatBlock.format("_reason", new Object[0]), ChatBlock.format("_details", new Object[0]));
                for (SnitchEntry se : snitches) {
                    cb.addRow("  " + ChatColor.GOLD + se.getName(), se.getReasonDisplay(), ChatColor.WHITE + se.getDetails());
                }
                boolean more = cb.sendBlock((CommandSender)player, this.plugin.getSettingsManager().getLinesPerPage());
                if (more) {
                    ChatBlock.sendBlank((CommandSender)player);
                    ChatBlock.send((CommandSender)player, "moreNextPage", new Object[0]);
                }
                ChatBlock.sendBlank((CommandSender)player);
            }
            return !snitches.isEmpty();
        }
        this.showNotFound((CommandSender)player);
        return false;
    }

    public void showMenu(CommandSender sender) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            sender = Bukkit.getServer().getConsoleSender();
        }
        boolean hasPlayer = player != null;
        ChatBlock cb = this.getNewChatBlock(sender);
        cb.addRow("menuIdentifiers");
        cb.addRow("");
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.fields")) {
            cb.addRow("menu40");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.onoff") && hasPlayer) {
            cb.addRow("menu1");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.disable") && hasPlayer) {
            cb.addRow("menu2");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.info") && hasPlayer) {
            cb.addRow("menu34");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.whitelist.allow") && hasPlayer) {
            cb.addRow("menu3");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.whitelist.allowall") && hasPlayer) {
            cb.addRow("menu4");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.whitelist.remove") && hasPlayer) {
            cb.addRow("menu5");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.whitelist.removeall") && hasPlayer) {
            cb.addRow("menu6");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.whitelist.allowed") && hasPlayer) {
            cb.addRow("menu7");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.who") && hasPlayer) {
            cb.addRow("menu8");
        }
        if (this.plugin.getSettingsManager().haveLimits() && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.counts") && hasPlayer) {
            cb.addRow("menu9");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.locations") && hasPlayer) {
            cb.addRow("menu10");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.toggle") && hasPlayer) {
            cb.addRow("menu11");
        }
        if (this.plugin.getSettingsManager().isCommandsToRentBuy()) {
            cb.addRow("menu60");
            cb.addRow("menu61");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.change-owner") && hasPlayer) {
            cb.addRow("menu12");
        }
        if (this.plugin.getSettingsManager().haveNameable() && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.setname") && hasPlayer) {
            cb.addRow("menu13");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.setradius") && hasPlayer) {
            cb.addRow("menu14");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.expand") && hasPlayer) {
            cb.addRow("menu64");
            cb.addRow("menu65");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.contract") && hasPlayer) {
            cb.addRow("menu66");
            cb.addRow("menu67");
        }
        if (this.plugin.getSettingsManager().haveVelocity() && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.setvelocity") && hasPlayer) {
            cb.addRow("menu15");
        }
        if (this.plugin.getSettingsManager().haveGriefRevert() && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.setinterval") && hasPlayer) {
            cb.addRow("menu16");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.setlimit") && hasPlayer) {
            cb.addRow("menu54");
        }
        if (hasPlayer) {
            cb.addRow("menu57");
            cb.addRow("menu58");
        }
        if (this.plugin.getSettingsManager().haveSnitch() && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.snitch") && hasPlayer) {
            cb.addRow("menu17");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.visualize") && hasPlayer) {
            cb.addRow("menu18");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.visualize") && hasPlayer) {
            cb.addRow("menu19");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.density") && hasPlayer) {
            cb.addRow("menu20");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.mark") && !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.mark") && hasPlayer) {
            cb.addRow("menu21");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.create.forcefield") && hasPlayer) {
            cb.addRow("menu53");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.use") && hasPlayer) {
            cb.addRow("menu22");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.hide") && hasPlayer) {
            cb.addRow("menu49");
            cb.addRow("menu50");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.take") && hasPlayer) {
            cb.addRow("menu68");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.hideall") && hasPlayer) {
            cb.addRow("menu51");
            cb.addRow("menu52");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.import") && hasPlayer) {
            cb.addRow("menu23");
            cb.addRow("menu24");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.delete") && hasPlayer) {
            cb.addRow("menu25");
            cb.addRow("menu26");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.remove") && hasPlayer) {
            cb.addRow("menu27");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.unlink") && hasPlayer) {
            cb.addRow("menu28");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.toggle") && hasPlayer) {
            cb.addRow("menu48");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.insert") && hasPlayer) {
            cb.addRow("menu29");
            cb.addRow("menu62");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.reset") && hasPlayer) {
            cb.addRow("menu30");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.mark") && hasPlayer) {
            cb.addRow("menu31");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.delete")) {
            if (hasPlayer) {
                cb.addRow("menu32");
            }
            cb.addRow("menu33");
            cb.addRow("menu55");
            cb.addRow("menu56");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.counts")) {
            cb.addRow("menu35");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.locations")) {
            cb.addRow("menu36");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.list") && hasPlayer) {
            cb.addRow("menu37");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.setowner") && hasPlayer) {
            cb.addRow("menu38");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.reload")) {
            cb.addRow("menu39");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.clean")) {
            cb.addRow("menu41");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.revert")) {
            cb.addRow("menu42");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.pull")) {
            cb.addRow("menu63");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.enableall")) {
            cb.addRow("menu43");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.disableall")) {
            cb.addRow("menu44");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.rent")) {
            cb.addRow("menu59");
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.debug")) {
            cb.addRow("menu45");
        }
        if (cb.size() > 0) {
            if (hasPlayer) {
                ChatBlock.sendBlank(sender);
            }
            ChatBlock.saySingle(sender, "sepMenu", this.plugin.getDescription().getName(), this.plugin.getDescription().getVersion());
            ChatBlock.sendBlank(sender);
            boolean more = cb.sendBlock(sender, this.plugin.getSettingsManager().getLinesPerPage());
            if (more) {
                ChatBlock.sendBlank(sender);
                ChatBlock.send(sender, "moreNextPage", new Object[0]);
            }
            if (hasPlayer) {
                ChatBlock.sendBlank(sender);
            }
        }
    }
}

