/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ItemStackEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ConfiscationManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void confiscateItems(Field field, Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        ItemStackEntry helmet = null;
        ItemStackEntry chestplate = null;
        ItemStackEntry leggings = null;
        ItemStackEntry boots = null;
        ArrayList<ItemStackEntry> confiscated = new ArrayList<ItemStackEntry>();
        for (ItemStack stack : contents) {
            if (stack == null || stack.getTypeId() <= 0 || field.getSettings().canCarry(stack.getTypeId(), stack.getData().getData())) continue;
            inventory.removeItem(new ItemStack[]{stack});
            confiscated.add(new ItemStackEntry(stack));
        }
        ItemStack item = inventory.getHelmet();
        if (item != null && !field.getSettings().canCarry(item.getTypeId(), item.getData().getData())) {
            helmet = new ItemStackEntry(item);
            inventory.setHelmet(new ItemStack(0));
        }
        if ((item = inventory.getChestplate()) != null && !field.getSettings().canCarry(item.getTypeId(), item.getData().getData())) {
            chestplate = new ItemStackEntry(item);
            inventory.setChestplate(new ItemStack(0));
        }
        if ((item = inventory.getLeggings()) != null && !field.getSettings().canCarry(item.getTypeId(), item.getData().getData())) {
            leggings = new ItemStackEntry(item);
            inventory.setLeggings(new ItemStack(0));
        }
        if ((item = inventory.getBoots()) != null && !field.getSettings().canCarry(item.getTypeId(), item.getData().getData())) {
            boots = new ItemStackEntry(item);
            inventory.setBoots(new ItemStack(0));
        }
        if (!confiscated.isEmpty() || helmet != null || chestplate != null || leggings != null || boots != null) {
            PlayerEntry entry = this.plugin.getPlayerManager().getPlayerEntry(player.getName());
            entry.confiscate(confiscated, helmet, chestplate, leggings, boots);
            this.plugin.getStorageManager().updatePlayer(player.getName());
            player.updateInventory();
            String msg = "";
            for (ItemStackEntry e : confiscated) {
                msg = msg + e.getAmount() + " " + Helper.friendlyBlockType(e.getTypeId()) + ", ";
            }
            if (helmet != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(helmet.getTypeId()) + ", ";
            }
            if (chestplate != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(chestplate.getTypeId()) + ", ";
            }
            if (leggings != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(leggings.getTypeId()) + ", ";
            }
            if (boots != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(boots.getTypeId()) + ", ";
            }
            msg = Helper.stripTrailing(msg, ", ");
            PreciousStones.log("confiscatedFrom", msg, player.getName(), field.toString());
            ChatBlock.send((CommandSender)player, "confiscated", msg);
        }
    }

    public void returnItems(Player player) {
        PlayerInventory inventory = player.getInventory();
        if (inventory == null) {
            return;
        }
        PlayerEntry entry = this.plugin.getPlayerManager().getPlayerEntry(player.getName());
        List<ItemStackEntry> confiscated = entry.returnInventory();
        ItemStackEntry helmet = entry.returnHelmet();
        ItemStackEntry chestplate = entry.returnChestplate();
        ItemStackEntry leggings = entry.returnLeggings();
        ItemStackEntry boots = entry.returnBoots();
        this.plugin.getStorageManager().updatePlayer(player.getName());
        player.updateInventory();
        if (helmet != null) {
            inventory.setHelmet(helmet.toItemStack());
        }
        if (chestplate != null) {
            inventory.setChestplate(chestplate.toItemStack());
        }
        if (leggings != null) {
            inventory.setLeggings(leggings.toItemStack());
        }
        if (boots != null) {
            inventory.setBoots(boots.toItemStack());
        }
        for (ItemStackEntry item : confiscated) {
            if (inventory.firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(player.getLocation(), item.toItemStack());
                continue;
            }
            inventory.addItem(new ItemStack[]{item.toItemStack()});
        }
        if (!confiscated.isEmpty() || helmet != null || chestplate != null || leggings != null || boots != null) {
            String msg = "";
            for (ItemStackEntry e : confiscated) {
                msg = msg + e.getAmount() + " " + Helper.friendlyBlockType(e.getTypeId()) + ", ";
            }
            if (helmet != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(helmet.getTypeId()) + ", ";
            }
            if (chestplate != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(chestplate.getTypeId()) + ", ";
            }
            if (leggings != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(leggings.getTypeId()) + ", ";
            }
            if (boots != null) {
                msg = msg + "1 " + Helper.friendlyBlockType(boots.getTypeId()) + ", ";
            }
            msg = Helper.stripTrailing(msg, ", ");
            PreciousStones.log("returnedTo", msg, player.getName());
            ChatBlock.send((CommandSender)player, "returned", msg);
        }
    }
}

