/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CuboidManager {
    private PreciousStones plugin;
    private HashMap<String, CuboidEntry> openCuboids = new HashMap();

    public CuboidManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public boolean hasOpenCuboid(Player player) {
        return this.openCuboids.containsKey(player.getName());
    }

    public boolean isOpenCuboid(Player player, Block block) {
        return this.isOpenCuboidField(player, block) || this.isOpenCuboidChild(player, block);
    }

    public boolean isOpenCuboidField(Player player, Block block) {
        Field field;
        if (block == null) {
            return false;
        }
        CuboidEntry ce = this.openCuboids.get(player.getName());
        return ce != null && (field = ce.getField()) != null && Helper.isSameBlock(field.getLocation(), block.getLocation());
    }

    public boolean isOpenCuboidChild(Player player, Block block) {
        CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null) {
            Field field = ce.getField();
            for (Field child : field.getChildren()) {
                if (!Helper.isSameBlock(child.getLocation(), block.getLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public CuboidEntry getOpenCuboid(Player player) {
        return this.openCuboids.get(player.getName());
    }

    public boolean processSelectedBlock(Player player, Block block) {
        CuboidEntry openCuboid = this.getOpenCuboid(player);
        if (!this.plugin.getVisualizationManager().isOutlineBlock(player, block)) {
            if (openCuboid.testOverflow(block.getLocation()) || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.cuboid")) {
                if (this.plugin.getWorldGuardManager().canBuild(player, block.getLocation())) {
                    if (this.openCuboids.containsKey(player.getName())) {
                        CuboidEntry ce = this.openCuboids.get(player.getName());
                        int oldVolume = ce.getAvailableVolume();
                        if (ce.isSelected(block)) {
                            ce.removeSelected(block);
                            this.plugin.getVisualizationManager().displaySingle(player, block.getType(), block);
                        } else {
                            CuboidEntry clone = ce.Clone();
                            clone.addSelected(block);
                            if (this.plugin.getForceFieldManager().existsConflict(clone.getMockField(), player)) {
                                ChatBlock.send((CommandSender)player, "cuboidSelectionConflicts", new Object[0]);
                                return false;
                            }
                            ce.addSelected(block);
                            this.plugin.getVisualizationManager().displaySingle(player, Material.getMaterial((int)this.plugin.getSettingsManager().getCuboidDefiningType()), block);
                        }
                        int newVolume = ce.getAvailableVolume();
                        if (newVolume != oldVolume) {
                            this.plugin.getVisualizationManager().displayFieldOutline(player, ce);
                            if (newVolume >= 0) {
                                ChatBlock.send((CommandSender)player, "cuboidAvailableProtection", newVolume);
                            } else {
                                ChatBlock.send((CommandSender)player, "cuboidAvailableProtectionBypass", newVolume);
                            }
                        }
                    }
                    return true;
                }
                ChatBlock.send((CommandSender)player, "cuboidCannotExtendWG", new Object[0]);
            } else {
                ChatBlock.send((CommandSender)player, "cuboidExceeds", new Object[0]);
            }
        } else {
            ChatBlock.send((CommandSender)player, "cuboidOutline", new Object[0]);
        }
        return false;
    }

    public void openCuboid(final Player player, final Field field) {
        final CuboidEntry ce = new CuboidEntry(field);
        this.openCuboids.put(player.getName(), ce);
        field.setOpen(true);
        this.plugin.getVisualizationManager().revert(player);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ce.addSelected(field.getBlock());
                for (Field child : field.getChildren()) {
                    ce.addSelected(child.getBlock());
                }
                CuboidManager.this.plugin.getVisualizationManager().displayFieldOutline(player, ce);
                ChatBlock.send((CommandSender)player, "cuboidDrawingMode", new Object[0]);
                ChatBlock.send((CommandSender)player, "cuboidAvailableProtection", ce.getAvailableVolume());
            }
        }, 1L);
    }

    public void openChild(final Player player, final Field field) {
        final CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ce.addSelected(field.getBlock());
                    PreciousStones.getInstance().getForceFieldManager().addSourceField(field);
                    ChatBlock.send((CommandSender)player, "cuboidAvailableProtection", ce.getAvailableVolume());
                }
            }, 1L);
        }
    }

    public boolean closeCuboid(Player player) {
        CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null) {
            Block foundBlock;
            Field field = ce.getField();
            if (ce.isExceeded() && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.cuboid")) {
                ChatBlock.send((CommandSender)player, "cuboidExceedsMax", new Object[0]);
                this.cancelOpenCuboid(player);
                return false;
            }
            if (this.plugin.getForceFieldManager().fieldConflicts(ce, player) != null) {
                ChatBlock.send((CommandSender)player, "cuboidConflicts", new Object[0]);
                this.cancelOpenCuboid(player);
                return false;
            }
            List<Vector> corners = field.getCorners();
            corners.add(field.getLocation().toVector());
            for (Vector corner : corners) {
                Location location = corner.toLocation(player.getWorld());
                if (this.plugin.getWorldGuardManager().canBuild(player, location)) continue;
                ChatBlock.send((CommandSender)player, "cuboidConflictsWG", new Object[0]);
                this.cancelOpenCuboid(player);
                return false;
            }
            if (field.hasFlag(FieldFlag.PREVENT_UNPROTECTABLE) && (foundBlock = this.plugin.getUnprotectableManager().existsUnprotectableBlock(field)) != null && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.unprotectable")) {
                this.plugin.getCommunicationManager().warnPlaceFieldInUnprotectable(player, foundBlock, field.getBlock());
                this.cancelOpenCuboid(player);
                return false;
            }
            this.plugin.getVisualizationManager().revert(player);
            this.plugin.getVisualizationManager().revertOutline(player);
            this.plugin.getForceFieldManager().removeSourceField(field);
            ce.finalizeField();
            field.setOpen(false);
            this.openCuboids.remove(player.getName());
            this.plugin.getForceFieldManager().addSourceField(field);
            this.plugin.getForceFieldManager().addAllowOverlappingOwners(field);
            this.plugin.getVisualizationManager().visualizeSingleField(player, field);
            this.plugin.getStorageManager().offerField(field);
            this.plugin.getCommunicationManager().notifyPlaceCuboid(player, field);
            return true;
        }
        return false;
    }

    public void removeChild(Player player, Block block) {
        CuboidEntry ce = this.openCuboids.get(player.getName());
        Field child = this.plugin.getForceFieldManager().getField(block);
        if (ce != null && child != null) {
            ce.getField().getChildren().remove(child);
        }
    }

    public void cancelOpenCuboid(Player player, Block block) {
        CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null) {
            Field field = ce.getField();
            if (Helper.isSameBlock(field.getLocation(), block.getLocation())) {
                this.cancelOpenCuboid(player);
            }
            for (Field child : field.getChildren()) {
                if (!Helper.isSameBlock(child.getLocation(), block.getLocation())) continue;
                this.cancelOpenCuboid(player);
            }
        }
    }

    public void cancelOpenCuboid(Player player) {
        this.plugin.getVisualizationManager().revert(player);
        this.plugin.getVisualizationManager().revertOutline(player);
        if (this.openCuboids.containsKey(player.getName())) {
            this.openCuboids.remove(player.getName());
            ChatBlock.send((CommandSender)player, "cuboidCancelled", new Object[0]);
        }
    }

    public void revertLastSelection(Player player) {
        BlockEntry selected;
        CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null && (selected = ce.getLastSelected()) != null) {
            ce.revertLastSelected();
            this.plugin.getVisualizationManager().revertSingle(player, selected.getBlock());
            this.plugin.getVisualizationManager().displayFieldOutline(player, ce);
            ChatBlock.send((CommandSender)player, "cuboidReverted", new Object[0]);
        }
    }

    public void expandDirection(Player player) {
        CuboidEntry ce = this.openCuboids.get(player.getName());
        if (ce != null) {
            Block block = ce.getExpandedBlock(player);
            if (block != null && !this.processSelectedBlock(player, block)) {
                return;
            }
            this.plugin.getVisualizationManager().displayFieldOutline(player, ce);
        }
    }
}

