/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.List;
import java.util.Random;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class ForesterManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void prepareLand(Field field, World world) {
        int minx = field.getX() - field.getRadius();
        int maxx = field.getX() + field.getRadius();
        int minz = field.getZ() - field.getRadius();
        int maxz = field.getZ() + field.getRadius();
        int miny = field.getY() - Math.max(field.getHeight() - 1, 0) / 2;
        int maxy = field.getY() + Math.max(field.getHeight() - 1, 0) / 2;
        for (int x = minx; x < maxx; x += 4) {
            for (int z = minz; z <= maxz; z += 4) {
                for (int y = maxy; y > miny; --y) {
                    int type = world.getBlockTypeIdAt(x, y, z);
                    if (this.isSeeThrough(type)) continue;
                    this.prepareSpot(field, world, x, y, z, 4);
                }
            }
        }
    }

    public int prepareSpot(Field field, World world, int xx, int yy, int zz, int radius) {
        PreciousStones.debug("prepare spot", new Object[0]);
        Vec pos = new Vec(xx, yy, zz, world.getName());
        int affected = 0;
        for (int x = 0; x <= radius; ++x) {
            for (int y = 0; y <= radius; ++y) {
                for (int z = 0; z <= radius; ++z) {
                    int typeabove;
                    Vec vec = pos.add(x, y, z);
                    double d = vec.distance(pos);
                    if (vec.getX() == field.getX() && vec.getY() == field.getY() && vec.getZ() == field.getZ() || !(d <= (double)radius + 0.5)) continue;
                    int type = world.getBlockTypeIdAt(vec.getX(), vec.getY(), vec.getZ());
                    if (!field.getSettings().isFertileType(type)) continue;
                    Block fertile = world.getBlockAt(vec.getX(), vec.getY(), vec.getZ());
                    fertile.setTypeId(field.getSettings().getGroundBlock());
                    if (field.getSettings().getShrubTypes().isEmpty() || (typeabove = world.getBlockTypeIdAt(vec.getX(), vec.getY() + 1, vec.getZ())) != 0) continue;
                    Random r = new Random();
                    int density = 100 - field.getSettings().getShrubDensity();
                    if (density != 0 && r.nextInt(density) != 0) continue;
                    Block blockAbove = world.getBlockAt(vec.getX(), vec.getY() + 1, vec.getZ());
                    this.setShrub(field.getSettings(), blockAbove);
                }
            }
        }
        return affected;
    }

    public void generateTree(Field field, Player player, World world) {
        int minx = field.getX() - field.getRadius();
        int maxx = field.getX() + field.getRadius();
        int minz = field.getZ() - field.getRadius();
        int maxz = field.getZ() + field.getRadius();
        int miny = field.getY() - (int)Math.floor((double)field.getHeight() / 2.0);
        int maxy = field.getY() + (int)Math.ceil((double)field.getHeight() / 2.0);
        Random r = new Random();
        int xr = r.nextInt(maxx - minx) + minx;
        int zr = r.nextInt(maxz - minz) + minz;
        for (int y = maxy; y > miny; --y) {
            Block floor = world.getBlockAt(xr, y, zr);
            int type = floor.getTypeId();
            if (this.isSeeThrough(type)) continue;
            if (type == field.getSettings().getGroundBlock()) {
                Field f;
                BlockFace[] faces;
                Block block = world.getBlockAt(xr, y + 1, zr);
                for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                    Block rel = block.getRelative(face);
                    if (!rel.getType().equals((Object)Material.LOG)) continue;
                    return;
                }
                if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place") && (f = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_PLACE)) != null && !field.getSettings().inPlaceBlacklist(block) && FieldFlag.PREVENT_PLACE.applies(field, player)) {
                    return;
                }
                floor.setType(Material.GRASS);
                block.setType(Material.AIR);
                world.generateTree(block.getLocation(), ForesterManager.getTree(field.getSettings()));
            }
            return;
        }
    }

    public static TreeType getTree(FieldSettings fs) {
        Random r = new Random();
        List<Integer> treeTypes = fs.getTreeTypes();
        if (treeTypes.isEmpty()) {
            return TreeType.TREE;
        }
        int rand = r.nextInt(treeTypes.size());
        int tree = treeTypes.get(rand);
        PreciousStones.debug("tree: " + tree, new Object[0]);
        switch (tree) {
            case 0: {
                return TreeType.TREE;
            }
            case 1: {
                return TreeType.BIG_TREE;
            }
            case 2: {
                return TreeType.REDWOOD;
            }
            case 3: {
                return TreeType.TALL_REDWOOD;
            }
            case 4: {
                return TreeType.BIRCH;
            }
            case 5: {
                return TreeType.RED_MUSHROOM;
            }
            case 6: {
                return TreeType.BROWN_MUSHROOM;
            }
            case 7: {
                return TreeType.JUNGLE;
            }
            case 8: {
                return TreeType.JUNGLE_BUSH;
            }
        }
        return TreeType.TREE;
    }

    public void setShrub(FieldSettings fs, Block block) {
        Random r = new Random();
        List<Integer> treeTypes = fs.getShrubTypes();
        int rand = r.nextInt(treeTypes.size());
        switch (treeTypes.get(rand)) {
            case 0: {
                block.setTypeIdAndData(31, (byte)0, false);
                return;
            }
            case 1: {
                block.setTypeIdAndData(31, (byte)1, false);
                return;
            }
            case 2: {
                block.setTypeIdAndData(31, (byte)2, false);
                return;
            }
            case 3: {
                block.setTypeId(37, false);
                return;
            }
            case 4: {
                block.setTypeId(38, false);
                return;
            }
            case 5: {
                block.setTypeId(40, false);
                return;
            }
            case 6: {
                block.setTypeId(39, false);
                return;
            }
        }
    }

    private boolean isSeeThrough(int type) {
        return type == 0 || type == 31 || type == 32 || type == 37 || type == 38 || type == 18 || type == 6;
    }

    public void doCreatureSpawns(Field field) {
        int minx = field.getX() - field.getRadius();
        int maxx = field.getX() + field.getRadius();
        int minz = field.getZ() - field.getRadius();
        int maxz = field.getZ() + field.getRadius();
        int miny = field.getY() - (int)Math.floor((double)field.getHeight() / 2.0);
        int maxy = field.getY() + (int)Math.ceil((double)field.getHeight() / 2.0);
        Random r = new Random();
        FieldSettings fs = field.getSettings();
        for (int i = 0; i < fs.getCreatureCount(); ++i) {
            int x = r.nextInt(maxx - minx) + minx;
            int z = r.nextInt(maxz - minz) + minz;
            int y = field.getY();
            World world = field.getBlock().getWorld();
            int floorType = world.getBlockTypeIdAt(x, y, z);
            while (!this.plugin.getSettingsManager().isThroughType(floorType) && y < 256) {
                floorType = world.getBlockTypeIdAt(x, ++y, z);
            }
            EntityType entity = ForesterManager.getEntity(fs);
            if (entity == null || !entity.isAlive() || !entity.isSpawnable()) continue;
            world.spawnCreature(new Location(world, (double)x, (double)y, (double)z), entity);
        }
    }

    public static EntityType getEntity(FieldSettings fs) {
        Random r = new Random();
        List<String> creatureTypes = fs.getCreatureTypes();
        if (creatureTypes.isEmpty()) {
            return null;
        }
        int rand = r.nextInt(creatureTypes.size());
        String entity = creatureTypes.get(rand);
        PreciousStones.debug("entity: " + entity, new Object[0]);
        if (entity.equalsIgnoreCase("None")) {
            return null;
        }
        return EntityType.fromName((String)entity);
    }
}

