/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.TreeMap;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class LanguageManager {
    private File file;
    private TreeMap<String, Object> language = new TreeMap();
    private String[] comments = new String[]{"# Guidelines", "\n#", "\n# 1. Never change the contents inside the variables { }", "\n# 2. You can rearrange the order that the variables appear on the sentences to best suit your language", "\n# 3. You can add/remove colors as you please", "\n# 4. If you change a command, make sure it's corresponding menu item matches", "\n# 5. When new text is added on future versions, they will be added automatically to your language.yml file", "\n#", "\n# Colors: {aqua}, {black}, {blue}, {white}, {yellow}, {gold}, {gray}, {green}, {red} ", "\n#         {dark-aqua}, {dark-blue}, {dark-gray}, {dark-green}, {dark-purple}, {dark-red}, {light-purple}", "\n#         {magic}, {bold}, {italic}, {reset}, {strikethrough}, {underline}\n\n"};

    public LanguageManager() {
        this.load();
    }

    public void load() {
        this.file = new File(PreciousStones.getInstance().getDataFolder() + File.separator + "language.yml");
        this.check();
    }

    private void check() {
        boolean exists = this.file.exists();
        this.loadDefaults();
        if (exists) {
            this.loadFile();
        }
        this.saveFile();
    }

    private void loadDefaults() {
        InputStream defaultLanguage = this.getClass().getResourceAsStream("/language.yml");
        HashMap objects = (HashMap)new Yaml().load(defaultLanguage);
        if (objects != null) {
            this.language.putAll(objects);
        }
    }

    private void loadFile() {
        try {
            FileInputStream fileLanguage = new FileInputStream(this.file);
            HashMap objects = (HashMap)new Yaml().load((InputStream)fileLanguage);
            if (objects != null) {
                this.language.putAll(objects);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void saveFile() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setWidth(99999999);
        options.setAllowUnicode(true);
        try {
            FileWriter fw = new FileWriter(this.file);
            StringWriter writer = new StringWriter();
            new Yaml(options).dump(this.language, (Writer)writer);
            for (String comment : this.comments) {
                fw.write(comment);
            }
            fw.write(writer.toString());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        Object o = this.language.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }
}

