/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LimitManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public boolean reachedLimit(Player player, FieldSettings fs) {
        List<Integer> limits = fs.getLimits();
        if (limits.isEmpty()) {
            return false;
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.limits")) {
            return false;
        }
        int limit = this.getLimit(player, fs);
        int count = this.plugin.getForceFieldManager().getFieldCount(player.getName(), fs.getTypeEntry());
        if (limit == -1) {
            return false;
        }
        if (limit == 0) {
            ChatBlock.send((CommandSender)player, "limitsCannotPlace", fs.getTitle());
            return true;
        }
        if (count >= limit) {
            ChatBlock.send((CommandSender)player, "limitsReached", fs.getTitle(), limit);
            return true;
        }
        int totalCount = this.plugin.getForceFieldManager().getTotalFieldCount(player.getName());
        if (totalCount >= this.plugin.getSettingsManager().getGlobalFieldLimit()) {
            ChatBlock.send((CommandSender)player, "limitsReachedGlobal", limit);
            return true;
        }
        return false;
    }

    public int getLimit(Player player, FieldSettings fs) {
        List<Integer> limits = fs.getLimits();
        if (limits.isEmpty()) {
            return -1;
        }
        ArrayList<Integer> playersLimits = new ArrayList<Integer>();
        for (int i = limits.size() - 1; i >= 0; --i) {
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.limit" + (i + 1))) continue;
            playersLimits.add(limits.get(i));
        }
        if (!playersLimits.isEmpty()) {
            return (Integer)Collections.max(playersLimits);
        }
        return -1;
    }
}

