/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.Collection;
import java.util.TreeMap;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerManager {
    private PreciousStones plugin;
    private TreeMap<String, PlayerEntry> players = new TreeMap();

    public PlayerManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public TreeMap<String, PlayerEntry> getPlayers() {
        TreeMap<String, PlayerEntry> p = new TreeMap<String, PlayerEntry>();
        p.putAll(this.players);
        return p;
    }

    public PlayerEntry getPlayerEntry(String playerName) {
        PlayerEntry data = this.players.get(playerName.toLowerCase());
        if (data == null) {
            data = new PlayerEntry();
            data.setName(playerName);
            this.players.put(playerName.toLowerCase(), data);
        }
        return data;
    }

    public void playerLogin(String playerName) {
        PlayerEntry data = this.getPlayerEntry(playerName);
        data.setOnline(true);
    }

    public void playerLogoff(Player player) {
        PlayerEntry data = this.getPlayerEntry(player.getName());
        data.setOnline(false);
        data.setOutsideLocation(null);
    }

    public void updateOutsideLocation(Player player) {
        PlayerEntry data = this.getPlayerEntry(player.getName());
        data.setOutsideLocation(player.getLocation());
    }

    public Location getOutsideLocation(Player player) {
        PlayerEntry data = this.getPlayerEntry(player.getName());
        Location loc = data.getOutsideLocation();
        if (loc != null) {
            loc = new Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY(), (double)loc.getBlockZ() + 0.5, loc.getYaw(), loc.getPitch());
        }
        return loc;
    }

    public Location getOutsideFieldLocation(Field field, Player player) {
        World world = player.getWorld();
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY() + 1;
        int z = player.getLocation().getBlockZ();
        int edgeX1 = field.getX() + (field.getRadius() + 1);
        int edgeX2 = field.getX() - (field.getRadius() + 1);
        int edgeZ1 = field.getZ() + (field.getRadius() + 1);
        int edgeZ2 = field.getZ() - (field.getRadius() + 1);
        Location loc = world.getSpawnLocation();
        if (this.isEmptySpace(world, edgeX1, y, z)) {
            loc = new Location(world, (double)edgeX1 + 0.5, (double)y, (double)z + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, edgeX2, y, z)) {
            loc = new Location(world, (double)edgeX2 + 0.5, (double)y, (double)z + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, x, y, edgeZ1)) {
            loc = new Location(world, (double)x + 0.5, (double)y, (double)edgeZ1 + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, x, y, edgeZ2)) {
            loc = new Location(world, (double)x + 0.5, (double)y, (double)edgeZ2 + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        }
        return loc;
    }

    private boolean isEmptySpace(World world, int x, int y, int z) {
        int type1 = world.getBlockTypeIdAt(x, y, z);
        int type2 = world.getBlockTypeIdAt(x, y, z);
        return this.plugin.getSettingsManager().isThroughType(type1) && this.plugin.getSettingsManager().isThroughType(type2);
    }

    public void offerOnlinePlayerEntries() {
        Collection onlinePlayers = Bukkit.getServer().getOnlinePlayers();
        for (Player player : onlinePlayers) {
            this.plugin.getStorageManager().offerPlayer(player.getName());
        }
    }
}

