/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void applyPotions(Player player, Field field) {
        HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
        String names = "";
        for (PotionEffectType pot : potions.keySet()) {
            int intensity = potions.get(pot);
            if (player.hasPotionEffect(pot)) continue;
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.manual.bypass.potions") && this.plugin.getSettingsManager().isHarmfulPotion(pot)) {
                return;
            }
            player.addPotionEffect(new PotionEffect(pot, 72000, intensity));
            this.plugin.getPermissionsManager().allowFast(player);
            names = names + pot.getName() + " ";
        }
        if (names.length() > 0) {
            // empty if block
        }
    }

    public void removePotions(Player player, Field field) {
        HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
        for (PotionEffectType pot : potions.keySet()) {
            if (!player.hasPotionEffect(pot)) continue;
            player.removePotionEffect(pot);
            this.plugin.getPermissionsManager().resetFast(player);
        }
    }

    public void neutralizePotions(Player player, Field field) {
        List<PotionEffectType> noPotions = field.getSettings().getNeutralizePotions();
        for (PotionEffectType pot : noPotions) {
            if (!player.hasPotionEffect(pot)) continue;
            player.removePotionEffect(pot);
            this.plugin.getPermissionsManager().resetFast(player);
            this.plugin.getCommunicationManager().showNoPotion(player, pot.getName());
        }
    }
}

