/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.SnitchEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SnitchManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void recordSnitchEntityKill(Player player, Entity entity) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(entity.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_kill", new Object[0]), entity.getType().getName(), 1));
            }
        }
    }

    public void recordSnitchPlayerKill(Player player, Player victim) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(victim.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_kill", new Object[0]), victim.getName(), 1));
            }
        }
    }

    public void recordSnitchEntry(Player player, Field field) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch") && FieldFlag.SNITCH.applies(field, player)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, h:mm a z");
            this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_entry", new Object[0]), dateFormat.format(new Date()), 1));
        }
    }

    public void recordSnitchBlockBreak(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_blockBreak", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public void recordSnitchBucketEmpty(Player player, Block block, String type) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                String details = Helper.friendlyBlockType(type) + " [" + block.getLocation().getBlockX() + " " + block.getLocation().getBlockY() + " " + block.getLocation().getBlockZ() + "]";
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_bucketEmpty", new Object[0]), details, 1));
            }
        }
    }

    public void recordSnitchBucketFill(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_bucketFilled", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public void recordSnitchBlockPlace(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_blockPlace", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public void recordSnitchUsed(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_used", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public void recordSnitchLWC(Player player, Block block, Set<String> actions) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                for (String action : actions) {
                    this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_LWC", new Object[0]) + " " + action, Helper.toLocationString(block.getLocation()), 1));
                }
            }
        }
    }

    public void recordSnitchShop(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (sign.getLines().length == 0) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_shopped", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public void recordSnitchIgnite(Player player, Block block) {
        if (this.plugin.getPermissionsManager().isVanished(player)) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.snitch")) {
            List<Field> snitchFields = this.plugin.getForceFieldManager().getEnabledSourceFields(block.getLocation(), FieldFlag.SNITCH);
            for (Field field : snitchFields) {
                if (!FieldFlag.SNITCH.applies(field, player)) continue;
                this.plugin.getStorageManager().offerSnitchEntry(new SnitchEntry(field, player.getName(), ChatBlock.format("_ignited", new Object[0]), SnitchManager.toBlockDetails(block), 1));
            }
        }
    }

    public static String toBlockDetails(Block block) {
        if (PreciousStones.getInstance().getSettingsManager().isUseIdInSnitches()) {
            return new BlockTypeEntry(block).toString() + " [" + block.getLocation().getBlockX() + " " + block.getLocation().getBlockY() + " " + block.getLocation().getBlockZ() + "]";
        }
        return Helper.friendlyBlockType(block.getType().toString()) + " [" + block.getLocation().getBlockX() + " " + block.getLocation().getBlockY() + " " + block.getLocation().getBlockZ() + "]";
    }
}

