/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.TranslocationApplier;
import net.sacredlabyrinth.Phaed.PreciousStones.TranslocationImporter;
import net.sacredlabyrinth.Phaed.PreciousStones.TranslocationRemover;
import net.sacredlabyrinth.Phaed.PreciousStones.TranslocationUpdater;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.TranslocationBlock;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public final class TranslocationManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void addBlock(Field field, Block block) {
        this.addBlock(field, block, false);
    }

    public void addBlock(final Field field, final Block block, final boolean isImport) {
        if (!this.plugin.getSettingsManager().isDependentBlock(block.getTypeId())) {
            BlockFace[] faces;
            for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                Block rel = block.getRelative(face);
                if (!this.plugin.getSettingsManager().isDependentBlock(rel.getTypeId())) continue;
                this.addBlock(field, rel, isImport);
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (Helper.isDoor(block)) {
                    Block bottom = block.getRelative(BlockFace.DOWN);
                    Block top = block.getRelative(BlockFace.UP);
                    if (Helper.isDoor(bottom)) {
                        TranslocationManager.this.plugin.getStorageManager().insertTranslocationBlock(field, new TranslocationBlock(field, bottom));
                    }
                    if (Helper.isDoor(top)) {
                        TranslocationManager.this.plugin.getStorageManager().insertTranslocationBlock(field, new TranslocationBlock(field, top));
                    }
                    if (isImport) {
                        if (Helper.isDoor(block)) {
                            block.setTypeIdAndData(0, (byte)0, true);
                        }
                        if (Helper.isDoor(bottom)) {
                            bottom.setTypeIdAndData(0, (byte)0, true);
                        }
                        if (Helper.isDoor(top)) {
                            top.setTypeIdAndData(0, (byte)0, true);
                        }
                    }
                    return;
                }
            }
        }, 5L);
        TranslocationBlock tb = new TranslocationBlock(field, block);
        if (block.getType().equals((Object)Material.WALL_SIGN) || block.getType().equals((Object)Material.SIGN)) {
            tb.setSignText(this.getSignText(block));
        }
        if (block.getState() instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)block.getState();
            Inventory inv = holder.getInventory();
            tb.setContents(inv.getContents());
        }
        boolean isApplied = !isImport;
        this.plugin.getStorageManager().insertTranslocationBlock(field, tb, isApplied);
        if (!isImport) {
            int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
            field.setTranslocationSize(count);
        } else if (!Helper.isDoor(block)) {
            block.setTypeIdAndData(0, (byte)0, true);
        }
    }

    public void removeBlock(Field field, Block block) {
        TranslocationBlock tb = new TranslocationBlock(block);
        tb.setRelativeCoords(field);
        this.plugin.getStorageManager().deleteTranslocation(field, tb);
        int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
        field.setTranslocationSize(count);
    }

    private String getSignText(Block block) {
        String signText = "";
        Sign sign = (Sign)block.getState();
        for (String line : sign.getLines()) {
            signText = signText + line + "`";
        }
        signText = Helper.stripTrailing(signText, "`");
        return signText;
    }

    public int applyTranslocation(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            Queue<TranslocationBlock> tbs = this.plugin.getStorageManager().retrieveTranslocation(field);
            if (!tbs.isEmpty()) {
                TranslocationApplier rollback = new TranslocationApplier(field, tbs, world);
            }
            return tbs.size();
        }
        return 0;
    }

    public boolean applyTranslocationBlock(TranslocationBlock tb, World world) {
        int[] seeThrough;
        Block block = world.getBlockAt(tb.getX(), tb.getY(), tb.getZ());
        if (!block.getType().equals((Object)Material.AIR) && !block.getType().equals((Object)Material.STATIONARY_WATER) && block.getType().equals((Object)Material.WATER) && block.getType().equals((Object)Material.STATIONARY_LAVA) && block.getType().equals((Object)Material.LAVA)) {
            return false;
        }
        if (tb.isEmpty()) {
            block.setTypeIdAndData(tb.getTypeId(), tb.getData(), true);
            return true;
        }
        boolean noConflict = false;
        block0: for (int st : seeThrough = new int[]{0, 6, 8, 31, 32, 37, 38, 39, 40, 9, 10, 11, 12, 51, 59, 83, 81}) {
            if (block.getTypeId() != st) continue;
            noConflict = true;
            if (st != 12) break;
            for (int count = 1; count < 256; ++count) {
                int type = world.getBlockTypeIdAt(tb.getX(), tb.getY() + count, tb.getZ());
                if (type != 0 && type != 8 && type != 9 && type != 10 && type != 11) continue;
                Block toSand = world.getBlockAt(tb.getX(), tb.getY() + count, tb.getZ());
                toSand.setTypeId(12, false);
                break block0;
            }
            break;
        }
        if (noConflict) {
            block.setTypeIdAndData(tb.getTypeId(), tb.getData(), true);
            if (block.getState() instanceof Sign && !tb.getSignText().isEmpty()) {
                Sign sign = (Sign)block.getState();
                String[] lines = tb.getSignText().split("[`]");
                for (int i = 0; i < lines.length; ++i) {
                    sign.setLine(i, lines[i]);
                    sign.update();
                }
            }
            if (tb.hasItemStacks()) {
                InventoryHolder holder = (InventoryHolder)block.getState();
                Inventory inv = holder.getInventory();
                inv.setContents(tb.getItemStacks());
            }
        }
        return true;
    }

    public int clearTranslocation(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            Queue<TranslocationBlock> tbs = this.plugin.getStorageManager().retrieveClearTranslocation(field);
            if (!tbs.isEmpty()) {
                TranslocationUpdater rollback = new TranslocationUpdater(field, tbs, world);
            }
            return tbs.size();
        }
        return 0;
    }

    public boolean wipeTranslocationBlock(Field field, TranslocationBlock tb) {
        Block block = tb.getBlock();
        if ((tb = this.processBlock(tb)) != null) {
            this.addBlock(field, block, true);
            block.setTypeIdAndData(0, (byte)0, true);
            return true;
        }
        return false;
    }

    public boolean updateTranslationBlock(Field field, TranslocationBlock tb, boolean clear) {
        Block block = tb.getBlock();
        if ((tb = this.processBlock(tb)) != null) {
            if (block.getData() != tb.getData()) {
                tb.setData(block.getData());
                this.plugin.getStorageManager().updateTranslocationBlockData(field, tb);
            }
            if (tb.hasItemStacks()) {
                this.plugin.getStorageManager().updateTranslocationBlockContents(field, tb);
            }
            if (!tb.getSignText().isEmpty()) {
                this.plugin.getStorageManager().updateTranslocationSignText(field, tb);
            }
            if (clear) {
                block.setTypeIdAndData(0, (byte)0, true);
            }
            return true;
        }
        return false;
    }

    private TranslocationBlock processBlock(TranslocationBlock tb) {
        int id2;
        boolean equal;
        Block block = tb.getBlock();
        int id1 = block.getTypeId();
        boolean bl = equal = id1 == (id2 = tb.getTypeId());
        if (id1 == 3 && id2 == 2 || id1 == 2 && id2 == 3 || id1 == 9 && id2 == 8 || id1 == 8 && id2 == 9 || id1 == 11 && id2 == 10 || id1 == 10 && id2 == 11 || id1 == 73 && id2 == 74 || id1 == 74 && id2 == 73 || id1 == 61 && id2 == 62 || id1 == 62 && id2 == 61) {
            equal = true;
        }
        if (!equal) {
            PreciousStones.debug("translocation block rejected, it's id changed since it was recorded: " + block.getTypeId() + " " + tb.getTypeId(), new Object[0]);
            return null;
        }
        if (block.getType().equals((Object)Material.WALL_SIGN) || block.getType().equals((Object)Material.SIGN)) {
            tb.setSignText(this.getSignText(block));
        }
        if (block.getState() instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)block.getState();
            Inventory inv = holder.getInventory();
            tb.setContents(inv.getContents());
            inv.clear();
        }
        return tb;
    }

    public void zeroOutBlock(TranslocationBlock tb) {
        Block block = tb.getBlock().getWorld().getBlockAt(tb.getX(), tb.getY(), tb.getZ());
        block.setTypeIdAndData(0, (byte)0, true);
    }

    public void flashFieldBlock(final Field field, Player player) {
        final Set<Player> inhabitants = this.plugin.getForceFieldManager().getFieldInhabitants(field);
        inhabitants.add(player);
        for (Player p : inhabitants) {
            p.sendBlockChange(field.getLocation(), Material.GLASS, (byte)0);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Player p : inhabitants) {
                    p.sendBlockChange(field.getLocation(), field.getTypeId(), field.getData());
                }
            }
        }, 20L);
    }

    public void importBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        ProcessResult result = this.processBlocks(field, player, entries);
        Queue<TranslocationBlock> tbs = result.tbs;
        int notImported = result.notImported;
        int imported = tbs.size();
        if (!tbs.isEmpty()) {
            TranslocationImporter importer = new TranslocationImporter(field, tbs, player);
            ChatBlock.send((CommandSender)player, "translocationImportingBlocks", imported);
            if (notImported > 0) {
                ChatBlock.send((CommandSender)player, "translocationSkippedDueToLimit", notImported);
            }
        } else {
            ChatBlock.send((CommandSender)player, "nothingToImport", new Object[0]);
        }
        field.setDisabled(true);
        field.dirtyFlags();
    }

    public void removeBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        ProcessResult result = this.processBlocks(field, player, entries);
        Queue<TranslocationBlock> tbs = result.tbs;
        int notImported = result.notImported;
        int imported = tbs.size();
        if (!tbs.isEmpty()) {
            TranslocationRemover remover = new TranslocationRemover(field, tbs, player);
            ChatBlock.send((CommandSender)player, "translocationRemovingBlocks", imported);
            if (notImported > 0) {
                ChatBlock.send((CommandSender)player, "translocationSkippedDueToLimit", notImported);
            }
        } else {
            ChatBlock.send((CommandSender)player, "nothingToRemove", new Object[0]);
        }
        field.setDisabled(true);
        field.dirtyFlags();
    }

    private ProcessResult processBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        int minx = field.getMinx();
        int maxx = field.getMaxx();
        int minz = field.getMinz();
        int maxz = field.getMaxz();
        int miny = field.getMiny();
        int maxy = field.getMaxy();
        int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
        int maxCount = this.plugin.getSettingsManager().getMaxSizeTranslocation();
        int notImported = 0;
        LinkedList<TranslocationBlock> tbs = new LinkedList<TranslocationBlock>();
        HashMap<Integer, BlockTypeEntry> map = new HashMap<Integer, BlockTypeEntry>();
        if (entries != null) {
            for (BlockTypeEntry e : entries) {
                map.put(e.getTypeId(), e);
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                for (int y = miny; y <= maxy; ++y) {
                    if (field.getX() == x && field.getY() == y && field.getZ() == z) continue;
                    if (count <= maxCount) {
                        Block block;
                        int id = player.getWorld().getBlockTypeIdAt(x, y, z);
                        if (entries != null) {
                            BlockTypeEntry actual;
                            if (!map.containsKey(id)) continue;
                            block = player.getWorld().getBlockAt(x, y, z);
                            BlockTypeEntry entry = (BlockTypeEntry)map.get(id);
                            if (!entry.equals(actual = new BlockTypeEntry(block)) || !field.getSettings().canTranslocate(actual)) continue;
                            tbs.add(new TranslocationBlock(field, block));
                            ++count;
                            continue;
                        }
                        if (id == 0) continue;
                        block = player.getWorld().getBlockAt(x, y, z);
                        if (!field.getSettings().canTranslocate(new BlockTypeEntry(block))) continue;
                        tbs.add(new TranslocationBlock(field, block));
                        ++count;
                        continue;
                    }
                    ++notImported;
                }
            }
        }
        return new ProcessResult(tbs, notImported);
    }

    private final class ProcessResult {
        public Queue<TranslocationBlock> tbs;
        public int notImported;

        public ProcessResult(Queue<TranslocationBlock> tbs, int notImported) {
            this.tbs = tbs;
            this.notImported = notImported;
        }
    }
}

