/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.vectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.DirtyFieldReason;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.ResultsFilter;
import net.sacredlabyrinth.Phaed.PreciousStones.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.StackHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ForesterEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PaymentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.RentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.SnitchEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.PermissionsManager;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WaterMob;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import ps.org.joda.time.DateTime;
import ps.org.joda.time.Days;

public class Field
extends AbstractVec
implements Comparable<Field> {
    private final Field self;
    private FieldSettings settings;
    private long id = 0L;
    private int radius;
    private int height;
    private int maxx;
    private int maxy;
    private int maxz;
    private int minx;
    private int miny;
    private float velocity;
    private int minz;
    private BlockTypeEntry type;
    private String owner;
    private String newOwner;
    private String name;
    private Field parent;
    private List<Field> children = new ArrayList<Field>();
    private List<String> allowed = new ArrayList<String>();
    private List<String> renters = new ArrayList<String>();
    private List<String> blacklistedCommands = new ArrayList<String>();
    private List<BlockTypeEntry> whitelistedBlocks = new ArrayList<BlockTypeEntry>();
    private Set<DirtyFieldReason> dirty = new HashSet<DirtyFieldReason>();
    private List<GriefBlock> grief = new ArrayList<GriefBlock>();
    private List<SnitchEntry> snitches = new ArrayList<SnitchEntry>();
    private List<FieldFlag> flags = new ArrayList<FieldFlag>();
    private List<FieldFlag> disabledFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> insertedFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> clearedFlags = new ArrayList<FieldFlag>();
    private List<BlockEntry> fenceBlocks = new ArrayList<BlockEntry>();
    private List<RentEntry> renterEntries = new ArrayList<RentEntry>();
    private long lastUsed;
    private boolean progress;
    private boolean open;
    private int revertSecs;
    private boolean disabled;
    private int disablerId;
    private boolean translocating;
    private int translocationSize;
    private boolean hidden;
    private List<PaymentEntry> payment = new ArrayList<PaymentEntry>();
    private PaymentEntry purchase;
    private boolean signIsClean;
    private int limitSeconds;
    private int foresterUsed;
    private boolean foresting;

    public Field(int x, int y, int z, int minx, int miny, int minz, int maxx, int maxy, int maxz, float velocity, String world, BlockTypeEntry type, String owner, String name, long lastUsed) {
        super(x, y, z, world);
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
        this.maxx = maxx;
        this.maxy = maxy;
        this.maxz = maxz;
        this.radius = Helper.getWidthFromCoords(x, minx);
        this.height = 0;
        this.velocity = velocity;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.lastUsed = lastUsed;
        this.self = this;
    }

    public Field(int x, int y, int z, int radius, int height, float velocity, String world, BlockTypeEntry type, String owner, String name, long lastUsed) {
        super(x, y, z, world);
        this.radius = radius;
        this.height = height;
        this.velocity = velocity;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.lastUsed = lastUsed;
        this.self = this;
        this.calculateDimensions();
    }

    public Field(Block block, int radius, int height, String owner) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.radius = radius;
        this.height = height;
        this.owner = owner;
        this.name = "";
        this.type = new BlockTypeEntry(block.getTypeId(), block.getData());
        this.self = this;
        this.calculateDimensions();
    }

    public Field(Block block, int radius, int height) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.radius = radius;
        this.height = height;
        this.name = "";
        this.owner = "";
        this.type = new BlockTypeEntry(block.getTypeId(), block.getData());
        this.self = this;
        this.calculateDimensions();
    }

    public Field(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.self = this;
    }

    public Field() {
        this.self = this;
    }

    private void calculateDimensions() {
        this.minx = this.getX() - this.radius;
        this.maxx = this.getX() + this.radius;
        this.minz = this.getZ() - this.radius;
        this.maxz = this.getZ() + this.radius;
        this.miny = this.getY() - this.radius;
        this.maxy = this.getY() + this.radius;
        if (this.height > 0) {
            this.miny = this.getY() - (this.height - 1) / 2;
            this.maxy = this.getY() + (this.height - 1) / 2;
        }
        if (this.hasFlag(FieldFlag.CUBOID)) {
            this.dirty.add(DirtyFieldReason.DIMENSIONS);
        }
    }

    public int getMaxVolume() {
        int side;
        if (this.settings.getCustomVolume() > 0) {
            return this.settings.getCustomVolume();
        }
        int h = side = Math.max(this.settings.getRadius() * 2 + 1, 1);
        if (this.height > 0) {
            h = this.height;
        }
        return side * side * h;
    }

    public int getActualVolume() {
        int widthX = Helper.getWidthFromCoords(this.maxx, this.minx);
        int widthZ = Helper.getWidthFromCoords(this.maxz, this.minz);
        int height = Helper.getWidthFromCoords(this.maxy, this.miny);
        return height * widthX * widthZ;
    }

    public int getFlatVolume() {
        int widthX = Helper.getWidthFromCoords(this.maxx, this.minx);
        int widthZ = Helper.getWidthFromCoords(this.maxz, this.minz);
        return widthX * widthZ;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        if (this.height == 0) {
            this.height = this.radius * 2 + 1;
        }
        this.calculateDimensions();
        if (this.hasFlag(FieldFlag.CUBOID)) {
            this.dirty.add(DirtyFieldReason.DIMENSIONS);
        } else {
            this.dirty.add(DirtyFieldReason.HEIGHT);
            this.dirty.add(DirtyFieldReason.RADIUS);
        }
    }

    public int canSetCuboidRadius(int radius) {
        int volume = this.getMaxVolume();
        int newVolume = (radius * 2 + 1) * 3;
        return newVolume - volume;
    }

    public int expand(int num, String dir, boolean bypass) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.expand(num, dir);
        int overflow = ce.getOverflow();
        if (overflow <= 0 || bypass) {
            ce.finalizeField();
        }
        return overflow;
    }

    public int expand(int u, int d, int n, int s, int e, int w, boolean bypass) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.expand(u, d, n, s, e, w);
        int overflow = ce.getOverflow();
        if (overflow <= 0 || bypass) {
            ce.finalizeField();
        }
        return overflow;
    }

    public void contract(int num, String dir) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.contract(num, dir);
        ce.finalizeField();
    }

    public void contract(int u, int d, int n, int s, int e, int w) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.contract(u, d, n, s, e, w);
        ce.finalizeField();
    }

    public void setCuboidDimensions(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minx = minX;
        this.miny = minY;
        this.minz = minZ;
        this.maxx = maxX;
        this.maxy = maxY;
        this.maxz = maxZ;
        this.radius = (Helper.getWidthFromCoords(this.maxx, this.minx) - 1 + (Helper.getWidthFromCoords(this.maxz, this.minz) - 1)) / 2 / 2;
        this.dirty.add(DirtyFieldReason.DIMENSIONS);
    }

    public void setRelativeCuboidDimensions(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        World world = this.getBlock().getWorld();
        Location min = new Location(world, (double)minX, (double)minY, (double)minZ);
        min = min.add(this.getLocation());
        Location max = new Location(world, (double)maxX, (double)maxY, (double)maxZ);
        max = max.add(this.getLocation());
        this.setCuboidDimensions(min.getBlockX(), min.getBlockY(), min.getBlockZ(), max.getBlockX(), max.getBlockY(), max.getBlockZ());
    }

    public Location getRelativeMin() {
        World world = this.getBlock().getWorld();
        Location min = new Location(world, (double)this.minx, (double)this.miny, (double)this.minz);
        min.subtract(this.getLocation());
        return min;
    }

    public Location getRelativeMax() {
        World world = this.getBlock().getWorld();
        Location max = new Location(world, (double)this.maxx, (double)this.maxy, (double)this.maxz);
        max.subtract(this.getLocation());
        return max;
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public byte getData() {
        return this.type.getData();
    }

    public BlockTypeEntry getTypeEntry() {
        return this.type;
    }

    public String getType() {
        return Material.getMaterial((int)this.getTypeId()).toString();
    }

    public int getRadius() {
        return this.radius;
    }

    public int getHeight() {
        if (this.height == 0) {
            return this.radius * 2 + 1;
        }
        return this.height;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.dirty.add(DirtyFieldReason.OWNER);
    }

    public boolean isOwner(String playerName) {
        return this.owner.equalsIgnoreCase(playerName);
    }

    public void setName(String name) {
        this.name = name;
        this.dirty.add(DirtyFieldReason.NAME);
    }

    public String getName() {
        return this.name;
    }

    public boolean isName(String name) {
        if (name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase(name);
    }

    public List<String> getAllAllowed() {
        ArrayList<String> all = new ArrayList<String>();
        all.add(this.owner.toLowerCase());
        all.addAll(this.allowed);
        all.addAll(this.renters);
        return all;
    }

    public boolean isInAllowedList(String target) {
        return this.allowed.contains(target.toLowerCase());
    }

    public boolean isAllowed(String target) {
        ScoreboardManager manager;
        Scoreboard board;
        Team team;
        if (target.equalsIgnoreCase(this.owner)) {
            return true;
        }
        if (this.allowed.contains("*")) {
            return true;
        }
        if (this.allowed.contains(target.toLowerCase())) {
            return true;
        }
        if (this.renters.contains(target.toLowerCase())) {
            return true;
        }
        List<String> groups = PreciousStones.getInstance().getPermissionsManager().getGroups(this.getWorld(), target);
        for (String group : groups) {
            if (!this.allowed.contains("g:" + group)) continue;
            return true;
        }
        String clan = PreciousStones.getInstance().getSimpleClansManager().getClan(target);
        if (clan != null && this.allowed.contains("c:" + clan)) {
            return true;
        }
        OfflinePlayer offlinePlayer = PreciousStones.getInstance().getServer().getOfflinePlayer(target);
        return offlinePlayer != null && (team = (board = (manager = Bukkit.getScoreboardManager()).getNewScoreboard()).getPlayerTeam(offlinePlayer)) != null && this.allowed.contains("t:" + team.getName());
    }

    public boolean addAllowed(String target) {
        if (this.isAllowed(target)) {
            return false;
        }
        this.allowed.add(target.toLowerCase());
        this.dirty.add(DirtyFieldReason.ALLOWED);
        return true;
    }

    public void removeAllowed(String target) {
        this.allowed.remove(target.toLowerCase());
        this.dirty.add(DirtyFieldReason.ALLOWED);
    }

    public String getCoords() {
        return super.toString();
    }

    public String getCleanCoords() {
        return this.getX() + " " + this.getY() + " " + this.getZ();
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.getOwner() + "]";
    }

    public List<Vector> getCorners() {
        ArrayList<Vector> corners = new ArrayList<Vector>();
        corners.add(new Vector(this.minx, this.miny, this.minz));
        corners.add(new Vector(this.minx, this.miny, this.maxz));
        corners.add(new Vector(this.minx, this.maxy, this.minz));
        corners.add(new Vector(this.minx, this.maxy, this.maxz));
        corners.add(new Vector(this.maxx, this.miny, this.minz));
        corners.add(new Vector(this.maxx, this.miny, this.maxz));
        corners.add(new Vector(this.maxx, this.maxy, this.minz));
        corners.add(new Vector(this.maxx, this.maxy, this.maxz));
        return corners;
    }

    public Set<ChunkVec> getEnvelopingChunks() {
        HashSet<ChunkVec> envelopingChunks = new HashSet<ChunkVec>();
        for (int x = this.minx; x <= this.maxx + 15; x += 16) {
            for (int z = this.minz; z <= this.maxz + 15; z += 16) {
                envelopingChunks.add(new ChunkVec(x >> 4, z >> 4, this.getWorld()));
            }
        }
        return envelopingChunks;
    }

    public Set<Field> getIntersectingFields() {
        Set<ChunkVec> envelopingChunks = this.getEnvelopingChunks();
        HashSet<Field> sources = new HashSet<Field>();
        for (ChunkVec ecv : envelopingChunks) {
            List<Field> fields = PreciousStones.getInstance().getForceFieldManager().getSourceFieldsInChunk(ecv, FieldFlag.ALL, new ResultsFilter[0]);
            for (Field field : fields) {
                if (field.equals(this) || !field.intersects(this)) continue;
                sources.add(field);
            }
        }
        return sources;
    }

    public boolean intersects(Field field) {
        if (!field.getWorld().equals(this.getWorld())) {
            return false;
        }
        List<Vector> corners = field.getCorners();
        for (Vector vec : corners) {
            if (!this.envelops(vec)) continue;
            return true;
        }
        corners = this.getCorners();
        for (Vector vec : corners) {
            if (!field.envelops(vec)) continue;
            return true;
        }
        return false;
    }

    public boolean envelops(Vector vec) {
        int px = vec.getBlockX();
        int py = vec.getBlockY();
        int pz = vec.getBlockZ();
        return px >= this.minx && px <= this.maxx && py >= this.miny && py <= this.maxy && pz >= this.minz && pz <= this.maxz;
    }

    public boolean envelops(AbstractVec field) {
        int px = field.getX();
        int py = field.getY();
        int pz = field.getZ();
        return px >= this.minx && px <= this.maxx && py >= this.miny && py <= this.maxy && pz >= this.minz && pz <= this.maxz;
    }

    public boolean envelops(Block block) {
        return this.envelops(new Vec(block));
    }

    public boolean envelops(Location loc) {
        return this.envelops(new Vec(loc));
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float velocity) {
        this.velocity = velocity;
        this.dirty.add(DirtyFieldReason.VELOCITY);
    }

    public void markForDeletion() {
        this.dirty.add(DirtyFieldReason.DELETE);
    }

    public List<String> getAllowed() {
        return Collections.unmodifiableList(this.allowed);
    }

    public List<String> getRenters() {
        return Collections.unmodifiableList(this.renters);
    }

    public boolean isRented() {
        return !this.renters.isEmpty();
    }

    public boolean isBought() {
        return this.purchase != null;
    }

    public boolean isRenter(String playerName) {
        return this.renters.contains(playerName.toLowerCase());
    }

    public String getPackedAllowed() {
        return Helper.toMessage(this.allowed, "|");
    }

    public void setPackedAllowed(String packedAllowed) {
        this.allowed = Helper.fromArray(packedAllowed.split("[|]"));
    }

    public void addGriefBlock(GriefBlock gb) {
        if (!this.grief.contains(gb)) {
            this.grief.add(gb);
        }
        this.dirty.add(DirtyFieldReason.GRIEF_BLOCKS);
    }

    public Queue<GriefBlock> getGrief() {
        LinkedList<GriefBlock> g = new LinkedList<GriefBlock>();
        g.addAll(this.grief);
        this.grief.clear();
        return g;
    }

    public void clearSnitch() {
        this.snitches.clear();
    }

    public List<SnitchEntry> getSnitches() {
        return Collections.unmodifiableList(this.snitches);
    }

    public void updateLastUsed() {
        this.lastUsed = new DateTime().getMillis();
        this.dirty.add(DirtyFieldReason.LASTUSED);
    }

    public int getAgeInDays() {
        if (this.lastUsed <= 0L) {
            return 0;
        }
        return Days.daysBetween(new DateTime(this.lastUsed), new DateTime()).getDays();
    }

    public FieldSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FieldSettings settings) {
        for (FieldFlag flag : settings.getDefaultFlags()) {
            this.flags.add(flag);
        }
        this.settings = settings;
    }

    public boolean isDirty(DirtyFieldReason dirtyType) {
        return this.dirty.contains((Object)dirtyType);
    }

    public boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    public void clearDirty() {
        this.dirty.clear();
    }

    public double distance(Location loc) {
        return Math.sqrt(Math.pow(loc.getBlockX() - this.getX(), 2.0) + Math.pow(loc.getBlockY() - this.getY(), 2.0) + Math.pow(loc.getBlockZ() - this.getZ(), 2.0));
    }

    @Override
    public int compareTo(Field field) throws ClassCastException {
        int c = this.getX() - field.getX();
        if (c == 0) {
            c = this.getZ() - field.getZ();
        }
        if (c == 0) {
            c = this.getY() - field.getY();
        }
        if (c == 0) {
            c = this.getWorld().compareTo(field.getWorld());
        }
        return c;
    }

    public int getMaxx() {
        return this.maxx;
    }

    public int getMaxy() {
        return this.maxy;
    }

    public int getMaxz() {
        return this.maxz;
    }

    public int getMinx() {
        return this.minx;
    }

    public int getMiny() {
        return this.miny;
    }

    public int getMinz() {
        return this.minz;
    }

    public String getDimensionString() {
        return String.format("minx: %s maxx: %s miny: %s maxy: %s minz: %s maxz: %s", this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz);
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<Field> getChildren() {
        return this.children;
    }

    public Set<Field> getFamily() {
        HashSet<Field> out = new HashSet<Field>();
        out.addAll(this.children);
        out.add(this);
        return out;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void clearParent() {
        this.parent = null;
    }

    public void addChild(Field field) {
        this.children.add(field);
    }

    public Field getParent() {
        return this.parent;
    }

    public void setParent(Field parent) {
        this.parent = parent;
    }

    public boolean isParent() {
        return !this.children.isEmpty();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean hasFlag(FieldFlag flag) {
        boolean ret = this.flags.contains((Object)flag);
        if (!ret) {
            ret = this.insertedFlags.contains((Object)flag);
        }
        if (this.disabledFlags.contains((Object)flag)) {
            ret = false;
        }
        return ret;
    }

    public boolean hasFlag(String flagStr) {
        return this.hasFlag(Helper.toFieldFlag(flagStr));
    }

    public String getFlagsAsString() {
        JSONObject json = new JSONObject();
        JSONArray disabledFlags = new JSONArray();
        disabledFlags.addAll(this.getDisabledFlagsStringList());
        JSONArray clearedFlags = new JSONArray();
        clearedFlags.addAll(this.getClearedFlagsStringList());
        JSONArray insertedFlags = new JSONArray();
        insertedFlags.addAll(this.getInsertedFlagsStringList());
        JSONArray renterList = new JSONArray();
        renterList.addAll(this.getRentersString());
        JSONArray paymentList = new JSONArray();
        paymentList.addAll(this.getPaymentString());
        JSONArray blacklistedCommandsList = new JSONArray();
        blacklistedCommandsList.addAll(this.blacklistedCommands);
        JSONArray whitelistedBlocksList = new JSONArray();
        whitelistedBlocksList.addAll(this.whitelistedBlocks);
        if (!paymentList.isEmpty()) {
            json.put((Object)"payments", (Object)paymentList);
        }
        if (!disabledFlags.isEmpty()) {
            json.put((Object)"disabledFlags", (Object)disabledFlags);
        }
        if (!insertedFlags.isEmpty()) {
            json.put((Object)"insertedFlags", (Object)insertedFlags);
        }
        if (!clearedFlags.isEmpty()) {
            json.put((Object)"clearedFlags", (Object)clearedFlags);
        }
        if (!blacklistedCommandsList.isEmpty()) {
            json.put((Object)"blacklistedCommands", (Object)blacklistedCommandsList);
        }
        if (!renterList.isEmpty()) {
            json.put((Object)"renters", (Object)renterList);
        }
        if (this.revertSecs > 0) {
            json.put((Object)"revertSecs", (Object)this.revertSecs);
        }
        if (this.limitSeconds > 0) {
            json.put((Object)"limitSeconds", (Object)this.limitSeconds);
        }
        if (this.disabled) {
            json.put((Object)"disabled", (Object)this.disabled);
        }
        if (this.hidden) {
            json.put((Object)"hidden", (Object)this.hidden);
        }
        if (this.purchase != null) {
            json.put((Object)"purchase", (Object)this.purchase);
        }
        if (this.foresterUsed > 0) {
            json.put((Object)"foresterUsed", (Object)this.foresterUsed);
        }
        return json.toString();
    }

    public ArrayList<String> getPaymentString() {
        ArrayList<String> ll = new ArrayList<String>();
        for (PaymentEntry entry : this.payment) {
            ll.add(entry.toString());
        }
        return ll;
    }

    public ArrayList<String> getDisabledFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.disabledFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public ArrayList<String> getInsertedFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.insertedFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public ArrayList<String> getClearedFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.clearedFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public ArrayList<String> getRentersString() {
        ArrayList<String> ll = new ArrayList<String>();
        for (RentEntry entry : this.renterEntries) {
            ll.add(entry.serialize());
        }
        return ll;
    }

    public List<FieldFlag> getInsertedFlags() {
        return this.insertedFlags;
    }

    public List<FieldFlag> getClearedFlags() {
        return this.clearedFlags;
    }

    public void setFlags(String flagString) {
        JSONObject flags;
        if (flagString != null && !flagString.isEmpty() && (flags = (JSONObject)JSONValue.parse((String)flagString)) != null) {
            for (Object flag : flags.keySet()) {
                try {
                    JSONArray localFlags;
                    if (flag.equals("disabledFlags")) {
                        JSONArray disabledFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : disabledFlags) {
                            if ((flagStr.toString().equalsIgnoreCase("dynmap-area") || flagStr.toString().equalsIgnoreCase("dynmap-marker")) && this.hasFlag(FieldFlag.DYNMAP_NO_TOGGLE)) continue;
                            this.disableFlag(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("insertedFlags")) {
                        localFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : localFlags) {
                            this.insertFieldFlag(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("clearedFlags")) {
                        localFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : localFlags) {
                            this.clearFieldFlag(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("renters")) {
                        JSONArray renterList = (JSONArray)flags.get(flag);
                        this.renterEntries.clear();
                        this.renters.clear();
                        for (Object flagStr : renterList) {
                            RentEntry entry = new RentEntry(flagStr.toString());
                            this.renters.add(entry.getPlayerName().toLowerCase());
                            this.renterEntries.add(entry);
                        }
                        continue;
                    }
                    if (flag.equals("blacklistedCommands")) {
                        JSONArray blacklistedCommandsList = (JSONArray)flags.get(flag);
                        for (Object flagStr : blacklistedCommandsList) {
                            this.blacklistedCommands.add(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("whitelistedBlocks")) {
                        JSONArray whitelistedBlocksList = (JSONArray)flags.get(flag);
                        for (Object flagStr : whitelistedBlocksList) {
                            this.whitelistedBlocks.add(new BlockTypeEntry(flagStr.toString()));
                        }
                        continue;
                    }
                    if (flag.equals("foresterUsed")) {
                        this.foresterUsed = ((Long)flags.get(flag)).intValue();
                        continue;
                    }
                    if (flag.equals("revertSecs")) {
                        this.revertSecs = ((Long)flags.get(flag)).intValue();
                        continue;
                    }
                    if (flag.equals("limitSeconds")) {
                        this.limitSeconds = ((Long)flags.get(flag)).intValue();
                        continue;
                    }
                    if (flag.equals("disabled")) {
                        this.setDisabledNoMask((Boolean)flags.get(flag));
                        continue;
                    }
                    if (flag.equals("hidden")) {
                        this.hidden = (Boolean)flags.get(flag);
                        continue;
                    }
                    if (flag.equals("purchase")) {
                        this.purchase = new PaymentEntry(flags.get(flag).toString());
                        continue;
                    }
                    if (!flag.equals("payments")) continue;
                    JSONArray paymentList = (JSONArray)flags.get(flag);
                    paymentList.clear();
                    for (Object flagStr : paymentList) {
                        this.payment.add(new PaymentEntry(flagStr.toString()));
                    }
                }
                catch (Exception ex) {
                    System.out.print("Failed reading field flag: " + flag);
                    System.out.print("Value: " + flags.get(flag));
                    for (StackTraceElement el : ex.getStackTrace()) {
                        System.out.print(el.toString());
                    }
                }
            }
        }
    }

    public void enableFlag(String flagStr) {
        boolean canEnable = false;
        Iterator<FieldFlag> iter = this.disabledFlags.iterator();
        while (iter.hasNext()) {
            FieldFlag flag = iter.next();
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            iter.remove();
            canEnable = true;
        }
        if (canEnable && !this.flags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.flags.add(Helper.toFieldFlag(flagStr));
            this.dirty.add(DirtyFieldReason.FLAGS);
        }
    }

    public void disableFlag(String flagStr) {
        boolean hasFlag = false;
        Iterator<FieldFlag> iter = this.flags.iterator();
        while (iter.hasNext()) {
            FieldFlag flag = iter.next();
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            iter.remove();
            hasFlag = true;
        }
        if (hasFlag && !this.disabledFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.disabledFlags.add(Helper.toFieldFlag(flagStr));
            this.dirty.add(DirtyFieldReason.FLAGS);
        }
    }

    public boolean hasDisabledFlag(String flagStr) {
        for (FieldFlag flag : this.disabledFlags) {
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDisabledFlag(FieldFlag flag) {
        return this.disabledFlags.contains((Object)flag);
    }

    public List<FieldFlag> getDisabledFlags() {
        return Collections.unmodifiableList(this.disabledFlags);
    }

    public boolean toggleFieldFlag(String flagStr) {
        boolean hasFlag = this.hasFlag(flagStr);
        if (hasFlag) {
            this.disableFlag(flagStr);
            return false;
        }
        this.enableFlag(flagStr);
        return true;
    }

    public void RevertFlags() {
        this.insertedFlags.clear();
        this.disabledFlags.clear();
        this.flags.clear();
        for (FieldFlag flag : this.settings.getDefaultFlags()) {
            this.flags.add(flag);
        }
        this.dirty.add(DirtyFieldReason.FLAGS);
    }

    public List<FieldFlag> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    public boolean clearFieldFlag(String flagStr) {
        boolean cleared = false;
        if (this.insertedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.insertedFlags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        if (this.disabledFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.disabledFlags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        if (this.flags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.flags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        this.clearedFlags.add(Helper.toFieldFlag(flagStr));
        return cleared;
    }

    public boolean insertFieldFlag(String flagStr) {
        if (!this.insertedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.insertedFlags.add(Helper.toFieldFlag(flagStr));
            if (this.clearedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
                this.clearedFlags.remove((Object)Helper.toFieldFlag(flagStr));
            }
            return true;
        }
        return false;
    }

    public boolean insertFlag(String flagStr) {
        if (!this.flags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.flags.add(Helper.toFieldFlag(flagStr));
            this.dirty.add(DirtyFieldReason.FLAGS);
            PreciousStones.getInstance().getStorageManager().offerField(this);
            return true;
        }
        return false;
    }

    public void importFlags(List<FieldFlag> flags) {
        for (FieldFlag flag : flags) {
            this.insertFieldFlag(Helper.toFlagStr(flag));
        }
    }

    public int getRevertSecs() {
        return this.revertSecs;
    }

    public void setRevertSecs(int revertSecs) {
        this.revertSecs = revertSecs;
        this.dirty.add(DirtyFieldReason.FLAGS);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.setDisabled(disabled, null, false);
    }

    public void setDisabled(boolean disabled, boolean skipMask) {
        this.setDisabled(disabled, null, true);
    }

    public void setDisabledNoMask(boolean disabled) {
        this.setDisabled(disabled, null, true);
    }

    public boolean setDisabled(boolean disabled, Player player) {
        return this.setDisabled(disabled, player, false);
    }

    public boolean setDisabled(boolean disabled, Player player, boolean skipMask) {
        PreciousStones plugin = PreciousStones.getInstance();
        if (disabled != this.disabled) {
            this.disabled = disabled;
            if (disabled) {
                if (!skipMask) {
                    if (this.hasFlag(FieldFlag.MASK_ON_DISABLED)) {
                        this.mask();
                    }
                    if (this.hasFlag(FieldFlag.MASK_ON_ENABLED)) {
                        this.unmask();
                    }
                }
                if (this.hasFlag(FieldFlag.BREAKABLE_ON_DISABLED) && !this.flags.contains((Object)FieldFlag.BREAKABLE) && !this.insertedFlags.contains((Object)FieldFlag.BREAKABLE)) {
                    this.insertedFlags.add(FieldFlag.BREAKABLE);
                }
                plugin.getEntryManager().removeAllPlayers(this);
            } else {
                if (this.settings.getPayToEnable() > 0) {
                    if (player == null) {
                        this.disabled = true;
                        return false;
                    }
                    if (!plugin.getForceFieldManager().purchase(player, this.settings.getPayToEnable())) {
                        this.disabled = true;
                        return false;
                    }
                }
                if (!skipMask) {
                    if (this.hasFlag(FieldFlag.MASK_ON_DISABLED)) {
                        this.unmask();
                    }
                    if (this.hasFlag(FieldFlag.MASK_ON_ENABLED)) {
                        this.mask();
                    }
                }
                this.startDisabler();
                if (this.hasFlag(FieldFlag.BREAKABLE_ON_DISABLED) && !this.flags.contains((Object)FieldFlag.BREAKABLE) && this.insertedFlags.contains((Object)FieldFlag.BREAKABLE)) {
                    this.insertedFlags.remove((Object)FieldFlag.BREAKABLE);
                }
                if (this.hasFlag(FieldFlag.FORESTER) && this.hasForesterUse() && !this.isForesting() && player != null) {
                    ForesterEntry fe = new ForesterEntry(this, player);
                }
                if (this.hasFlag(FieldFlag.TELEPORT_PLAYERS_ON_ENABLE) || this.hasFlag(FieldFlag.TELEPORT_MOBS_ON_ENABLE) || this.hasFlag(FieldFlag.TELEPORT_VILLAGERS_ON_ENABLE) || this.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE) || this.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE)) {
                    List entities = Bukkit.getServer().getWorld(this.getWorld()).getEntities();
                    for (Entity entity : entities) {
                        if (!this.envelops(entity.getLocation())) continue;
                        if (this.hasFlag(FieldFlag.TELEPORT_MOBS_ON_ENABLE) && (entity instanceof Monster || entity instanceof Golem || entity instanceof WaterMob)) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (this.hasFlag(FieldFlag.TELEPORT_VILLAGERS_ON_ENABLE) && entity instanceof Villager) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (this.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE) && entity instanceof Ageable) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (!this.hasFlag(FieldFlag.TELEPORT_PLAYERS_ON_ENABLE) || !(entity instanceof Player)) continue;
                        plugin.getTeleportationManager().teleport(entity, this);
                    }
                }
            }
        }
        return true;
    }

    public boolean startDisabler() {
        if (this.settings != null && this.settings.getAutoDisableTime() > 0) {
            Player player = Bukkit.getServer().getPlayerExact(this.owner);
            final String theOwner = this.owner;
            final Field thisField = this;
            if (player != null) {
                ChatBlock.send((CommandSender)player, "fieldWillDisable", this.settings.getTitle(), this.settings.getAutoDisableTime());
            }
            if (this.disablerId > 0) {
                Bukkit.getServer().getScheduler().cancelTask(this.disablerId);
            }
            this.disablerId = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PreciousStones.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (!thisField.isDisabled()) {
                        Player player = Bukkit.getServer().getPlayerExact(theOwner);
                        if (player != null) {
                            ChatBlock.send((CommandSender)player, "fieldHasDisabled", Field.this.settings.getTitle());
                        }
                        thisField.setDisabled(true);
                        thisField.dirtyFlags();
                    }
                }
            }, 20L * (long)this.settings.getAutoDisableTime());
            return true;
        }
        return false;
    }

    public void generateFence(int item) {
        Block block;
        int y;
        boolean hasFloor;
        int sideTwoMidId;
        int sideOne;
        int y2;
        boolean hasFloor2;
        int sideOneMidId;
        PreciousStones plugin = PreciousStones.getInstance();
        World world = Bukkit.getServer().getWorld(this.getWorld());
        if (world == null) {
            return;
        }
        int minx = this.getX() - this.getRadius() - 1;
        int maxx = this.getX() + this.getRadius() + 1;
        int minz = this.getZ() - this.getRadius() - 1;
        int maxz = this.getZ() + this.getRadius() + 1;
        int miny = this.getY() - Math.max(this.getHeight() - 1, 0) / 2 - 1;
        int maxy = this.getY() + Math.max(this.getHeight() - 1, 0) / 2 + 1;
        int mid = this.getY();
        if (this.hasFlag(FieldFlag.CUBOID)) {
            minx = this.getMinx() - 1;
            maxx = this.getMaxx() + 1;
            minz = this.getMinz() - 1;
            maxz = this.getMaxz() + 1;
            miny = this.getMiny() - 1;
            maxy = this.getMaxy() + 1;
        }
        int limity = Math.min(plugin.getSettingsManager().getFenceMaxDepth(), miny);
        for (int z = minz; z <= maxz; ++z) {
            sideOneMidId = world.getBlockTypeIdAt(minx, mid, z);
            if (plugin.getSettingsManager().isNaturalThroughType(sideOneMidId)) {
                hasFloor2 = false;
                for (y2 = mid; y2 >= limity; --y2) {
                    sideOne = world.getBlockTypeIdAt(minx, y2, z);
                    if (plugin.getSettingsManager().isNaturalThroughType(sideOne)) continue;
                    hasFloor2 = true;
                    break;
                }
                if (hasFloor2) {
                    for (y2 = mid; y2 >= limity; --y2) {
                        sideOne = world.getBlockTypeIdAt(minx, y2, z);
                        if (!plugin.getSettingsManager().isNaturalThroughType(sideOne)) continue;
                        Block block2 = world.getBlockAt(minx, y2, z);
                        this.fenceBlocks.add(new BlockEntry(block2));
                        block2.setTypeId(item);
                    }
                }
            }
            sideTwoMidId = world.getBlockTypeIdAt(maxx, mid, z);
            if (!plugin.getSettingsManager().isNaturalThroughType(sideTwoMidId)) continue;
            hasFloor = false;
            for (y = mid; y >= limity; --y) {
                int sideTwo = world.getBlockTypeIdAt(maxx, y, z);
                if (plugin.getSettingsManager().isNaturalThroughType(sideTwo)) continue;
                hasFloor = true;
                break;
            }
            if (!hasFloor) continue;
            for (y = mid; y >= limity; --y) {
                int sideTwo = world.getBlockTypeIdAt(maxx, y, z);
                if (!plugin.getSettingsManager().isNaturalThroughType(sideTwo)) continue;
                block = world.getBlockAt(maxx, y, z);
                this.fenceBlocks.add(new BlockEntry(block));
                block.setTypeId(item);
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            sideOneMidId = world.getBlockTypeIdAt(x, mid, minz);
            if (plugin.getSettingsManager().isNaturalThroughType(sideOneMidId)) {
                hasFloor2 = false;
                for (y2 = mid; y2 >= limity; --y2) {
                    sideOne = world.getBlockTypeIdAt(x, y2, minz);
                    if (plugin.getSettingsManager().isNaturalThroughType(sideOne)) continue;
                    hasFloor2 = true;
                    break;
                }
                if (hasFloor2) {
                    for (y2 = mid; y2 >= limity; --y2) {
                        sideOne = world.getBlockTypeIdAt(x, y2, minz);
                        if (!plugin.getSettingsManager().isNaturalThroughType(sideOne)) continue;
                        Block block3 = world.getBlockAt(x, y2, minz);
                        this.fenceBlocks.add(new BlockEntry(block3));
                        block3.setTypeId(item);
                    }
                }
            }
            sideTwoMidId = world.getBlockTypeIdAt(x, mid, maxz);
            if (!plugin.getSettingsManager().isNaturalThroughType(sideTwoMidId)) continue;
            hasFloor = false;
            for (y = mid; y >= limity; --y) {
                int sideTwo = world.getBlockTypeIdAt(x, y, maxz);
                if (plugin.getSettingsManager().isNaturalThroughType(sideTwo)) continue;
                hasFloor = true;
                break;
            }
            if (!hasFloor) continue;
            for (y = mid; y >= limity; --y) {
                int sideTwo = world.getBlockTypeIdAt(x, y, maxz);
                if (!plugin.getSettingsManager().isNaturalThroughType(sideTwo)) continue;
                block = world.getBlockAt(x, y, maxz);
                this.fenceBlocks.add(new BlockEntry(block));
                block.setTypeId(item);
            }
        }
    }

    public void clearFence() {
    }

    public void changeOwner() {
        this.setOwner(this.newOwner);
        this.setNewOwner(null);
    }

    public String getNewOwner() {
        return this.newOwner;
    }

    public void setNewOwner(String newOwner) {
        this.newOwner = newOwner;
    }

    public void dirtyFlags() {
        this.dirty.add(DirtyFieldReason.FLAGS);
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public boolean containsPlayer(String playerName) {
        Player player = Bukkit.getServer().getPlayerExact(playerName);
        return player != null && this.envelops(player.getLocation());
    }

    public boolean isTranslocating() {
        return this.translocating;
    }

    public void setTranslocating(boolean translocating) {
        this.translocating = translocating;
    }

    public void mask() {
        this.mask(null);
    }

    public void unmask() {
        this.unmask(null);
    }

    public void mask(Player actor) {
        Entity[] entities;
        Set<Object> fieldInhabitants = new HashSet<Player>();
        if (actor != null) {
            fieldInhabitants.add(actor);
        } else {
            fieldInhabitants = PreciousStones.getInstance().getForceFieldManager().getFieldInhabitants(this);
        }
        for (Entity entity : entities = this.getBlock().getChunk().getEntities()) {
            if (!(entity instanceof Player)) continue;
            fieldInhabitants.add((Player)entity);
        }
        for (Player player : fieldInhabitants) {
            if (this.hasFlag(FieldFlag.MASK_ON_ENABLED)) {
                player.sendBlockChange(this.getLocation(), this.settings.getMaskOnEnabledBlock(), (byte)0);
                continue;
            }
            player.sendBlockChange(this.getLocation(), this.settings.getMaskOnDisabledBlock(), (byte)0);
        }
    }

    public void unmask(Player actor) {
        Entity[] entities;
        Set<Object> fieldInhabitants = new HashSet<Player>();
        if (actor != null) {
            fieldInhabitants.add(actor);
        } else {
            fieldInhabitants = PreciousStones.getInstance().getForceFieldManager().getFieldInhabitants(this);
        }
        for (Entity entity : entities = this.getBlock().getChunk().getEntities()) {
            if (!(entity instanceof Player)) continue;
            fieldInhabitants.add((Player)entity);
        }
        for (Player player : fieldInhabitants) {
            player.sendBlockChange(this.getLocation(), this.getTypeId(), this.getData());
        }
    }

    public boolean matchesBlockType() {
        Block block = this.getBlock();
        return block.getTypeId() == this.getTypeId();
    }

    public boolean missingBlock() {
        Block block = this.getBlock();
        return block.getTypeId() == 0;
    }

    public void hide() {
        if (!this.isHidden()) {
            this.hidden = true;
            this.dirtyFlags();
            BlockTypeEntry maskType = this.findMaskType();
            Block block = this.getBlock();
            block.setTypeId(maskType.getTypeId());
            block.setData(maskType.getData());
            PreciousStones.getInstance().getStorageManager().offerField(this);
        }
        if (this.isParent()) {
            for (Field child : this.children) {
                if (child.isHidden()) continue;
                child.hide();
            }
        }
        if (this.isChild() && !this.getParent().isHidden()) {
            this.getParent().hide();
        }
    }

    public void unHide() {
        if (this.isHidden()) {
            this.hidden = false;
            this.dirtyFlags();
            Block block = this.getBlock();
            block.setTypeId(this.getTypeId());
            block.setData(this.getData());
            PreciousStones.getInstance().getStorageManager().offerField(this);
        }
        if (this.isParent()) {
            for (Field child : this.children) {
                if (!child.isHidden()) continue;
                child.unHide();
            }
        }
        if (this.isChild() && this.getParent().isHidden()) {
            this.getParent().unHide();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private BlockTypeEntry findMaskType() {
        ArrayList<Vec> vecs = new ArrayList<Vec>();
        Vec center = new Vec(this.getBlock());
        vecs.add(center.add(1, 0, 0));
        vecs.add(center.add(-1, 0, 0));
        vecs.add(center.add(0, 0, 1));
        vecs.add(center.add(0, 0, -1));
        vecs.add(center.add(-1, -1, 0));
        vecs.add(center.add(0, -1, 1));
        vecs.add(center.add(0, 1, 0));
        for (Vec vec : vecs) {
            Block relative = vec.getBlock();
            if (relative.getTypeId() == 0) continue;
            BlockTypeEntry entry = new BlockTypeEntry(relative);
            if (!PreciousStones.getInstance().getSettingsManager().isHidingMaskType(entry)) continue;
            return entry;
        }
        return PreciousStones.getInstance().getSettingsManager().getFirstHidingMask();
    }

    public boolean hasOnlineAllowed() {
        World world = Bukkit.getWorld((String)this.getWorld());
        if (world != null) {
            List<String> allAllowed = this.getAllAllowed();
            for (String allowed : allAllowed) {
                Player player = Bukkit.getServer().getPlayerExact(allowed);
                if (player == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNamed() {
        return this.getName().length() > 0;
    }

    public void setTranslocationSize(int translocationSize) {
        this.translocationSize = translocationSize;
    }

    public boolean isOverRedstoneMax() {
        return this.translocationSize > PreciousStones.getInstance().getSettingsManager().getMaxSizeTranslocationForRedstone();
    }

    public boolean isOverTranslocationMax() {
        return this.isOverTranslocationMax(0);
    }

    public boolean isOverTranslocationMax(int extra) {
        return this.translocationSize + extra > PreciousStones.getInstance().getSettingsManager().getMaxSizeTranslocation();
    }

    public int getTranslocationSize() {
        return this.translocationSize;
    }

    public String getDetails() {
        return "[" + this.getType() + "|" + this.getX() + " " + this.getY() + " " + this.getZ() + "]";
    }

    public int getFencePrice() {
        return this.fenceBlocks.size() * this.settings.getFenceItemPrice();
    }

    public void addBlacklistedCommand(String command) {
        if (!this.blacklistedCommands.contains(command)) {
            this.blacklistedCommands.add(command);
        }
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public void clearBlacklistedCommands() {
        this.blacklistedCommands.clear();
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public boolean isBlacklistedCommand(String command) {
        if (this.hasFlag(FieldFlag.COMMAND_BLACKLISTING)) {
            int i = (command = command.replace("/", "")).indexOf(32);
            if (i > -1) {
                command = command.substring(0, i);
            }
            PreciousStones.debug(command, new Object[0]);
            return this.blacklistedCommands.contains(command);
        }
        return false;
    }

    public boolean hasBlacklistedComands() {
        return this.blacklistedCommands.size() > 0;
    }

    public String getBlacklistedCommandsList() {
        String out = "";
        for (String cmd : this.blacklistedCommands) {
            out = out + cmd + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public void addWhitelistedBlock(BlockTypeEntry type) {
        if (!this.whitelistedBlocks.contains(type)) {
            this.whitelistedBlocks.add(type);
        }
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public void deleteWhitelistedBlock(BlockTypeEntry type) {
        this.whitelistedBlocks.remove(type);
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public boolean hasForesterUse() {
        return this.settings.getForesterUses() - this.foresterUsed > 0;
    }

    public int foresterUsesLeft() {
        return this.settings.getForesterUses() - this.foresterUsed;
    }

    public void recordForesterUse() {
        ++this.foresterUsed;
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public int getForesterUsed() {
        return this.foresterUsed;
    }

    public boolean isForesting() {
        return this.foresting;
    }

    public void setForesting(boolean foresting) {
        this.foresting = foresting;
    }

    public boolean take(Player player) {
        Block block = this.getBlock();
        if (block.getTypeId() != this.type.getTypeId()) {
            return false;
        }
        PreciousStones.getInstance().getForceFieldManager().deleteField(this);
        block.setType(Material.AIR);
        StackHelper.give(player, this.type, 1);
        return true;
    }

    public RentEntry getRenter(Player player) {
        for (RentEntry entry : this.renterEntries) {
            if (!entry.getPlayerName().equals(player.getName())) continue;
            return entry;
        }
        return null;
    }

    public void addRent(Player player) {
        FieldSign s = this.getAttachedFieldSign();
        if (s != null) {
            int seconds = SignHelper.periodToSeconds(s.getPeriod());
            if (seconds == 0) {
                ChatBlock.send((CommandSender)player, "fieldSignRentError", new Object[0]);
                return;
            }
            RentEntry renter = this.getRenter(player);
            if (renter != null) {
                renter.addSeconds(seconds);
                ChatBlock.send((CommandSender)player, "fieldSignRentRented", SignHelper.secondsToPeriods(renter.getPeriodSeconds()));
            } else {
                this.renterEntries.add(new RentEntry(player.getName(), seconds));
                this.renters.add(player.getName().toLowerCase());
                if (this.renterEntries.size() == 1) {
                    this.scheduleNextRentUpdate();
                }
                ChatBlock.send((CommandSender)player, "fieldSignRentRented", s.getPeriod());
                PreciousStones.getInstance().getEntryManager().leaveField(player, this);
                PreciousStones.getInstance().getEntryManager().enterField(player, this);
            }
            this.dirtyFlags();
            PreciousStones.getInstance().getStorageManager().offerField(this);
        }
    }

    public void removeRenter(RentEntry entry) {
        this.renterEntries.remove(entry);
        this.renters.remove(entry.getPlayerName().toLowerCase());
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public boolean clearRents() {
        if (this.isRented()) {
            this.renterEntries.clear();
            this.renters.clear();
            this.purchase = null;
            this.cleanFieldSign();
            this.dirtyFlags();
            PreciousStones.getInstance().getStorageManager().offerField(this);
            return true;
        }
        return false;
    }

    public boolean removeRents() {
        FieldSign s = this.getAttachedFieldSign();
        if (s != null) {
            s.eject();
            this.renterEntries.clear();
            this.renters.clear();
            if (this.purchase != null) {
                this.removeAllowed(this.purchase.getPlayer());
                this.purchase = null;
            }
            this.payment.clear();
            this.dirtyFlags();
            PreciousStones.getInstance().getStorageManager().offerField(this);
            return true;
        }
        return false;
    }

    public List<RentEntry> getRenterEntries() {
        return Collections.unmodifiableList(this.renterEntries);
    }

    public void abandonRent(Player player) {
        for (RentEntry entry : this.renterEntries) {
            if (!entry.getPlayerName().equals(player.getName())) continue;
            this.removeRenter(entry);
            this.cleanFieldSign();
            return;
        }
    }

    public FieldSign getAttachedFieldSign() {
        return SignHelper.getAttachedFieldSign(this.getBlock());
    }

    public void cleanFieldSign() {
        FieldSign s;
        if (!this.isRented() && (s = this.getAttachedFieldSign()) != null) {
            s.setAvailableColor();
            s.cleanRemainingTime();
        }
    }

    public void addPurchase(String playerName, String fieldName, BlockTypeEntry item, int amount) {
        this.purchase = new PaymentEntry(playerName, fieldName, item, amount);
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public void addPayment(String playerName, String fieldName, BlockTypeEntry item, int amount) {
        boolean added = false;
        for (PaymentEntry entry : this.payment) {
            if (!entry.getPlayer().equals(playerName) || item != null && !entry.getItem().equals(item)) continue;
            entry.setAmount(entry.getAmount() + amount);
            added = true;
        }
        if (!added) {
            this.payment.add(new PaymentEntry(playerName, fieldName, item, amount));
        }
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public boolean rent(Player player, FieldSign s) {
        Field field = s.getField();
        if (field.getLimitSeconds() > 0) {
            PreciousStones.debug("field has rent limits in place: " + field.getLimitSeconds(), new Object[0]);
            RentEntry renter = this.getRenter(player);
            if (renter != null) {
                int seconds = SignHelper.periodToSeconds(s.getPeriod());
                if (renter.getPeriodSeconds() + seconds > field.getLimitSeconds()) {
                    PreciousStones.debug("limit reached", new Object[0]);
                    ChatBlock.send((CommandSender)player, "limitReached", new Object[0]);
                    return false;
                }
            }
        }
        if (s.getItem() != null) {
            PreciousStones.debug("is item rent", new Object[0]);
            if (StackHelper.hasItems(player, s.getItem(), s.getPrice())) {
                StackHelper.remove(player, s.getItem(), s.getPrice());
                this.addPayment(player.getName(), s.getField().getName(), s.getItem(), s.getPrice());
                this.addRent(player);
                PreciousStones.getInstance().getCommunicationManager().logPayment(this.getOwner(), player.getName(), s);
                return true;
            }
            ChatBlock.send((CommandSender)player, "economyNotEnoughItems", new Object[0]);
        } else if (PreciousStones.getInstance().getPermissionsManager().hasEconomy()) {
            if (PermissionsManager.hasMoney(player, (double)s.getPrice())) {
                PreciousStones.getInstance().getPermissionsManager().playerCharge(player, (double)s.getPrice());
                this.addPayment(player.getName(), s.getField().getName(), null, s.getPrice());
                this.addRent(player);
                PreciousStones.getInstance().getCommunicationManager().logPayment(this.getOwner(), player.getName(), s);
                return true;
            }
            ChatBlock.send((CommandSender)player, "economyNotEnoughMoney", new Object[0]);
        }
        return false;
    }

    public boolean hasPendingPayments() {
        return !this.payment.isEmpty();
    }

    public boolean buy(Player player, FieldSign s) {
        if (s.getItem() == null) {
            if (PreciousStones.getInstance().getPermissionsManager().hasEconomy()) {
                if (PermissionsManager.hasMoney(player, (double)s.getPrice())) {
                    PreciousStones.getInstance().getPermissionsManager().playerCharge(player, (double)s.getPrice());
                    this.addPurchase(player.getName(), s.getField().getName(), null, s.getPrice());
                    PreciousStones.getInstance().getCommunicationManager().logPurchase(this.getOwner(), player.getName(), s);
                    return true;
                }
                ChatBlock.send((CommandSender)player, "economyNotEnoughMoney", new Object[0]);
            }
        } else {
            if (StackHelper.hasItems(player, s.getItem(), s.getPrice())) {
                StackHelper.remove(player, s.getItem(), s.getPrice());
                this.addPurchase(player.getName(), s.getField().getName(), s.getItem(), s.getPrice());
                PreciousStones.getInstance().getCommunicationManager().logPurchase(this.getOwner(), player.getName(), s);
                return true;
            }
            ChatBlock.send((CommandSender)player, "economyNotEnoughItems", new Object[0]);
        }
        return false;
    }

    public boolean hasPendingPurchase() {
        return this.purchase != null;
    }

    public boolean isBuyer(Player player) {
        return this.purchase != null && this.purchase.getPlayer().equals(player.getName());
    }

    public void takePayment(Player player) {
        for (PaymentEntry entry : this.payment) {
            if (entry.isItemPayment()) {
                StackHelper.give(player, entry.getItem(), entry.getAmount());
                if (entry.getFieldName().isEmpty()) {
                    ChatBlock.send((CommandSender)player, "fieldSignItemPaymentReceivedNoName", entry.getAmount(), entry.getItem().getFriendly(), entry.getPlayer());
                    continue;
                }
                ChatBlock.send((CommandSender)player, "fieldSignItemPaymentReceived", entry.getAmount(), entry.getItem().getFriendly(), entry.getPlayer(), entry.getFieldName());
                continue;
            }
            PreciousStones.getInstance().getPermissionsManager().playerCredit(player, entry.getAmount());
            if (entry.getFieldName().isEmpty()) {
                ChatBlock.send((CommandSender)player, "fieldSignPaymentReceivedNoName", entry.getAmount(), entry.getPlayer());
                continue;
            }
            ChatBlock.send((CommandSender)player, "fieldSignPaymentReceived", entry.getAmount(), entry.getPlayer(), entry.getFieldName());
        }
        PreciousStones.getInstance().getCommunicationManager().logPaymentCollect(this.getOwner(), player.getName(), this.getAttachedFieldSign());
        this.payment.clear();
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public void completePurchase(Player player) {
        this.setOwner(this.purchase.getPlayer());
        this.allowed.clear();
        if (this.purchase.isItemPayment()) {
            StackHelper.give(player, this.purchase.getItem(), this.purchase.getAmount());
            if (this.purchase.getFieldName().isEmpty()) {
                ChatBlock.send((CommandSender)player, "fieldSignItemPaymentReceivedNoName", this.purchase.getAmount(), this.purchase.getItem().getFriendly(), this.purchase.getPlayer());
            } else {
                ChatBlock.send((CommandSender)player, "fieldSignItemPaymentReceived", this.purchase.getAmount(), this.purchase.getItem().getFriendly(), this.purchase.getPlayer(), this.purchase.getFieldName());
            }
        } else {
            PreciousStones.getInstance().getPermissionsManager().playerCredit(player, this.purchase.getAmount());
            if (this.purchase.getFieldName().isEmpty()) {
                ChatBlock.send((CommandSender)player, "fieldSignPaymentReceivedNoName", this.purchase.getAmount(), this.purchase.getPlayer());
            } else {
                ChatBlock.send((CommandSender)player, "fieldSignPaymentReceived", this.purchase.getAmount(), this.purchase.getPlayer(), this.purchase.getFieldName());
            }
        }
        PreciousStones.getInstance().getCommunicationManager().logPurchaseCollect(this.getOwner(), player.getName(), this.getAttachedFieldSign());
        this.purchase = null;
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public int getLimitSeconds() {
        return this.limitSeconds;
    }

    public void setLimitSeconds(int limitSeconds) {
        this.limitSeconds = limitSeconds;
        this.dirtyFlags();
        PreciousStones.getInstance().getStorageManager().offerField(this);
    }

    public void scheduleNextRentUpdate() {
        if (!this.renterEntries.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PreciousStones.getInstance(), (Runnable)new Update(), 20L);
        }
    }

    private class Update
    implements Runnable {
        private Update() {
        }

        @Override
        public void run() {
            FieldSign s;
            if (Field.this.isRented() && (s = Field.this.getAttachedFieldSign()) != null && (s.isRentable() || s.isShareable())) {
                boolean foundSomeone = false;
                if (PreciousStones.getInstance().getEntryManager().hasInhabitants(Field.this.self)) {
                    Player closest = Helper.getClosestPlayer(Field.this.getLocation(), 64);
                    for (RentEntry entry : Field.this.renterEntries) {
                        if (!entry.getPlayerName().equalsIgnoreCase(closest.getName())) continue;
                        s.updateRemainingTime(entry.remainingRent());
                        foundSomeone = true;
                        Field.this.signIsClean = false;
                    }
                }
                if (!foundSomeone && !Field.this.signIsClean) {
                    s.cleanRemainingTime();
                    Field.this.signIsClean = true;
                }
            }
            Iterator iter = Field.this.renterEntries.iterator();
            while (iter.hasNext()) {
                RentEntry entry = (RentEntry)iter.next();
                if (!entry.isDone()) continue;
                Field.this.renters.remove(entry.getPlayerName().toLowerCase());
                iter.remove();
                Field.this.dirtyFlags();
                PreciousStones.getInstance().getStorageManager().offerField(Field.this.self);
                if (Field.this.getName().isEmpty()) {
                    ChatBlock.send(entry.getPlayerName(), "fieldSignRentExpiredNoName", new Object[0]);
                    continue;
                }
                ChatBlock.send(entry.getPlayerName(), "fieldSignRentExpired", Field.this.getName());
            }
            Field.this.scheduleNextRentUpdate();
        }
    }
}

