/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.listeners.SCEntityListener;
import net.sacredlabyrinth.phaed.simpleclans.listeners.SCPlayerListener;
import net.sacredlabyrinth.phaed.simpleclans.managers.ClanManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.CommandManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.PermissionsManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.RequestManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.SettingsManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.SpoutPluginManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.StorageManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.TeleportManager;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleClans
extends JavaPlugin {
    private ArrayList<String> messages = new ArrayList();
    private static SimpleClans instance;
    private static final Logger logger;
    private ClanManager clanManager;
    private RequestManager requestManager;
    private StorageManager storageManager;
    private SpoutPluginManager spoutPluginManager;
    private SettingsManager settingsManager;
    private PermissionsManager permissionsManager;
    private CommandManager commandManager;
    private TeleportManager teleportManager;
    private ResourceBundle lang;
    private boolean hasUUID;

    public static Logger getLog() {
        return logger;
    }

    public static void debug(String msg) {
        if (SimpleClans.getInstance().getSettingsManager().isDebugging()) {
            logger.log(Level.INFO, msg);
        }
    }

    public static SimpleClans getInstance() {
        return instance;
    }

    public static void log(String msg, Object ... arg) {
        if (arg == null || arg.length == 0) {
            logger.log(Level.INFO, msg);
        } else {
            logger.log(Level.INFO, MessageFormat.format(msg, arg));
        }
    }

    public void onEnable() {
        instance = this;
        this.hasUUID = UUIDMigration.canReturnUUID();
        this.settingsManager = new SettingsManager();
        this.lang = PropertyResourceBundle.getBundle("languages.lang");
        logger.info(MessageFormat.format(this.lang.getString("version.loaded"), this.getDescription().getName(), this.getDescription().getVersion()));
        this.spoutPluginManager = new SpoutPluginManager();
        this.permissionsManager = new PermissionsManager();
        this.requestManager = new RequestManager();
        this.clanManager = new ClanManager();
        this.storageManager = new StorageManager();
        this.commandManager = new CommandManager();
        this.teleportManager = new TeleportManager();
        this.getServer().getPluginManager().registerEvents((Listener)new SCEntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SCPlayerListener(), (Plugin)this);
        this.spoutPluginManager.processAllPlayers();
        this.permissionsManager.loadPermissions();
        this.pullMessages();
        logger.info("[SimpleClans] Modo Multithreading: " + SimpleClans.getInstance().getSettingsManager().getUseThreads());
        logger.info("[SimpleClans] Modo BungeeCord: " + SimpleClans.getInstance().getSettingsManager().getUseBungeeCord());
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getStorageManager().closeConnection();
        this.getPermissionsManager().savePermissions();
    }

    public void pullMessages() {
        if (this.getSettingsManager().isDisableMessages()) {
            return;
        }
        try {
            String message;
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL("https://minecraftcubed.net/pluginmessage/").openStream()));
            while ((message = in.readLine()) != null) {
                this.messages.add(message);
                this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + message);
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClanManager getClanManager() {
        return this.clanManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public SpoutPluginManager getSpoutPluginManager() {
        return this.spoutPluginManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public String getLang(String msg) {
        return this.lang.getString(msg);
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public boolean hasUUID() {
        return this.hasUUID;
    }

    public void setUUID(boolean trueOrFalse) {
        this.hasUUID = trueOrFalse;
    }

    static {
        logger = Logger.getLogger("Minecraft");
    }
}

