/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AllyCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.ally")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            return;
        }
        Clan clan = cp.getClan();
        if (!clan.isVerified()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
            return;
        }
        if (!clan.isLeader(player)) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
            return;
        }
        if (arg.length != 2) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.ally"), plugin.getSettingsManager().getCommandClan()));
            return;
        }
        if (clan.getSize() < plugin.getSettingsManager().getClanMinSizeToAlly()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("minimum.to.make.alliance"), plugin.getSettingsManager().getClanMinSizeToAlly()));
            return;
        }
        String action = arg[0];
        Clan ally = plugin.getClanManager().getClan(arg[1]);
        if (ally == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.clan.matched"));
            return;
        }
        if (!ally.isVerified()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("cannot.ally.with.an.unverified.clan"));
        }
        if (action.equals(plugin.getLang("add"))) {
            if (!clan.isAlly(ally.getTag())) {
                List<ClanPlayer> onlineLeaders = Helper.stripOffLinePlayers(clan.getLeaders());
                if (!onlineLeaders.isEmpty()) {
                    plugin.getRequestManager().addAllyRequest(cp, ally, clan);
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(plugin.getLang("leaders.have.been.asked.for.an.alliance"), Helper.capitalize(ally.getName())));
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("at.least.one.leader.accept.the.alliance"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("your.clans.are.already.allies"));
            }
        } else if (action.equals(plugin.getLang("remove"))) {
            if (clan.isAlly(ally.getTag())) {
                clan.removeAlly(ally);
                ally.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(plugin.getLang("has.broken.the.alliance"), Helper.capitalize(clan.getName()), ally.getName()));
                clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(plugin.getLang("has.broken.the.alliance"), Helper.capitalize(cp.getName()), Helper.capitalize(ally.getName())));
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("your.clans.are.not.allies"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.ally"), plugin.getSettingsManager().getCommandClan()));
        }
    }
}

