/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.listeners;

import java.util.Iterator;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class SCPlayerListener
implements Listener {
    private SimpleClans plugin = SimpleClans.getInstance();

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        ClanPlayer cp;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(player.getLocation().getWorld().getName())) {
            return;
        }
        if (event.getMessage().length() == 0) {
            return;
        }
        String[] split = event.getMessage().substring(1).split(" ");
        if (split.length == 0) {
            return;
        }
        String command = split[0];
        if (this.plugin.getSettingsManager().isTagBasedClanChat() && this.plugin.getClanManager().isClan(command)) {
            if (!this.plugin.getSettingsManager().getClanChatEnable()) {
                return;
            }
            cp = this.plugin.getClanManager().getClanPlayer(player);
            if (cp == null) {
                return;
            }
            if (cp.getTag().equalsIgnoreCase(command)) {
                event.setCancelled(true);
                if (split.length > 1) {
                    this.plugin.getClanManager().processClanChat(player, cp.getTag(), Helper.toMessage(Helper.removeFirst(split)));
                }
            }
        }
        if (command.equals(".")) {
            if (!this.plugin.getSettingsManager().getClanChatEnable()) {
                return;
            }
            cp = this.plugin.getClanManager().getClanPlayer(player);
            if (cp == null) {
                return;
            }
            event.setCancelled(true);
            if (split.length > 1) {
                this.plugin.getClanManager().processClanChat(player, cp.getTag(), Helper.toMessage(Helper.removeFirst(split)));
            }
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandAlly())) {
            if (!this.plugin.getSettingsManager().isAllyChatEnable()) {
                return;
            }
            event.setCancelled(true);
            if (split.length > 1) {
                this.plugin.getClanManager().processAllyChat(player, Helper.toMessage(Helper.removeFirst(split)));
            }
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandGlobal())) {
            event.setCancelled(true);
            if (split.length > 1) {
                this.plugin.getClanManager().processGlobalChat(player, Helper.toMessage(Helper.removeFirst(split)));
            }
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandClan())) {
            event.setCancelled(true);
            this.plugin.getCommandManager().processClan((CommandSender)player, Helper.removeFirst(split));
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandAccept())) {
            event.setCancelled(true);
            this.plugin.getCommandManager().processAccept(player);
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandDeny())) {
            event.setCancelled(true);
            this.plugin.getCommandManager().processDeny(player);
        } else if (command.equalsIgnoreCase(this.plugin.getSettingsManager().getCommandMore())) {
            event.setCancelled(true);
            this.plugin.getCommandManager().processMore(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld().getName())) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        String message = event.getMessage();
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(event.getPlayer());
        if (cp != null) {
            if (cp.getChannel().equals((Object)ClanPlayer.Channel.CLAN)) {
                this.plugin.getClanManager().processClanChat(event.getPlayer(), message);
                event.setCancelled(true);
            } else if (cp.getChannel().equals((Object)ClanPlayer.Channel.ALLY)) {
                this.plugin.getClanManager().processAllyChat(event.getPlayer(), message);
                event.setCancelled(true);
            }
        }
        if (!this.plugin.getPermissionsManager().has(event.getPlayer(), "simpleclans.mod.nohide")) {
            boolean isClanChat = event.getMessage().contains("" + ChatColor.RED + ChatColor.WHITE + ChatColor.RED + ChatColor.BLACK);
            boolean isAllyChat = event.getMessage().contains("" + ChatColor.AQUA + ChatColor.WHITE + ChatColor.AQUA + ChatColor.BLACK);
            Iterator iter = event.getRecipients().iterator();
            while (iter.hasNext()) {
                Player player = (Player)iter.next();
                ClanPlayer rcp = this.plugin.getClanManager().getClanPlayer(player);
                if (rcp == null) continue;
                if (!rcp.isClanChat() && isClanChat) {
                    iter.remove();
                    continue;
                }
                if (!rcp.isAllyChat() && isAllyChat) {
                    iter.remove();
                    continue;
                }
                if (rcp.isGlobalChat() || isAllyChat || isClanChat) continue;
                iter.remove();
            }
        }
        if (this.plugin.getSettingsManager().isCompatMode()) {
            if (cp != null && cp.isTagEnabled()) {
                String tagLabel = cp.getClan().getTagLabel();
                Player player = event.getPlayer();
                if (player.getDisplayName().contains("{clan}")) {
                    player.setDisplayName(player.getDisplayName().replace("{clan}", tagLabel));
                } else if (event.getFormat().contains("{clan}")) {
                    event.setFormat(event.getFormat().replace("{clan}", tagLabel));
                } else {
                    String format = event.getFormat();
                    event.setFormat(tagLabel + format);
                }
            } else {
                event.setFormat(event.getFormat().replace("{clan}", ""));
                event.setFormat(event.getFormat().replace("tagLabel", ""));
            }
        } else {
            this.plugin.getClanManager().updateDisplayName(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (SimpleClans.getInstance().getSettingsManager().isBlacklistedWorld(player.getLocation().getWorld().getName())) {
            return;
        }
        ClanPlayer cp = SimpleClans.getInstance().getSettingsManager().getUseBungeeCord() ? SimpleClans.getInstance().getClanManager().getClanPlayerJoinEvent(player) : SimpleClans.getInstance().getClanManager().getClanPlayer(player);
        if (cp == null) {
            return;
        }
        cp.setName(player.getName());
        SimpleClans.getInstance().getClanManager().updateLastSeen(player);
        SimpleClans.getInstance().getClanManager().updateDisplayName(player);
        if (SimpleClans.getInstance().hasUUID()) {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getUniqueId());
        } else {
            SimpleClans.getInstance().getSpoutPluginManager().processPlayer(cp.getName());
        }
        SimpleClans.getInstance().getPermissionsManager().addPlayerPermissions(cp);
        if (this.plugin.getSettingsManager().isBbShowOnLogin() && cp.isBbEnabled()) {
            cp.getClan().displayBb(player);
        }
        SimpleClans.getInstance().getPermissionsManager().addClanPermissions(cp);
        if (event.getPlayer().isOp()) {
            for (String message : SimpleClans.getInstance().getMessages()) {
                event.getPlayer().sendMessage(ChatColor.YELLOW + message);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld().getName())) {
            return;
        }
        if (this.plugin.getSettingsManager().isTeleportOnSpawn()) {
            Location loc;
            Player player = event.getPlayer();
            ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
            if (cp != null && (loc = cp.getClan().getHomeLocation()) != null) {
                event.setRespawnLocation(loc);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld().getName())) {
            return;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(event.getPlayer());
        SimpleClans.getInstance().getPermissionsManager().removeClanPlayerPermissions(cp);
        this.plugin.getClanManager().updateLastSeen(event.getPlayer());
        this.plugin.getRequestManager().endPendingRequest(event.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld().getName())) {
            return;
        }
        this.plugin.getClanManager().updateLastSeen(event.getPlayer());
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld().getName())) {
            return;
        }
        this.plugin.getSpoutPluginManager().processPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.plugin.getSpoutPluginManager().processPlayer(event.getPlayer());
    }
}

