/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.util.Collection;
import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.getspout.spoutapi.SpoutManager;
import org.getspout.spoutapi.player.SpoutPlayer;

public final class SpoutPluginManager {
    private SimpleClans plugin = SimpleClans.getInstance();
    private boolean hasSpout = this.checkSpout();

    public void processAllPlayers() {
        if (this.isHasSpout()) {
            Collection<Player> onlinePlayers = Helper.getOnlinePlayers();
            for (Player player : onlinePlayers) {
                this.processPlayer(player);
            }
        }
    }

    @Deprecated
    public void processPlayer(String playerName) {
        Player player;
        if (this.isHasSpout() && (player = SimpleClans.getInstance().hasUUID() ? SimpleClans.getInstance().getServer().getPlayer(UUIDMigration.getForcedPlayerUUID(playerName)) : SimpleClans.getInstance().getServer().getPlayer(playerName)) != null) {
            this.processPlayer(player);
        }
    }

    public void processPlayer(UUID playerUniqueId) {
        Player player;
        if (this.isHasSpout() && (player = SimpleClans.getInstance().getServer().getPlayer(playerUniqueId)) != null) {
            this.processPlayer(player);
        }
    }

    public void processPlayer(Player player) {
        ClanPlayer cp;
        if (this.isHasSpout() && (cp = this.plugin.getClanManager().getClanPlayer(player)) != null && cp.getClan().isVerified()) {
            Clan clan = cp.getClan();
            SpoutPlayer sp = SpoutManager.getPlayer((Player)player);
            if (this.plugin.getSettingsManager().isClanCapes()) {
                if (!clan.getCapeUrl().isEmpty()) {
                    if (clan.getCapeUrl().toLowerCase().contains(".png")) {
                        sp.setCape(clan.getCapeUrl());
                    }
                } else if (this.plugin.getSettingsManager().getDefaultCapeUrl().toLowerCase().contains(".png")) {
                    sp.setCape(this.plugin.getSettingsManager().getDefaultCapeUrl());
                }
            }
            if (this.plugin.getSettingsManager().isInGameTags()) {
                if (player.isSneaking()) {
                    sp.setTitle(player.getName());
                } else {
                    String tag = this.plugin.getSettingsManager().isInGameTagsColored() ? this.plugin.getSettingsManager().getTagBracketColor() + this.plugin.getSettingsManager().getTagBracketLeft() + clan.getColorTag() + this.plugin.getSettingsManager().getTagBracketColor() + this.plugin.getSettingsManager().getTagBracketRight() + this.plugin.getSettingsManager().getTagSeparatorColor() + this.plugin.getSettingsManager().getTagSeparator() : ChatColor.DARK_GRAY + this.plugin.getSettingsManager().getTagBracketLeft() + clan.getTag() + this.plugin.getSettingsManager().getTagBracketRight() + this.plugin.getSettingsManager().getTagSeparator();
                    sp.setTitle(tag + ChatColor.WHITE + player.getName());
                }
            }
        }
    }

    public void clearCape(Player player) {
        ClanPlayer cp;
        if (this.isHasSpout() && (cp = this.plugin.getClanManager().getClanPlayer(player)) != null && cp.getClan().isVerified()) {
            SpoutPlayer sp = SpoutManager.getPlayer((Player)player);
            sp.setCape("");
        }
    }

    public void playAlert(Player player) {
        if (this.isHasSpout()) {
            SpoutPlayer sp = SpoutManager.getPlayerFromId((int)player.getEntityId());
            SpoutManager.getSoundManager().playCustomSoundEffect((Plugin)this.plugin, sp, this.plugin.getSettingsManager().getAlertUrl(), true);
        }
    }

    private boolean checkSpout() {
        Plugin test = this.plugin.getServer().getPluginManager().getPlugin("Spout");
        if (test != null) {
            SimpleClans.log(this.plugin.getLang("spout.features.enabled"), new Object[0]);
            return true;
        }
        return false;
    }

    public boolean isHasSpout() {
        return this.hasSpout;
    }
}

