/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.List;
import java.util.Random;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.events.PlayerHomeSetEvent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class HomeCommand {
    public void execute(Player player, String[] arg) {
        Clan clan;
        SimpleClans plugin = SimpleClans.getInstance();
        if (arg.length == 2 && arg[0].equalsIgnoreCase("set") && plugin.getPermissionsManager().has(player, "simpleclans.mod.home")) {
            if (!plugin.getClanManager().purchaseHomeTeleportSet(player)) {
                return;
            }
            Location loc = player.getLocation();
            clan = plugin.getClanManager().getClan(arg[1]);
            if (clan != null) {
                clan.setHomeLocation(loc);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(plugin.getLang("hombase.mod.set"), clan.getName()) + " " + ChatColor.YELLOW + Helper.toLocationString(loc));
            }
        }
        if (arg.length == 2 && arg[0].equalsIgnoreCase("tp") && plugin.getPermissionsManager().has(player, "simpleclans.mod.hometp")) {
            Clan clan2 = plugin.getClanManager().getClan(arg[1]);
            if (clan2 != null) {
                Location loc = clan2.getHomeLocation();
                if (loc == null) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("hombase.not.set"));
                    return;
                }
                player.teleport(loc);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(plugin.getLang("now.at.homebase"), clan2.getName()));
                return;
            }
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("the.clan.does.not.exist"));
            return;
        }
        ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            return;
        }
        clan = cp.getClan();
        if (!clan.isVerified()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
            return;
        }
        if (!cp.isTrusted()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("only.trusted.players.can.access.clan.vitals"));
            return;
        }
        if (arg.length == 0) {
            if (!plugin.getPermissionsManager().has(player, "simpleclans.member.home")) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
                return;
            }
            Location loc = clan.getHomeLocation();
            if (loc == null) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("hombase.not.set"));
                return;
            }
            if (plugin.getClanManager().purchaseHomeTeleport(player)) {
                plugin.getTeleportManager().addPlayer(player, clan.getHomeLocation(), clan.getName());
            }
        } else {
            String ttag = arg[0];
            if (ttag.equalsIgnoreCase("set")) {
                if (!cp.isLeader()) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
                    return;
                }
                if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.home-set")) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
                    return;
                }
                if (plugin.getSettingsManager().isHomebaseSetOnce() && clan.getHomeLocation() != null && !plugin.getPermissionsManager().has(player, "simpleclans.mod.home")) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("home.base.only.once"));
                    return;
                }
                PlayerHomeSetEvent homeSetEvent = new PlayerHomeSetEvent(clan, cp, player.getLocation());
                SimpleClans.getInstance().getServer().getPluginManager().callEvent((Event)homeSetEvent);
                if (homeSetEvent.isCancelled() || !plugin.getClanManager().purchaseHomeTeleportSet(player)) {
                    return;
                }
                clan.setHomeLocation(player.getLocation());
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(plugin.getLang("hombase.set"), ChatColor.YELLOW + Helper.toLocationString(player.getLocation())));
            } else if (ttag.equalsIgnoreCase("clear")) {
                if (!cp.isLeader()) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
                    return;
                }
                if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.home-set")) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
                    return;
                }
                if (plugin.getSettingsManager().isHomebaseSetOnce() && clan.getHomeLocation() != null && !plugin.getPermissionsManager().has(player, "simpleclans.mod.home")) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("home.base.only.once"));
                    return;
                }
                clan.setHomeLocation(null);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + plugin.getLang("hombase.cleared"));
            } else if (ttag.equalsIgnoreCase("regroup")) {
                if (SimpleClans.getInstance().getSettingsManager().getAllowReGroupCommand()) {
                    Location loc = player.getLocation();
                    if (!cp.isLeader()) {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
                    }
                    if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.regroup")) {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
                    }
                    List<ClanPlayer> members = clan.getAllMembers();
                    for (ClanPlayer ccp : members) {
                        Player pl = ccp.toPlayer();
                        if (pl == null || pl.equals(player)) continue;
                        int x = loc.getBlockX();
                        int z = loc.getBlockZ();
                        player.sendBlockChange(new Location(loc.getWorld(), (double)(x + 1), (double)loc.getBlockY(), (double)(z + 1)), Material.GLASS, (byte)0);
                        player.sendBlockChange(new Location(loc.getWorld(), (double)(x - 1), (double)loc.getBlockY(), (double)(z - 1)), Material.GLASS, (byte)0);
                        player.sendBlockChange(new Location(loc.getWorld(), (double)(x + 1), (double)loc.getBlockY(), (double)(z - 1)), Material.GLASS, (byte)0);
                        player.sendBlockChange(new Location(loc.getWorld(), (double)(x - 1), (double)loc.getBlockY(), (double)(z + 1)), Material.GLASS, (byte)0);
                        Random r = new Random();
                        int xx = r.nextInt(2) - 1;
                        int zz = r.nextInt(2) - 1;
                        if (xx == 0 && zz == 0) {
                            xx = 1;
                        }
                        pl.teleport(new Location(loc.getWorld(), (double)(x += xx) + 0.5, (double)loc.getBlockY(), (double)(z += zz) + 0.5));
                    }
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + plugin.getLang("hombase.set") + ChatColor.YELLOW + Helper.toLocationString(loc));
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            }
        }
    }
}

