/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.Map;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KillsCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        if (plugin.getPermissionsManager().has(player, "simpleclans.member.kills")) {
            ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
            if (cp != null) {
                Clan clan = cp.getClan();
                if (clan.isVerified()) {
                    if (cp.isTrusted()) {
                        String polledPlayerName = player.getName();
                        if (arg.length == 1) {
                            polledPlayerName = arg[0];
                        }
                        ChatBlock chatBlock = new ChatBlock();
                        chatBlock.setFlexibility(true, false);
                        chatBlock.setAlignment("l", "c");
                        chatBlock.addRow("  " + headColor + plugin.getLang("victim"), plugin.getLang("killcount"));
                        Map<String, Integer> killsPerPlayerUnordered = plugin.getStorageManager().getKillsPerPlayer(polledPlayerName);
                        if (killsPerPlayerUnordered.isEmpty()) {
                            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("nokillsfound"));
                            return;
                        }
                        Map killsPerPlayer = Helper.sortByValue(killsPerPlayerUnordered);
                        for (Map.Entry playerKills : killsPerPlayer.entrySet()) {
                            int count = (Integer)playerKills.getValue();
                            chatBlock.addRow("  " + (String)playerKills.getKey(), ChatColor.AQUA + "" + count);
                        }
                        ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getPageClanNameColor() + Helper.capitalize(polledPlayerName) + subColor + " " + plugin.getLang("kills") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
                        ChatBlock.sendBlank((CommandSender)player);
                        boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
                        if (more) {
                            plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
                            ChatBlock.sendBlank((CommandSender)player);
                            ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
                        }
                        ChatBlock.sendBlank((CommandSender)player);
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("only.trusted.players.can.access.clan.stats"));
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
        }
    }
}

