/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.executors;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DenyCommandExecutor
implements CommandExecutor {
    SimpleClans plugin = SimpleClans.getInstance();

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        Player player = (Player)commandSender;
        if (this.plugin.getSettingsManager().isBanned(player.getName())) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
            return false;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp != null) {
            Clan clan = cp.getClan();
            if (clan.isLeader(player)) {
                if (this.plugin.getRequestManager().hasRequest(clan.getTag())) {
                    if (cp.getVote() == null) {
                        this.plugin.getRequestManager().deny(cp);
                        clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("has.voted.to.deny"), Helper.capitalize(player.getName())));
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("you.have.already.voted"));
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.deny"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("no.leader.permissions"));
            }
        } else if (this.plugin.getRequestManager().hasRequest(player.getName().toLowerCase())) {
            cp = SimpleClans.getInstance().hasUUID() ? this.plugin.getClanManager().getCreateClanPlayer(player.getUniqueId()) : this.plugin.getClanManager().getCreateClanPlayer(player.getName());
            this.plugin.getRequestManager().deny(cp);
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.deny"));
        }
        return false;
    }
}

