/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class LanguageManager {
    private File file;
    private HashMap<String, String> language;
    private String[] comments = new String[0];

    public LanguageManager() {
        this.load();
    }

    public void load() {
        this.file = new File(SimpleClans.getInstance().getDataFolder() + File.separator + "language.yml");
        this.check();
    }

    private void check() {
        boolean exists = this.file.exists();
        this.loadDefaults();
        if (exists) {
            this.loadFile();
        }
        this.saveFile();
    }

    private void loadDefaults() {
        try {
            InputStream defaultLanguage = this.getClass().getResourceAsStream("/language.yml");
            this.language = (HashMap)new Yaml().load(defaultLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFile() {
        try {
            FileInputStream fileLanguage = new FileInputStream(this.file);
            this.language = (HashMap)new Yaml().load((InputStream)fileLanguage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setWidth(99999999);
        options.setAllowUnicode(true);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));){
            new Yaml(options).dump(this.language, (Writer)out);
            for (String comment : this.comments) {
                out.write(comment);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        String o = this.language.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }
}

