/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.Dates;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.VoteResult;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ClanPlayer
implements Serializable,
Comparable<ClanPlayer> {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean leader;
    private boolean trusted;
    private String tag;
    private Clan clan;
    private boolean friendlyFire;
    private int neutralKills;
    private int rivalKills;
    private int civilianKills;
    private int deaths;
    private long lastSeen;
    private long joinDate;
    private HashSet<String> pastClans = new HashSet();
    private VoteResult vote;
    private Channel channel;
    private boolean useChatShortcut = false;
    private boolean globalChat = true;
    private boolean allyChat = true;
    private boolean clanChat = true;
    private boolean bbEnabled = true;
    private boolean tagEnabled = true;
    private boolean capeEnabled = true;
    private String rank = "";

    public ClanPlayer() {
        this.tag = "";
        this.channel = Channel.NONE;
    }

    public ClanPlayer(String playerName) {
        this.name = playerName;
        this.lastSeen = new Date().getTime();
        this.joinDate = new Date().getTime();
        this.neutralKills = 0;
        this.rivalKills = 0;
        this.civilianKills = 0;
        this.tag = "";
        this.channel = Channel.NONE;
    }

    public int hashCode() {
        return this.getName().hashCode() >> 13;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClanPlayer)) {
            return false;
        }
        ClanPlayer other = (ClanPlayer)obj;
        return other.getName().equals(this.getName());
    }

    @Override
    public int compareTo(ClanPlayer other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        return this.name.toLowerCase();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public void setLeader(boolean leader) {
        if (leader) {
            this.trusted = leader;
        }
        this.leader = leader;
    }

    public boolean isAlly(Player player) {
        ClanPlayer allycp = SimpleClans.getInstance().getClanManager().getClanPlayer(player);
        if (allycp != null) {
            return allycp.getClan().isAlly(this.tag);
        }
        return false;
    }

    public boolean isRival(Player player) {
        ClanPlayer allycp = SimpleClans.getInstance().getClanManager().getClanPlayer(player);
        if (allycp != null) {
            return allycp.getClan().isRival(this.tag);
        }
        return false;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public void updateLastSeen() {
        this.lastSeen = new Date().getTime();
    }

    public String getLastSeenDaysString() {
        double days = Dates.differenceInDays(new Timestamp(this.lastSeen), new Timestamp(new Date().getTime()));
        if (days < 1.0) {
            return SimpleClans.getInstance().getLang("today");
        }
        if (Math.round(days) == 1L) {
            return MessageFormat.format(SimpleClans.getInstance().getLang("1.color.day"), ChatColor.GRAY);
        }
        return MessageFormat.format(SimpleClans.getInstance().getLang("many.color.days"), Math.round(days), ChatColor.GRAY);
    }

    public double getLastSeenDays() {
        return Dates.differenceInDays(new Timestamp(this.lastSeen), new Timestamp(new Date().getTime()));
    }

    public int getRivalKills() {
        return this.rivalKills;
    }

    public void setRivalKills(int rivalKills) {
        this.rivalKills = rivalKills;
    }

    public void addRivalKill() {
        this.setRivalKills(this.getRivalKills() + 1);
    }

    public int getCivilianKills() {
        return this.civilianKills;
    }

    public void setCivilianKills(int civilianKills) {
        this.civilianKills = civilianKills;
    }

    public void addCivilianKill() {
        this.setCivilianKills(this.getCivilianKills() + 1);
    }

    public int getNeutralKills() {
        return this.neutralKills;
    }

    public void setNeutralKills(int neutralKills) {
        this.neutralKills = neutralKills;
    }

    public void addNeutralKill() {
        this.setNeutralKills(this.getNeutralKills() + 1);
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    public VoteResult getVote() {
        return this.vote;
    }

    public void setVote(VoteResult vote) {
        this.vote = vote;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    public void addDeath() {
        this.setDeaths(this.getDeaths() + 1);
    }

    public double getWeightedKills() {
        SimpleClans plugin = SimpleClans.getInstance();
        return (double)this.rivalKills * plugin.getSettingsManager().getKwRival() + (double)this.neutralKills * plugin.getSettingsManager().getKwNeutral() + (double)this.civilianKills * plugin.getSettingsManager().getKwCivilian();
    }

    public float getKDR() {
        int totalDeaths = this.getDeaths();
        if (totalDeaths == 0) {
            totalDeaths = 1;
        }
        return (float)this.getWeightedKills() / (float)totalDeaths;
    }

    public long getJoinDate() {
        return this.joinDate;
    }

    public void setJoinDate(long joinDate) {
        this.joinDate = joinDate;
    }

    public String getJoinDateString() {
        if (this.joinDate == 0L) {
            return "";
        }
        return new SimpleDateFormat("MMM dd, ''yy h:mm a").format(new Date(this.joinDate));
    }

    public String getLastSeenString() {
        return new SimpleDateFormat("MMM dd, ''yy h:mm a").format(new Date(this.lastSeen));
    }

    public int getInactiveDays() {
        Timestamp now = new Timestamp(new Date().getTime());
        return (int)Math.floor(Dates.differenceInDays(new Timestamp(this.getLastSeen()), now));
    }

    public String getPackedPastClans() {
        String PackedPastClans = "";
        HashSet<String> pt = this.getPastClans();
        for (String pastClan : pt) {
            PackedPastClans = PackedPastClans + pastClan + "|";
        }
        return Helper.stripTrailing(PackedPastClans, "|");
    }

    public void setPackedPastClans(String PackedPastClans) {
        this.pastClans = Helper.fromArray2(PackedPastClans.split("[|]"));
    }

    public void addPastClan(String tag) {
        this.getPastClans().add(tag);
    }

    public void removePastClan(String tag) {
        this.getPastClans().remove(tag);
    }

    public String getPastClansString(String sep) {
        String out = "";
        for (String pastClan : this.getPastClans()) {
            out = out + pastClan + sep;
        }
        if ((out = Helper.stripTrailing(out, sep)).trim().isEmpty()) {
            return SimpleClans.getInstance().getLang("none");
        }
        return out;
    }

    public HashSet<String> getPastClans() {
        HashSet<String> pc = new HashSet<String>();
        pc.addAll(this.pastClans);
        return pc;
    }

    public Clan getClan() {
        return this.clan;
    }

    public void setClan(Clan clan) {
        this.tag = clan == null ? "" : clan.getTag();
        this.clan = clan;
    }

    public String getTag() {
        return this.tag;
    }

    public String getTagLabel() {
        if (this.clan == null) {
            return "";
        }
        return this.clan.getTagLabel();
    }

    public boolean isTrusted() {
        return this.leader || this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getFlags() {
        JSONObject json = new JSONObject();
        if (this.rank != null) {
            json.put("rank", this.rank);
        }
        json.put("channel", this.channel.toString());
        LinkedList<Boolean> settings = new LinkedList<Boolean>();
        settings.add(this.globalChat);
        settings.add(this.allyChat);
        settings.add(this.clanChat);
        json.put("channel-state", settings);
        json.put("chat-shortcut", this.useChatShortcut);
        json.put("bb-enabled", this.bbEnabled);
        json.put("hide-tag", this.tagEnabled);
        json.put("cape-enabled", this.capeEnabled);
        return json.toString();
    }

    public void setFlags(String flagString) {
        Object obj;
        JSONObject flags;
        if (flagString != null && !flagString.isEmpty() && (flags = (JSONObject)(obj = JSONValue.parse(flagString))) != null) {
            for (Object flag : flags.keySet()) {
                try {
                    JSONArray settings;
                    String chn;
                    if (flag.equals("rank")) {
                        if (flags.get(flag) == null) continue;
                        this.rank = flags.get(flag).toString();
                    }
                    if (flag.equals("channel") && (chn = flags.get(flag).toString()) != null && !chn.isEmpty()) {
                        this.channel = chn.equalsIgnoreCase("clan") ? Channel.CLAN : (chn.equalsIgnoreCase("ally") ? Channel.ALLY : Channel.NONE);
                    }
                    if (flag.equals("channel-state") && (settings = (JSONArray)flags.get(flag)) != null && !settings.isEmpty()) {
                        this.globalChat = (Boolean)settings.get(0);
                        this.allyChat = (Boolean)settings.get(1);
                        this.clanChat = (Boolean)settings.get(2);
                    }
                    if (flag.equals("bb-enabled")) {
                        this.bbEnabled = (Boolean)flags.get(flag);
                    }
                    if (flag.equals("hide-tag")) {
                        this.tagEnabled = (Boolean)flags.get(flag);
                    }
                    if (flag.equals("cape-enabled")) {
                        this.capeEnabled = (Boolean)flags.get(flag);
                    }
                    if (!flag.equals("chat-shortcut")) continue;
                    this.useChatShortcut = (Boolean)flags.get(flag);
                }
                catch (Exception ex) {
                    for (StackTraceElement el : ex.getStackTrace()) {
                        System.out.print("Failed reading flag: " + flag);
                        System.out.print("Value: " + flags.get(flag));
                        System.out.print(el.toString());
                    }
                }
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isGlobalChat() {
        return this.globalChat;
    }

    public boolean isAllyChat() {
        return this.allyChat;
    }

    public boolean isClanChat() {
        return this.clanChat;
    }

    public void setGlobalChat(boolean globalChat) {
        this.globalChat = globalChat;
    }

    public void setAllyChat(boolean allyChat) {
        this.allyChat = allyChat;
    }

    public void setClanChat(boolean clanChat) {
        this.clanChat = clanChat;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isBbEnabled() {
        return this.bbEnabled;
    }

    public void setBbEnabled(boolean bbEnabled) {
        this.bbEnabled = bbEnabled;
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(this);
    }

    public boolean isCapeEnabled() {
        return this.capeEnabled;
    }

    public void setCapeEnabled(boolean capeEnabled) {
        this.capeEnabled = capeEnabled;
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(this);
    }

    public boolean isTagEnabled() {
        return this.tagEnabled;
    }

    public void setTagEnabled(boolean tagEnabled) {
        this.tagEnabled = tagEnabled;
        SimpleClans.getInstance().getStorageManager().updateClanPlayer(this);
        SimpleClans.getInstance().getClanManager().updateDisplayName(this.toPlayer());
    }

    public boolean isUseChatShortcut() {
        return this.useChatShortcut;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public Player toPlayer() {
        return SimpleClans.getInstance().getServer().getPlayer(this.name);
    }

    public static enum Channel {
        CLAN,
        ALLY,
        NONE;

    }
}

