/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RosterCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        Clan clan = null;
        if (arg.length == 0) {
            if (plugin.getPermissionsManager().has(player, "simpleclans.member.roster")) {
                ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
                if (cp == null) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
                } else {
                    clan = cp.getClan();
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            }
        } else if (arg.length == 1) {
            if (plugin.getPermissionsManager().has(player, "simpleclans.anyone.roster")) {
                clan = plugin.getClanManager().getClan(arg[0]);
                if (clan == null) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.clan.matched"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.0.roster.tag"), plugin.getSettingsManager().getCommandClan()));
        }
        if (clan != null) {
            if (clan.isVerified()) {
                String lastSeen;
                String name;
                Player p;
                ChatBlock chatBlock = new ChatBlock();
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getPageClanNameColor() + Helper.capitalize(clan.getName()) + subColor + " " + plugin.getLang("roster") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.sendMessage((CommandSender)player, headColor + plugin.getLang("legend") + " " + plugin.getSettingsManager().getPageLeaderColor() + plugin.getLang("leader") + headColor + ", " + plugin.getSettingsManager().getPageTrustedColor() + plugin.getLang("trusted") + headColor + ", " + plugin.getSettingsManager().getPageUnTrustedColor() + plugin.getLang("untrusted"));
                ChatBlock.sendBlank((CommandSender)player);
                chatBlock.setFlexibility(false, true, false, true);
                chatBlock.addRow("  " + headColor + plugin.getLang("player"), plugin.getLang("rank"), plugin.getLang("seen"));
                List<ClanPlayer> leaders = clan.getLeaders();
                plugin.getClanManager().sortClanPlayersByLastSeen(leaders);
                List<ClanPlayer> members = clan.getNonLeaders();
                plugin.getClanManager().sortClanPlayersByLastSeen(members);
                for (ClanPlayer cp : leaders) {
                    p = plugin.getServer().getPlayer(cp.getName());
                    name = plugin.getSettingsManager().getPageLeaderColor() + cp.getName();
                    lastSeen = p != null && p.isOnline() && !Helper.isVanished(p) ? ChatColor.GREEN + plugin.getLang("online") : ChatColor.WHITE + cp.getLastSeenDaysString();
                    chatBlock.addRow("  " + name, ChatColor.YELLOW + Helper.parseColors(cp.getRank()), lastSeen);
                }
                for (ClanPlayer cp : members) {
                    p = plugin.getServer().getPlayer(cp.getName());
                    name = (cp.isTrusted() ? plugin.getSettingsManager().getPageTrustedColor() : plugin.getSettingsManager().getPageUnTrustedColor()) + cp.getName();
                    lastSeen = p != null && p.isOnline() && !Helper.isVanished(p) ? ChatColor.GREEN + plugin.getLang("online") : ChatColor.WHITE + cp.getLastSeenDaysString();
                    chatBlock.addRow("  " + name, ChatColor.YELLOW + Helper.parseColors(cp.getRank()), lastSeen);
                }
                boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
                if (more) {
                    plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
                    ChatBlock.sendBlank((CommandSender)player);
                    ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
                }
                ChatBlock.sendBlank((CommandSender)player);
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.0.roster.tag"), plugin.getSettingsManager().getCommandClan()));
        }
    }
}

