/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class ClanManager {
    private SimpleClans plugin;
    private HashMap<String, Clan> clans = new HashMap();
    private HashMap<String, ClanPlayer> clanPlayers = new HashMap();

    public ClanManager() {
        this.plugin = SimpleClans.getInstance();
    }

    public void cleanData() {
        this.clans.clear();
        this.clanPlayers.clear();
    }

    public void importClan(Clan clan) {
        this.clans.put(clan.getTag(), clan);
    }

    public void importClanPlayer(ClanPlayer cp) {
        this.clanPlayers.put(cp.getCleanName(), cp);
    }

    public void createClan(Player player, String colorTag, String name) {
        ClanPlayer cp = this.getCreateClanPlayer(player.getName());
        boolean verified = !this.plugin.getSettingsManager().isRequireVerification() || this.plugin.getPermissionsManager().has(player, "simpleclans.mod.verify");
        Clan clan = new Clan(colorTag, name, verified);
        clan.addPlayerToClan(cp);
        cp.setLeader(true);
        this.plugin.getStorageManager().insertClan(clan);
        this.importClan(clan);
        this.plugin.getStorageManager().updateClanPlayer(cp);
        SimpleClans.getInstance().getPermissionsManager().updateClanPermissions(clan);
        this.plugin.getSpoutPluginManager().processPlayer(player.getName());
    }

    public void deleteClanPlayer(ClanPlayer cp) {
        this.clanPlayers.remove(cp.getCleanName());
        this.plugin.getStorageManager().deleteClanPlayer(cp);
    }

    public void removeClan(String tag) {
        this.clans.remove(tag);
    }

    public boolean isClan(String tag) {
        return this.clans.containsKey(Helper.cleanTag(tag));
    }

    public Clan getClan(String tag) {
        return this.clans.get(Helper.cleanTag(tag));
    }

    public Clan getClanByPlayerName(String playerName) {
        ClanPlayer cp = this.getClanPlayer(playerName);
        if (cp != null) {
            return cp.getClan();
        }
        return null;
    }

    public List<Clan> getClans() {
        return new ArrayList<Clan>(this.clans.values());
    }

    public List<ClanPlayer> getAllClanPlayers() {
        return new ArrayList<ClanPlayer>(this.clanPlayers.values());
    }

    public ClanPlayer getClanPlayer(Player player) {
        return this.getClanPlayer(player.getName());
    }

    public ClanPlayer getClanPlayer(String playerName) {
        ClanPlayer cp = this.clanPlayers.get(playerName.toLowerCase());
        if (cp == null) {
            return null;
        }
        if (cp.getClan() == null) {
            return null;
        }
        return cp;
    }

    public ClanPlayer getAnyClanPlayer(String playerName) {
        return this.clanPlayers.get(playerName.toLowerCase());
    }

    public ClanPlayer getCreateClanPlayer(String playerName) {
        if (this.clanPlayers.containsKey(playerName.toLowerCase())) {
            return this.clanPlayers.get(playerName.toLowerCase());
        }
        ClanPlayer cp = new ClanPlayer(playerName);
        this.plugin.getStorageManager().insertClanPlayer(cp);
        this.importClanPlayer(cp);
        return cp;
    }

    public void serverAnnounce(String msg) {
        Player[] players;
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.DARK_GRAY + "* " + ChatColor.AQUA + msg);
        }
        SimpleClans.getInstance().getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getLang("server.announce") + "] " + ChatColor.WHITE + msg);
    }

    public void updateDisplayName(Player player) {
        if (this.plugin.getSettingsManager().isCompatMode()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isChatTags()) {
            String prefix = this.plugin.getPermissionsManager().getPrefix(player);
            String suffix = this.plugin.getPermissionsManager().getSuffix(player);
            String lastColor = this.plugin.getSettingsManager().isUseColorCodeFromPrefix() ? Helper.getLastColorCode(prefix) : ChatColor.WHITE + "";
            String fullName = player.getName();
            ClanPlayer cp = this.plugin.getClanManager().getAnyClanPlayer(player.getName());
            if (this.plugin.getSettingsManager().ismChatIntegration() && this.plugin.getPermissionsManager().getMChat() != null) {
                if (cp == null) {
                    this.plugin.getPermissionsManager().clearSetMChatClanTag(player);
                    return;
                }
                if (cp.isTagEnabled()) {
                    Clan clan = cp.getClan();
                    if (clan != null) {
                        this.plugin.getPermissionsManager().addSetMChatClanTag(player, clan.getTagLabel());
                    } else {
                        this.plugin.getPermissionsManager().clearSetMChatClanTag(player);
                    }
                } else {
                    this.plugin.getPermissionsManager().clearSetMChatClanTag(player);
                }
            } else {
                if (cp == null) {
                    return;
                }
                if (cp.isTagEnabled()) {
                    Clan clan = cp.getClan();
                    if (clan != null) {
                        fullName = clan.getTagLabel() + lastColor + fullName + ChatColor.WHITE;
                    }
                    player.setDisplayName(fullName);
                } else {
                    player.setDisplayName(lastColor + fullName + ChatColor.WHITE);
                }
            }
        }
    }

    public void updateLastSeen(Player player) {
        ClanPlayer cp = this.getAnyClanPlayer(player.getName());
        if (cp != null) {
            cp.updateLastSeen();
            this.plugin.getStorageManager().updateClanPlayer(cp);
            Clan clan = cp.getClan();
            if (clan != null) {
                clan.updateLastUsed();
                this.plugin.getStorageManager().updateClan(clan);
            }
        }
    }

    public void ban(String playerName) {
        ClanPlayer cp = this.getClanPlayer(playerName);
        Clan clan = cp.getClan();
        if (clan != null) {
            if (clan.getSize() == 1) {
                clan.disband();
            } else {
                cp.setClan(null);
                cp.addPastClan(clan.getColorTag() + (cp.isLeader() ? ChatColor.DARK_RED + "*" : ""));
                cp.setLeader(false);
                cp.setJoinDate(0L);
                clan.removeMember(playerName);
                this.plugin.getStorageManager().updateClanPlayer(cp);
                this.plugin.getStorageManager().updateClan(clan);
            }
        }
        this.plugin.getSettingsManager().addBanned(playerName);
    }

    public int getRivableClanCount() {
        int clanCount = 0;
        for (Clan tm : this.clans.values()) {
            if (SimpleClans.getInstance().getSettingsManager().isUnrivable(tm.getTag())) continue;
            ++clanCount;
        }
        return clanCount;
    }

    public String getArmorString(PlayerInventory inv) {
        String out = "";
        ItemStack h = inv.getHelmet();
        out = h.getType().equals((Object)Material.CHAINMAIL_HELMET) ? out + ChatColor.WHITE + this.plugin.getLang("armor.h") : (h.getType().equals((Object)Material.DIAMOND_HELMET) ? out + ChatColor.AQUA + this.plugin.getLang("armor.h") : (h.getType().equals((Object)Material.GOLD_HELMET) ? out + ChatColor.YELLOW + this.plugin.getLang("armor.h") : (h.getType().equals((Object)Material.IRON_HELMET) ? out + ChatColor.GRAY + this.plugin.getLang("armor.h") : (h.getType().equals((Object)Material.LEATHER_HELMET) ? out + ChatColor.GOLD + this.plugin.getLang("armor.h") : (h.getType().equals((Object)Material.AIR) ? out + ChatColor.BLACK + this.plugin.getLang("armor.h") : out + ChatColor.RED + this.plugin.getLang("armor.h"))))));
        ItemStack c = inv.getChestplate();
        out = c.getType().equals((Object)Material.CHAINMAIL_CHESTPLATE) ? out + ChatColor.WHITE + this.plugin.getLang("armor.c") : (c.getType().equals((Object)Material.DIAMOND_CHESTPLATE) ? out + ChatColor.AQUA + this.plugin.getLang("armor.c") : (c.getType().equals((Object)Material.GOLD_CHESTPLATE) ? out + ChatColor.YELLOW + this.plugin.getLang("armor.c") : (c.getType().equals((Object)Material.IRON_CHESTPLATE) ? out + ChatColor.GRAY + this.plugin.getLang("armor.c") : (c.getType().equals((Object)Material.LEATHER_CHESTPLATE) ? out + ChatColor.GOLD + this.plugin.getLang("armor.c") : (c.getType().equals((Object)Material.AIR) ? out + ChatColor.BLACK + this.plugin.getLang("armor.c") : out + ChatColor.RED + this.plugin.getLang("armor.c"))))));
        ItemStack l = inv.getLeggings();
        out = l.getType().equals((Object)Material.CHAINMAIL_LEGGINGS) ? out + ChatColor.WHITE + this.plugin.getLang("armor.l") : (l.getType().equals((Object)Material.DIAMOND_LEGGINGS) ? out + this.plugin.getLang("armor.l") : (l.getType().equals((Object)Material.GOLD_LEGGINGS) ? out + this.plugin.getLang("armor.l") : (l.getType().equals((Object)Material.IRON_LEGGINGS) ? out + this.plugin.getLang("armor.l") : (l.getType().equals((Object)Material.LEATHER_LEGGINGS) ? out + this.plugin.getLang("armor.l") : (l.getType().equals((Object)Material.AIR) ? out + this.plugin.getLang("armor.l") : out + this.plugin.getLang("armor.l"))))));
        ItemStack b = inv.getBoots();
        out = b.getType().equals((Object)Material.CHAINMAIL_BOOTS) ? out + ChatColor.WHITE + this.plugin.getLang("armor.B") : (b.getType().equals((Object)Material.DIAMOND_BOOTS) ? out + ChatColor.AQUA + this.plugin.getLang("armor.B") : (b.getType().equals((Object)Material.GOLD_BOOTS) ? out + ChatColor.YELLOW + this.plugin.getLang("armor.B") : (b.getType().equals((Object)Material.IRON_BOOTS) ? out + ChatColor.WHITE + this.plugin.getLang("armor.B") : (b.getType().equals((Object)Material.LEATHER_BOOTS) ? out + ChatColor.GOLD + this.plugin.getLang("armor.B") : (b.getType().equals((Object)Material.AIR) ? out + ChatColor.BLACK + this.plugin.getLang("armor.B") : out + ChatColor.RED + this.plugin.getLang("armor.B"))))));
        return out;
    }

    public String getWeaponString(PlayerInventory inv) {
        String countString;
        String headColor = this.plugin.getSettingsManager().getPageHeadingsColor();
        String out = "";
        int count = this.getItemCount(inv.all(Material.DIAMOND_SWORD));
        if (count > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.AQUA + this.plugin.getLang("weapon.S") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.GOLD_SWORD))) > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.YELLOW + this.plugin.getLang("weapon.S") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.IRON_SWORD))) > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.WHITE + this.plugin.getLang("weapon.S") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.STONE_SWORD))) > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.GRAY + this.plugin.getLang("weapon.S") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.WOOD_SWORD))) > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.GOLD + this.plugin.getLang("weapon.S") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.BOW))) > 0) {
            countString = count > 1 ? count + "" : "";
            out = out + ChatColor.GOLD + this.plugin.getLang("weapon.B") + headColor + countString;
        }
        if ((count = this.getItemCount(inv.all(Material.ARROW))) > 0) {
            out = out + ChatColor.GOLD + this.plugin.getLang("weapon.A") + headColor + count;
        }
        if (out.length() == 0) {
            out = ChatColor.BLACK + "None";
        }
        return out;
    }

    private int getItemCount(HashMap<Integer, ? extends ItemStack> all) {
        int count = 0;
        for (ItemStack itemStack : all.values()) {
            count += itemStack.getAmount();
        }
        return count;
    }

    public String getFoodString(PlayerInventory inv) {
        double out = 0.0;
        int count = this.getItemCount(inv.all(320));
        if (count > 0) {
            out += (double)(count * 4);
        }
        if ((count = this.getItemCount(inv.all(Material.COOKED_FISH))) > 0) {
            out += (double)(count * 3);
        }
        if ((count = this.getItemCount(inv.all(Material.COOKIE))) > 0) {
            out += (double)(count * 1);
        }
        if ((count = this.getItemCount(inv.all(Material.CAKE))) > 0) {
            out += (double)(count * 6);
        }
        if ((count = this.getItemCount(inv.all(Material.CAKE_BLOCK))) > 0) {
            out += (double)(count * 9);
        }
        if ((count = this.getItemCount(inv.all(Material.MUSHROOM_SOUP))) > 0) {
            out += (double)(count * 4);
        }
        if ((count = this.getItemCount(inv.all(Material.BREAD))) > 0) {
            out += (double)(count * 3);
        }
        if ((count = this.getItemCount(inv.all(Material.APPLE))) > 0) {
            out += (double)(count * 2);
        }
        if ((count = this.getItemCount(inv.all(Material.GOLDEN_APPLE))) > 0) {
            out += (double)(count * 5);
        }
        if ((count = this.getItemCount(inv.all(Material.RAW_BEEF))) > 0) {
            out += (double)(count * 2);
        }
        if ((count = this.getItemCount(inv.all(364))) > 0) {
            out += (double)(count * 4);
        }
        if ((count = this.getItemCount(inv.all(319))) > 0) {
            out += (double)(count * 2);
        }
        if ((count = this.getItemCount(inv.all(Material.RAW_CHICKEN))) > 0) {
            out += (double)(count * 1);
        }
        if ((count = this.getItemCount(inv.all(Material.COOKED_CHICKEN))) > 0) {
            out += (double)(count * 3);
        }
        if ((count = this.getItemCount(inv.all(Material.ROTTEN_FLESH))) > 0) {
            out += (double)(count * 2);
        }
        if ((count = this.getItemCount(inv.all(360))) > 0) {
            out += (double)(count * 2);
        }
        if (out == 0.0) {
            return ChatColor.BLACK + this.plugin.getLang("none");
        }
        return new DecimalFormat("#.#").format(out) + "" + ChatColor.GOLD + "h";
    }

    public String getHealthString(double health) {
        String out = "";
        out = health >= 16.0 ? out + ChatColor.GREEN : (health >= 8.0 ? out + ChatColor.GOLD : out + ChatColor.RED);
        int i = 0;
        while ((double)i < health) {
            out = out + '|';
            ++i;
        }
        return out;
    }

    public String getHungerString(int health) {
        String out = "";
        out = health >= 16 ? out + ChatColor.GREEN : (health >= 8 ? out + ChatColor.GOLD : out + ChatColor.RED);
        for (int i = 0; i < health; ++i) {
            out = out + '|';
        }
        return out;
    }

    public void sortClansByKDR(List<Clan> clans) {
        Collections.sort(clans, new Comparator<Clan>(){

            @Override
            public int compare(Clan c1, Clan c2) {
                Float o1 = Float.valueOf(c1.getTotalKDR());
                Float o2 = Float.valueOf(c2.getTotalKDR());
                return o2.compareTo(o1);
            }
        });
    }

    public void sortClanPlayersByKDR(List<ClanPlayer> cps) {
        Collections.sort(cps, new Comparator<ClanPlayer>(){

            @Override
            public int compare(ClanPlayer c1, ClanPlayer c2) {
                Float o1 = Float.valueOf(c1.getKDR());
                Float o2 = Float.valueOf(c2.getKDR());
                return o2.compareTo(o1);
            }
        });
    }

    public void sortClanPlayersByLastSeen(List<ClanPlayer> cps) {
        Collections.sort(cps, new Comparator<ClanPlayer>(){

            @Override
            public int compare(ClanPlayer c1, ClanPlayer c2) {
                Double o1 = c1.getLastSeenDays();
                Double o2 = c2.getLastSeenDays();
                return o1.compareTo(o2);
            }
        });
    }

    public boolean purchaseCreation(Player player) {
        if (!this.plugin.getSettingsManager().isePurchaseCreation()) {
            return true;
        }
        double price = this.plugin.getSettingsManager().getCreationPrice();
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (this.plugin.getPermissionsManager().playerHasMoney(player, price)) {
                this.plugin.getPermissionsManager().playerChargeMoney(player, price);
                player.sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("account.has.been.debited"), price));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getLang("not.sufficient.money"));
                return false;
            }
        }
        return true;
    }

    public boolean purchaseInvite(Player player) {
        if (!this.plugin.getSettingsManager().isePurchaseInvite()) {
            return true;
        }
        double price = this.plugin.getSettingsManager().getInvitePrice();
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (this.plugin.getPermissionsManager().playerHasMoney(player, price)) {
                this.plugin.getPermissionsManager().playerChargeMoney(player, price);
                player.sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("account.has.been.debited"), price));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getLang("not.sufficient.money"));
                return false;
            }
        }
        return true;
    }

    public boolean purchaseHomeTeleport(Player player) {
        if (!this.plugin.getSettingsManager().isePurchaseHomeTeleport()) {
            return true;
        }
        double price = this.plugin.getSettingsManager().getHomeTeleportPrice();
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (this.plugin.getPermissionsManager().playerHasMoney(player, price)) {
                this.plugin.getPermissionsManager().playerChargeMoney(player, price);
                player.sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("account.has.been.debited"), price));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getLang("not.sufficient.money"));
                return false;
            }
        }
        return true;
    }

    public boolean purchaseHomeTeleportSet(Player player) {
        if (!this.plugin.getSettingsManager().isePurchaseHomeTeleportSet()) {
            return true;
        }
        double price = this.plugin.getSettingsManager().getHomeTeleportPriceSet();
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (this.plugin.getPermissionsManager().playerHasMoney(player, price)) {
                this.plugin.getPermissionsManager().playerChargeMoney(player, price);
                player.sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("account.has.been.debited"), price));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getLang("not.sufficient.money"));
                return false;
            }
        }
        return true;
    }

    public boolean purchaseVerification(Player player) {
        if (!this.plugin.getSettingsManager().isePurchaseVerification()) {
            return true;
        }
        double price = this.plugin.getSettingsManager().getVerificationPrice();
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (this.plugin.getPermissionsManager().playerHasMoney(player, price)) {
                this.plugin.getPermissionsManager().playerChargeMoney(player, price);
                player.sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("account.has.been.debited"), price));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getLang("not.sufficient.money"));
                return false;
            }
        }
        return true;
    }

    public void processClanChat(Player player, String tag, String msg) {
        Clan clan = this.plugin.getClanManager().getClan(tag);
        if (clan == null || !clan.isMember(player)) {
            return;
        }
        this.processClanChat(player, msg);
    }

    public void processClanChat(Player player, String msg) {
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player.getName());
        if (cp == null) {
            return;
        }
        String[] split = msg.split(" ");
        if (split.length == 0) {
            return;
        }
        String command = split[0];
        if (command.equals(this.plugin.getLang("on"))) {
            cp.setClanChat(true);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have enabled clan chat");
        } else if (command.equals(this.plugin.getLang("off"))) {
            cp.setClanChat(false);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have disabled clan chat");
        } else if (command.equals(this.plugin.getLang("join"))) {
            cp.setChannel(ClanPlayer.Channel.CLAN);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have joined clan chat");
        } else if (command.equals(this.plugin.getLang("leave"))) {
            cp.setChannel(ClanPlayer.Channel.NONE);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have left clan chat");
        } else {
            String code = "" + ChatColor.RED + ChatColor.WHITE + ChatColor.RED + ChatColor.BLACK;
            String tag = cp.getRank() != null && !cp.getRank().isEmpty() ? this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketLeft() + this.plugin.getSettingsManager().getClanChatRankColor() + cp.getRank() + this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketRight() + " " : this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketLeft() + this.plugin.getSettingsManager().getTagDefaultColor() + cp.getClan().getColorTag() + this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketRight() + " ";
            String message = code + Helper.parseColors(tag) + this.plugin.getSettingsManager().getClanChatNameColor() + this.plugin.getSettingsManager().getClanChatPlayerBracketLeft() + player.getName() + this.plugin.getSettingsManager().getClanChatPlayerBracketRight() + " " + this.plugin.getSettingsManager().getClanChatMessageColor() + msg;
            String eyeMessage = code + this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketLeft() + this.plugin.getSettingsManager().getTagDefaultColor() + cp.getClan().getColorTag() + this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketRight() + " " + this.plugin.getSettingsManager().getClanChatNameColor() + this.plugin.getSettingsManager().getClanChatPlayerBracketLeft() + player.getName() + this.plugin.getSettingsManager().getClanChatPlayerBracketRight() + " " + this.plugin.getSettingsManager().getClanChatMessageColor() + msg;
            this.plugin.getServer().getConsoleSender().sendMessage(eyeMessage);
            List<ClanPlayer> cps = cp.getClan().getMembers();
            for (ClanPlayer cpp : cps) {
                Player member = this.plugin.getServer().getPlayer(cpp.getName());
                ChatBlock.sendMessage((CommandSender)member, message);
            }
            this.sendToAllSeeing(eyeMessage, cps);
        }
    }

    public void sendToAllSeeing(String msg, List<ClanPlayer> cps) {
        Player[] players;
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            if (!this.plugin.getPermissionsManager().has(player, "simpleclans.admin.all-seeing-eye")) continue;
            boolean alreadySent = false;
            for (ClanPlayer cpp : cps) {
                if (!cpp.getName().equalsIgnoreCase(player.getName())) continue;
                alreadySent = true;
            }
            if (alreadySent) continue;
            ChatBlock.sendMessage((CommandSender)player, ChatColor.DARK_GRAY + Helper.stripColors(msg));
        }
    }

    public void processAllyChat(Player player, String msg) {
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            return;
        }
        String[] split = msg.split(" ");
        if (split.length == 0) {
            return;
        }
        String command = split[0];
        if (command.equals(this.plugin.getLang("on"))) {
            cp.setAllyChat(true);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have enabled ally chat");
        } else if (command.equals(this.plugin.getLang("off"))) {
            cp.setAllyChat(false);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have disabled ally chat");
        } else if (command.equals(this.plugin.getLang("join"))) {
            cp.setChannel(ClanPlayer.Channel.ALLY);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have joined ally chat");
        } else if (command.equals(this.plugin.getLang("leave"))) {
            cp.setChannel(ClanPlayer.Channel.NONE);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have left ally chat");
        } else {
            String code = "" + ChatColor.AQUA + ChatColor.WHITE + ChatColor.AQUA + ChatColor.BLACK;
            String message = code + this.plugin.getSettingsManager().getAllyChatBracketColor() + this.plugin.getSettingsManager().getAllyChatTagBracketLeft() + this.plugin.getSettingsManager().getAllyChatTagColor() + this.plugin.getSettingsManager().getCommandAlly() + this.plugin.getSettingsManager().getAllyChatBracketColor() + this.plugin.getSettingsManager().getAllyChatTagBracketRight() + " " + this.plugin.getSettingsManager().getAllyChatNameColor() + this.plugin.getSettingsManager().getAllyChatPlayerBracketLeft() + player.getName() + this.plugin.getSettingsManager().getAllyChatPlayerBracketRight() + " " + this.plugin.getSettingsManager().getAllyChatMessageColor() + msg;
            SimpleClans.log(message, new Object[0]);
            Player self = this.plugin.getServer().getPlayer(player.getName());
            ChatBlock.sendMessage((CommandSender)self, message);
            Set<ClanPlayer> allies = cp.getClan().getAllAllyMembers();
            allies.addAll(cp.getClan().getMembers());
            for (ClanPlayer ally : allies) {
                if (player.getName().equalsIgnoreCase(ally.getName())) continue;
                Player member = this.plugin.getServer().getPlayer(ally.getName());
                ChatBlock.sendMessage((CommandSender)member, message);
            }
        }
    }

    public boolean processGlobalChat(Player player, String msg) {
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player.getName());
        if (cp == null) {
            return false;
        }
        String[] split = msg.split(" ");
        if (split.length == 0) {
            return false;
        }
        String command = split[0];
        if (command.equals(this.plugin.getLang("on"))) {
            cp.setGlobalChat(true);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have enabled global chat");
        } else if (command.equals(this.plugin.getLang("off"))) {
            cp.setGlobalChat(false);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have disabled global chat");
        } else {
            return true;
        }
        return false;
    }
}

