/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.commands.AlliancesCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.AllyCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.BanCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.BankCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.BbCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.CapeCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ClanffCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.CoordsCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.CreateCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.DemoteCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.DisbandCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.FfCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.GlobalffCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.HomeCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.InviteCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.KickCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.KillsCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.LeaderboardCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ListCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.LookupCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.MenuCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ModtagCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.MostKilledCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ProfileCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.PromoteCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ReloadCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ResignCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.RivalCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.RivalriesCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.RosterCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.SetRankCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.StatsCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.ToggleCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.TrustCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.UnbanCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.UntrustCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.VerifyCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.VitalsCommand;
import net.sacredlabyrinth.phaed.simpleclans.commands.WarCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandManager {
    private SimpleClans plugin = SimpleClans.getInstance();
    private CreateCommand createCommand;
    private ListCommand listCommand;
    private ProfileCommand profileCommand;
    private RosterCommand rosterCommand;
    private LookupCommand lookupCommand;
    private LeaderboardCommand leaderboardCommand;
    private AlliancesCommand alliancesCommand;
    private RivalriesCommand rivalriesCommand;
    private VitalsCommand vitalsCommand;
    private CoordsCommand coordsCommand;
    private StatsCommand statsCommand;
    private AllyCommand allyCommand;
    private RivalCommand rivalCommand;
    private BbCommand bbCommand;
    private ModtagCommand modtagCommand;
    private ToggleCommand toggleCommand;
    private InviteCommand inviteCommand;
    private KickCommand kickCommand;
    private TrustCommand trustCommand;
    private UntrustCommand untrustCommand;
    private PromoteCommand promoteCommand;
    private CapeCommand capeCommand;
    private DemoteCommand demoteCommand;
    private ClanffCommand clanffCommand;
    private FfCommand ffCommand;
    private ResignCommand resignCommand;
    private DisbandCommand disbandCommand;
    private VerifyCommand verifyCommand;
    private BanCommand banCommand;
    private UnbanCommand unbanCommand;
    private ReloadCommand reloadCommand;
    private GlobalffCommand globalffCommand;
    private MenuCommand menuCommand = new MenuCommand();
    private WarCommand warCommand;
    private HomeCommand homeCommand;
    private KillsCommand killsCommand;
    private MostKilledCommand mostKilledCommand;
    private SetRankCommand setRankCommand;
    private BankCommand bankCommand;

    public CommandManager() {
        this.createCommand = new CreateCommand();
        this.listCommand = new ListCommand();
        this.profileCommand = new ProfileCommand();
        this.rosterCommand = new RosterCommand();
        this.lookupCommand = new LookupCommand();
        this.leaderboardCommand = new LeaderboardCommand();
        this.alliancesCommand = new AlliancesCommand();
        this.rivalriesCommand = new RivalriesCommand();
        this.vitalsCommand = new VitalsCommand();
        this.coordsCommand = new CoordsCommand();
        this.statsCommand = new StatsCommand();
        this.allyCommand = new AllyCommand();
        this.rivalCommand = new RivalCommand();
        this.bbCommand = new BbCommand();
        this.modtagCommand = new ModtagCommand();
        this.toggleCommand = new ToggleCommand();
        this.inviteCommand = new InviteCommand();
        this.kickCommand = new KickCommand();
        this.trustCommand = new TrustCommand();
        this.untrustCommand = new UntrustCommand();
        this.promoteCommand = new PromoteCommand();
        this.capeCommand = new CapeCommand();
        this.demoteCommand = new DemoteCommand();
        this.clanffCommand = new ClanffCommand();
        this.ffCommand = new FfCommand();
        this.resignCommand = new ResignCommand();
        this.disbandCommand = new DisbandCommand();
        this.verifyCommand = new VerifyCommand();
        this.banCommand = new BanCommand();
        this.unbanCommand = new UnbanCommand();
        this.reloadCommand = new ReloadCommand();
        this.globalffCommand = new GlobalffCommand();
        this.warCommand = new WarCommand();
        this.homeCommand = new HomeCommand();
        this.killsCommand = new KillsCommand();
        this.mostKilledCommand = new MostKilledCommand();
        this.setRankCommand = new SetRankCommand();
        this.bankCommand = new BankCommand();
    }

    public void processClan(CommandSender sender, String[] args) {
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (this.plugin.getSettingsManager().isBlacklistedWorld(player.getLocation().getWorld().getName())) {
                    return;
                }
                if (this.plugin.getSettingsManager().isBanned(player.getName())) {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
                    return;
                }
                if (args.length == 0) {
                    this.menuCommand.execute(player);
                } else {
                    String subcommand = args[0];
                    String[] subargs = Helper.removeFirst(args);
                    if (subcommand.equalsIgnoreCase(this.plugin.getLang("create.command"))) {
                        this.createCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("list.command"))) {
                        this.listCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("bank.command"))) {
                        this.bankCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("profile.command"))) {
                        this.profileCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("roster.command"))) {
                        this.rosterCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("lookup.command"))) {
                        this.lookupCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("home.command"))) {
                        this.homeCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("leaderboard.command"))) {
                        this.leaderboardCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("alliances.command"))) {
                        this.alliancesCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("rivalries.command"))) {
                        this.rivalriesCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("vitals.command"))) {
                        this.vitalsCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("coords.command"))) {
                        this.coordsCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("stats.command"))) {
                        this.statsCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("ally.command"))) {
                        this.allyCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("rival.command"))) {
                        this.rivalCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("bb.command"))) {
                        this.bbCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("modtag.command"))) {
                        this.modtagCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("toggle.command"))) {
                        this.toggleCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("cape.command"))) {
                        this.capeCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("invite.command"))) {
                        this.inviteCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("kick.command"))) {
                        this.kickCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("trust.command"))) {
                        this.trustCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("untrust.command"))) {
                        this.untrustCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("promote.command"))) {
                        this.promoteCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("demote.command"))) {
                        this.demoteCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("clanff.command"))) {
                        this.clanffCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("ff.command"))) {
                        this.ffCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("resign.command"))) {
                        this.resignCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("disband.command"))) {
                        this.disbandCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("verify.command"))) {
                        this.verifyCommand.execute((CommandSender)player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("ban.command"))) {
                        this.banCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("unban.command"))) {
                        this.unbanCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("reload.command"))) {
                        this.reloadCommand.execute((CommandSender)player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("globalff.command"))) {
                        this.globalffCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("war.command"))) {
                        this.warCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("kills.command"))) {
                        this.killsCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("mostkilled.command"))) {
                        this.mostKilledCommand.execute(player, subargs);
                    } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("setrank.command"))) {
                        this.setRankCommand.execute(player, subargs);
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("does.not.match"));
                    }
                }
            } else if (args.length == 0) {
                this.menuCommand.executeSender(sender);
            } else {
                String subcommand = args[0];
                String[] subargs = Helper.removeFirst(args);
                if (subcommand.equalsIgnoreCase(this.plugin.getLang("verify.command"))) {
                    this.verifyCommand.execute(sender, subargs);
                } else if (subcommand.equalsIgnoreCase(this.plugin.getLang("reload.command"))) {
                    this.reloadCommand.execute(sender, subargs);
                } else {
                    ChatBlock.sendMessage(sender, ChatColor.RED + this.plugin.getLang("does.not.match"));
                }
            }
        }
        catch (Exception ex) {
            SimpleClans.getInstance().getServer().getConsoleSender().sendMessage(ChatColor.RED + MessageFormat.format(this.plugin.getLang("simpleclans.command.failure"), ex.getMessage()));
            for (StackTraceElement el : ex.getStackTrace()) {
                System.out.print(el.toString());
            }
        }
    }

    public void processAccept(Player player) {
        if (this.plugin.getSettingsManager().isBanned(player.getName())) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
            return;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp != null) {
            Clan clan = cp.getClan();
            if (clan.isLeader(player)) {
                if (this.plugin.getRequestManager().hasRequest(clan.getTag())) {
                    if (cp.getVote() == null) {
                        this.plugin.getRequestManager().accept(cp);
                        clan.leaderAnnounce(ChatColor.GREEN + MessageFormat.format(this.plugin.getLang("voted.to.accept"), Helper.capitalize(player.getName())));
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("you.have.already.voted"));
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.accept"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("no.leader.permissions"));
            }
        } else if (this.plugin.getRequestManager().hasRequest(player.getName().toLowerCase())) {
            cp = this.plugin.getClanManager().getCreateClanPlayer(player.getName());
            this.plugin.getRequestManager().accept(cp);
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.accept"));
        }
    }

    public void processDeny(Player player) {
        if (this.plugin.getSettingsManager().isBanned(player.getName())) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
            return;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp != null) {
            Clan clan = cp.getClan();
            if (clan.isLeader(player)) {
                if (this.plugin.getRequestManager().hasRequest(clan.getTag())) {
                    if (cp.getVote() == null) {
                        this.plugin.getRequestManager().deny(cp);
                        clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("has.voted.to.deny"), Helper.capitalize(player.getName())));
                    } else {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("you.have.already.voted"));
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.deny"));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("no.leader.permissions"));
            }
        } else if (this.plugin.getRequestManager().hasRequest(player.getName().toLowerCase())) {
            cp = this.plugin.getClanManager().getCreateClanPlayer(player.getName());
            this.plugin.getRequestManager().deny(cp);
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.deny"));
        }
    }

    public void processMore(Player player) {
        if (this.plugin.getSettingsManager().isBanned(player.getName())) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
            return;
        }
        ChatBlock chatBlock = this.plugin.getStorageManager().getChatBlock(player);
        if (chatBlock != null && chatBlock.size() > 0) {
            chatBlock.sendBlock((CommandSender)player, this.plugin.getSettingsManager().getPageSize());
            if (chatBlock.size() > 0) {
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.sendMessage((CommandSender)player, this.plugin.getSettingsManager().getPageHeadingsColor() + MessageFormat.format(this.plugin.getLang("view.next.page"), this.plugin.getSettingsManager().getCommandMore()));
            }
            ChatBlock.sendBlank((CommandSender)player);
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.more.to.see"));
        }
    }
}

