/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.ClanRequest;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.Request;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.VoteResult;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class RequestManager {
    private SimpleClans plugin;
    private HashMap<String, Request> requests = new HashMap();

    public RequestManager() {
        this.plugin = SimpleClans.getInstance();
        this.askerTask();
    }

    public boolean hasRequest(String tag) {
        return this.requests.containsKey(tag);
    }

    public void addDemoteRequest(ClanPlayer requester, String demotedName, Clan clan) {
        String msg = MessageFormat.format(this.plugin.getLang("asking.for.the.demotion"), Helper.capitalize(requester.getName()), demotedName);
        ClanPlayer demotedTp = this.plugin.getClanManager().getClanPlayer(demotedName.toLowerCase());
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(clan.getLeaders());
        acceptors.remove(demotedTp);
        Request req = new Request(this.plugin, ClanRequest.DEMOTE, acceptors, requester, demotedName, clan, msg);
        this.requests.put(clan.getTag(), req);
        this.ask(req);
    }

    public void addPromoteRequest(ClanPlayer requester, String promotedName, Clan clan) {
        String msg = MessageFormat.format(this.plugin.getLang("asking.for.the.promotion"), Helper.capitalize(requester.getName()), promotedName);
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(clan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.PROMOTE, acceptors, requester, promotedName, clan, msg);
        this.requests.put(clan.getTag(), req);
        this.ask(req);
    }

    public void addDisbandRequest(ClanPlayer requester, Clan clan) {
        String msg = MessageFormat.format(this.plugin.getLang("asking.for.the.deletion"), Helper.capitalize(requester.getName()));
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(clan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.DISBAND, acceptors, requester, null, clan, msg);
        this.requests.put(clan.getTag(), req);
        this.ask(req);
    }

    public void addInviteRequest(ClanPlayer requester, String invitedName, Clan clan) {
        String msg = MessageFormat.format(this.plugin.getLang("inviting.you.to.join"), Helper.capitalize(requester.getName()), clan.getName());
        Request req = new Request(this.plugin, ClanRequest.INVITE, null, requester, invitedName, clan, msg);
        this.requests.put(invitedName.toLowerCase(), req);
        this.ask(req);
    }

    public void addWarStartRequest(ClanPlayer requester, Clan allyClan, Clan requestingClan) {
        String msg = MessageFormat.format(this.plugin.getLang("proposing.war"), Helper.capitalize(requestingClan.getName()), Helper.stripColors(allyClan.getColorTag()));
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(allyClan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.START_WAR, acceptors, requester, allyClan.getTag(), requestingClan, msg);
        this.requests.put(allyClan.getTag(), req);
        this.ask(req);
    }

    public void addWarEndRequest(ClanPlayer requester, Clan rivalClan, Clan requestingClan) {
        String msg = MessageFormat.format(this.plugin.getLang("proposing.to.end.the.war"), Helper.capitalize(requestingClan.getName()), Helper.stripColors(rivalClan.getColorTag()));
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(rivalClan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.END_WAR, acceptors, requester, rivalClan.getTag(), requestingClan, msg);
        this.requests.put(rivalClan.getTag(), req);
        this.ask(req);
    }

    public void addAllyRequest(ClanPlayer requester, Clan allyClan, Clan requestingClan) {
        String msg = MessageFormat.format(this.plugin.getLang("proposing.an.alliance"), Helper.capitalize(requestingClan.getName()), Helper.stripColors(allyClan.getColorTag()));
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(allyClan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.CREATE_ALLY, acceptors, requester, allyClan.getTag(), requestingClan, msg);
        this.requests.put(allyClan.getTag(), req);
        this.ask(req);
    }

    public void addRivalryBreakRequest(ClanPlayer requester, Clan rivalClan, Clan requestingClan) {
        String msg = MessageFormat.format(this.plugin.getLang("proposing.to.end.the.rivalry"), Helper.capitalize(requestingClan.getName()), Helper.stripColors(rivalClan.getColorTag()));
        List<ClanPlayer> acceptors = Helper.stripOffLinePlayers(rivalClan.getLeaders());
        acceptors.remove(requester);
        Request req = new Request(this.plugin, ClanRequest.BREAK_RIVALRY, acceptors, requester, rivalClan.getTag(), requestingClan, msg);
        this.requests.put(rivalClan.getTag(), req);
        this.ask(req);
    }

    public void accept(ClanPlayer cp) {
        Request req = this.requests.get(cp.getTag());
        if (req != null) {
            req.vote(cp.getName(), VoteResult.ACCEPT);
            this.processResults(req);
        } else {
            req = this.requests.get(cp.getCleanName());
            if (req != null) {
                this.processInvite(req, VoteResult.ACCEPT);
            }
        }
    }

    public void deny(ClanPlayer cp) {
        Request req = this.requests.get(cp.getTag());
        if (req != null) {
            req.vote(cp.getName(), VoteResult.DENY);
            this.processResults(req);
        } else {
            req = this.requests.get(cp.getCleanName());
            if (req != null) {
                this.processInvite(req, VoteResult.DENY);
            }
        }
    }

    public void processInvite(Request req, VoteResult vote) {
        Clan clan = req.getClan();
        String invited = req.getTarget();
        if (vote.equals((Object)VoteResult.ACCEPT)) {
            ClanPlayer cp = this.plugin.getClanManager().getCreateClanPlayer(invited);
            clan.addBb(ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("joined.the.clan"), Helper.capitalize(invited)));
            this.plugin.getClanManager().serverAnnounce(MessageFormat.format(this.plugin.getLang("has.joined"), Helper.capitalize(invited), clan.getName()));
            clan.addPlayerToClan(cp);
        } else {
            clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("membership.invitation"), Helper.capitalize(invited)));
        }
        this.requests.remove(req.getTarget().toLowerCase());
    }

    public void processResults(Request req) {
        if (req.getType().equals((Object)ClanRequest.START_WAR)) {
            Clan clan = req.getClan();
            Clan war = this.plugin.getClanManager().getClan(req.getTarget());
            ClanPlayer cp = req.getRequester();
            if (war != null && clan != null) {
                List<String> accepts = req.getAccepts();
                List<String> denies = req.getDenies();
                if (!accepts.isEmpty()) {
                    clan.addWarringClan(war);
                    war.addWarringClan(clan);
                    war.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("you.are.at.war"), Helper.capitalize(war.getName()), clan.getColorTag()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("you.are.at.war"), Helper.capitalize(clan.getName()), war.getColorTag()));
                } else {
                    war.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("denied.war.req"), Helper.capitalize(denies.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("end.war.denied"), Helper.capitalize(war.getName())));
                }
            }
        } else if (req.getType().equals((Object)ClanRequest.END_WAR)) {
            Clan clan = req.getClan();
            Clan war = this.plugin.getClanManager().getClan(req.getTarget());
            ClanPlayer cp = req.getRequester();
            if (war != null && clan != null) {
                List<String> accepts = req.getAccepts();
                List<String> denies = req.getDenies();
                if (!accepts.isEmpty()) {
                    clan.removeWarringClan(war);
                    war.removeWarringClan(clan);
                    war.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("you.are.no.longer.at.war"), Helper.capitalize(accepts.get(0)), clan.getColorTag()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("you.are.no.longer.at.war"), Helper.capitalize(clan.getName()), Helper.capitalize(war.getColorTag())));
                } else {
                    war.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("denied.war.end"), Helper.capitalize(denies.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("end.war.denied"), Helper.capitalize(war.getName())));
                }
            }
        } else if (req.getType().equals((Object)ClanRequest.CREATE_ALLY)) {
            Clan clan = req.getClan();
            Clan ally = this.plugin.getClanManager().getClan(req.getTarget());
            ClanPlayer cp = req.getRequester();
            if (ally != null && clan != null) {
                List<String> accepts = req.getAccepts();
                List<String> denies = req.getDenies();
                if (!accepts.isEmpty()) {
                    clan.addAlly(ally);
                    ally.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("accepted.an.alliance"), Helper.capitalize(accepts.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("created.an.alliance"), Helper.capitalize(cp.getName()), Helper.capitalize(ally.getName())));
                } else {
                    ally.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("denied.an.alliance"), Helper.capitalize(denies.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("the.alliance.was.denied"), Helper.capitalize(ally.getName())));
                }
            }
        } else if (req.getType().equals((Object)ClanRequest.BREAK_RIVALRY)) {
            Clan clan = req.getClan();
            Clan rival = this.plugin.getClanManager().getClan(req.getTarget());
            ClanPlayer cp = req.getRequester();
            if (rival != null && clan != null) {
                List<String> accepts = req.getAccepts();
                List<String> denies = req.getDenies();
                if (!accepts.isEmpty()) {
                    clan.removeRival(rival);
                    rival.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("broken.the.rivalry"), Helper.capitalize(accepts.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("broken.the.rivalry.with"), Helper.capitalize(cp.getName()), Helper.capitalize(rival.getName())));
                } else {
                    rival.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("denied.to.make.peace"), Helper.capitalize(denies.get(0)), clan.getName()));
                    clan.addBb(cp.getName(), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("peace.agreement.denied"), Helper.capitalize(rival.getName())));
                }
            }
        } else if (req.votingFinished()) {
            List<String> denies = req.getDenies();
            if (req.getType().equals((Object)ClanRequest.DEMOTE)) {
                Clan clan = req.getClan();
                String demoted = req.getTarget();
                if (denies.isEmpty()) {
                    clan.addBb(this.plugin.getLang("leaders"), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("demoted.back.to.member"), Helper.capitalize(demoted)));
                    clan.demote(demoted);
                } else {
                    String deniers = Helper.capitalize(Helper.toMessage(Helper.toArray(denies), ", "));
                    clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("denied.demotion"), deniers, demoted));
                }
            } else if (req.getType().equals((Object)ClanRequest.PROMOTE)) {
                Clan clan = req.getClan();
                String promoted = req.getTarget();
                if (denies.isEmpty()) {
                    clan.addBb(this.plugin.getLang("leaders"), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("promoted.to.leader"), Helper.capitalize(promoted)));
                    clan.promote(promoted);
                } else {
                    String deniers = Helper.capitalize(Helper.toMessage(Helper.toArray(denies), ", "));
                    clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("denied.the.promotion"), deniers, promoted));
                }
            } else if (req.getType().equals((Object)ClanRequest.DISBAND)) {
                Clan clan = req.getClan();
                if (denies.isEmpty()) {
                    clan.addBb(this.plugin.getLang("leaders"), ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("has.been.disbanded"), clan.getName()));
                    clan.disband();
                } else {
                    String deniers = Helper.capitalize(Helper.toMessage(Helper.toArray(denies), ", "));
                    clan.leaderAnnounce(ChatColor.RED + MessageFormat.format(this.plugin.getLang("clan.deletion"), deniers));
                }
            }
            req.cleanVotes();
            this.requests.remove(req.getClan().getTag());
        }
    }

    public boolean endPendingRequest(String playerName) {
        block0: for (Request req : new LinkedList<Request>(this.requests.values())) {
            for (ClanPlayer cp : req.getAcceptors()) {
                if (!cp.getName().equalsIgnoreCase(playerName)) continue;
                req.getClan().leaderAnnounce(MessageFormat.format(this.plugin.getLang("signed.off.request.cancelled"), new Object[]{ChatColor.RED + Helper.capitalize(playerName), req.getType()}));
                this.requests.remove(req.getClan().getTag());
                continue block0;
            }
        }
        return false;
    }

    public void askerTask() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Request req : RequestManager.this.requests.values()) {
                    RequestManager.this.ask(req);
                }
            }
        }, 0L, (long)this.plugin.getSettingsManager().getRequestFreqencySecs() * 20L);
    }

    public void ask(Request req) {
        String tag = this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketLeft() + this.plugin.getSettingsManager().getTagDefaultColor() + req.getClan().getColorTag() + this.plugin.getSettingsManager().getClanChatBracketColor() + this.plugin.getSettingsManager().getClanChatTagBracketRight();
        String message = tag + " " + this.plugin.getSettingsManager().getRequestMessageColor() + req.getMsg();
        String options = MessageFormat.format(this.plugin.getLang("accept.or.deny"), ChatBlock.makeEmpty(Helper.stripColors(tag)) + " " + ChatColor.DARK_GREEN + "/" + this.plugin.getSettingsManager().getCommandAccept() + this.plugin.getSettingsManager().getPageHeadingsColor(), ChatColor.DARK_RED + "/" + this.plugin.getSettingsManager().getCommandDeny());
        if (req.getType().equals((Object)ClanRequest.INVITE)) {
            Player player = this.plugin.getServer().getPlayer(req.getTarget());
            if (player != null) {
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.sendMessage((CommandSender)player, message);
                ChatBlock.sendMessage((CommandSender)player, options);
                ChatBlock.sendBlank((CommandSender)player);
            }
        } else {
            for (ClanPlayer cp : req.getAcceptors()) {
                Player player;
                if (cp.getVote() != null || (player = this.plugin.getServer().getPlayer(cp.getName())) == null) continue;
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.sendMessage((CommandSender)player, message);
                ChatBlock.sendMessage((CommandSender)player, options);
                ChatBlock.sendBlank((CommandSender)player);
            }
        }
    }
}

