/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.configuration.file.FileConfiguration;

public final class SettingsManager {
    private boolean disableMessages;
    private String clanChatRankColor;
    private boolean tagBasedClanChat;
    private boolean teleportOnSpawn;
    private boolean dropOnHome;
    private boolean keepOnHome;
    private boolean debugging;
    private SimpleClans plugin = SimpleClans.getInstance();
    private boolean mChatIntegration;
    private boolean pvpOnlywhileInWar;
    private boolean useColorCodeFromPrefix;
    private boolean confirmationForPromote;
    private boolean confirmationForDemote;
    private boolean globalff;
    private boolean showUnverifiedOnList;
    private boolean requireVerification;
    private List<Integer> itemsList;
    private List<String> blacklistedWorlds;
    private List<String> bannedPlayers;
    private List<String> disallowedWords;
    private List<String> disallowedColors;
    private List<String> unRivableClans;
    private int rivalLimitPercent;
    private boolean ePurchaseCreation;
    private boolean ePurchaseVerification;
    private boolean ePurchaseInvite;
    private boolean ePurchaseHomeTeleport;
    private boolean ePurchaseHomeTeleportSet;
    private double eCreationPrice;
    private double eVerificationPrice;
    private double eInvitePrice;
    private double eHomeTeleportPrice;
    private double eHomeTeleportPriceSet;
    private String alertUrl;
    private boolean inGameTags;
    private boolean inGameTagsColored;
    private boolean clanCapes;
    private String defaultCapeUrl;
    private String serverName;
    private boolean chatTags;
    private int purgeClan;
    private int purgeUnverified;
    private int purgePlayers;
    private int requestFreqencySecs;
    private String requestMessageColor;
    private int pageSize;
    private String pageSep;
    private String pageHeadingsColor;
    private String pageSubTitleColor;
    private String pageLeaderColor;
    private String pageTrustedColor;
    private String pageUnTrustedColor;
    private boolean bbShowOnLogin;
    private int bbSize;
    private String bbColor;
    private String bbAccentColor;
    private String commandClan;
    private String commandAlly;
    private String commandGlobal;
    private String commandMore;
    private String commandDeny;
    private String commandAccept;
    private int clanMinSizeToAlly;
    private int clanMinSizeToRival;
    private int clanMinLength;
    private int clanMaxLength;
    private String pageClanNameColor;
    private int tagMinLength;
    private int tagMaxLength;
    private String tagDefaultColor;
    private String tagSeparator;
    private String tagSeparatorColor;
    private String tagBracketLeft;
    private String tagBracketRight;
    private String tagBracketColor;
    private boolean clanTrustByDefault;
    private boolean allyChatEnable;
    private String allyChatMessageColor;
    private String allyChatNameColor;
    private String allyChatTagColor;
    private String allyChatTagBracketLeft;
    private String allyChatTagBracketRight;
    private String allyChatBracketColor;
    private String allyChatPlayerBracketLeft;
    private String allyChatPlayerBracketRight;
    private boolean clanChatEnable;
    private String clanChatAnnouncementColor;
    private String clanChatMessageColor;
    private String clanChatNameColor;
    private String clanChatTagBracketLeft;
    private String clanChatTagBracketRight;
    private String clanChatBracketColor;
    private String clanChatPlayerBracketLeft;
    private String clanChatPlayerBracketRight;
    private boolean clanFFOnByDefault;
    private double kwRival;
    private double kwNeutral;
    private double kwCivilian;
    private boolean useMysql;
    private String host;
    private String database;
    private String username;
    private String password;
    private boolean safeCivilians;
    private File main;
    private FileConfiguration config = this.plugin.getConfig();
    private boolean compatMode;
    private boolean homebaseSetOnce;
    private int waitSecs;
    private boolean enableAutoGroups;
    private boolean moneyperkill;
    private double KDRMultipliesPerKill;
    private boolean teleportBlocks;
    private boolean AutoGroupGroupName;
    private boolean tamableMobsSharing;
    private int strifeLimit;
    private boolean autoWar;

    public SettingsManager() {
        this.main = new File(this.plugin.getDataFolder() + File.separator + "config.yml");
        this.load();
    }

    public void load() {
        boolean exists = this.main.exists();
        if (exists) {
            try {
                this.getConfig().options().copyDefaults(true);
                this.getConfig().load(this.main);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getConfig().options().copyDefaults(true);
        }
        this.disableMessages = this.getConfig().getBoolean("settings.disable-messages");
        this.teleportOnSpawn = this.getConfig().getBoolean("settings.teleport-home-on-spawn");
        this.dropOnHome = this.getConfig().getBoolean("settings.drop-items-on-clan-home");
        this.keepOnHome = this.getConfig().getBoolean("settings.keep-items-on-clan-home");
        this.itemsList = this.getConfig().getIntegerList("settings.item-list");
        this.debugging = this.getConfig().getBoolean("settings.show-debug-info");
        this.mChatIntegration = this.getConfig().getBoolean("settings.mchat-integration");
        this.pvpOnlywhileInWar = this.getConfig().getBoolean("settings.pvp-only-while-at-war");
        this.enableAutoGroups = this.getConfig().getBoolean("settings.enable-auto-groups");
        this.useColorCodeFromPrefix = this.getConfig().getBoolean("settings.use-colorcode-from-prefix-for-name");
        this.bannedPlayers = this.getConfig().getStringList("settings.banned-players");
        this.compatMode = this.getConfig().getBoolean("settings.chat-compatibility-mode");
        this.disallowedColors = this.getConfig().getStringList("settings.disallowed-tag-colors");
        this.blacklistedWorlds = this.getConfig().getStringList("settings.blacklisted-worlds");
        this.disallowedWords = this.getConfig().getStringList("settings.disallowed-tags");
        this.unRivableClans = this.getConfig().getStringList("settings.unrivable-clans");
        this.showUnverifiedOnList = this.getConfig().getBoolean("settings.show-unverified-on-list");
        this.requireVerification = this.getConfig().getBoolean("settings.new-clan-verification-required");
        this.serverName = this.getConfig().getString("settings.server-name");
        this.chatTags = this.getConfig().getBoolean("settings.display-chat-tags");
        this.rivalLimitPercent = this.getConfig().getInt("settings.rival-limit-percent");
        this.ePurchaseCreation = this.getConfig().getBoolean("economy.purchase-clan-create");
        this.ePurchaseVerification = this.getConfig().getBoolean("economy.purchase-clan-verify");
        this.ePurchaseInvite = this.getConfig().getBoolean("economy.purchase-clan-invite");
        this.ePurchaseHomeTeleport = this.getConfig().getBoolean("economy.purchase-home-teleport");
        this.ePurchaseHomeTeleportSet = this.getConfig().getBoolean("economy.purchase-home-teleport-set");
        this.eCreationPrice = this.getConfig().getDouble("economy.creation-price");
        this.eVerificationPrice = this.getConfig().getDouble("economy.verification-price");
        this.eInvitePrice = this.getConfig().getDouble("economy.invite-price");
        this.eHomeTeleportPrice = this.getConfig().getDouble("economy.home-teleport-price");
        this.eHomeTeleportPriceSet = this.getConfig().getDouble("economy.home-teleport-set-price");
        this.alertUrl = this.getConfig().getString("spout.alert-url");
        this.inGameTags = this.getConfig().getBoolean("spout.in-game-tags");
        this.inGameTagsColored = this.getConfig().getBoolean("spout.in-game-tags-colored");
        this.clanCapes = this.getConfig().getBoolean("spout.enable-clan-capes");
        this.defaultCapeUrl = this.getConfig().getString("spout.default-cape-url");
        this.purgeClan = this.getConfig().getInt("purge.inactive-clan-days");
        this.purgeUnverified = this.getConfig().getInt("purge.unverified-clan-days");
        this.purgePlayers = this.getConfig().getInt("purge.inactive-player-data-days");
        this.requestFreqencySecs = this.getConfig().getInt("request.ask-frequency-secs");
        this.requestMessageColor = this.getConfig().getString("request.message-color");
        this.pageSize = this.getConfig().getInt("page.size");
        this.pageSep = this.getConfig().getString("page.separator");
        this.pageSubTitleColor = this.getConfig().getString("page.subtitle-color");
        this.pageHeadingsColor = this.getConfig().getString("page.headings-color");
        this.pageLeaderColor = this.getConfig().getString("page.leader-color");
        this.pageTrustedColor = this.getConfig().getString("page.trusted-color");
        this.pageUnTrustedColor = this.getConfig().getString("page.untrusted-color");
        this.pageClanNameColor = this.getConfig().getString("page.clan-name-color");
        this.bbShowOnLogin = this.getConfig().getBoolean("bb.show-on-login");
        this.bbSize = this.getConfig().getInt("bb.size");
        this.bbColor = this.getConfig().getString("bb.color");
        this.bbAccentColor = this.getConfig().getString("bb.accent-color");
        this.commandClan = this.getConfig().getString("commands.clan");
        this.commandAlly = this.getConfig().getString("commands.ally");
        this.commandGlobal = this.getConfig().getString("commands.global");
        this.commandMore = this.getConfig().getString("commands.more");
        this.commandDeny = this.getConfig().getString("commands.deny");
        this.commandAccept = this.getConfig().getString("commands.accept");
        this.homebaseSetOnce = this.getConfig().getBoolean("clan.homebase-can-be-set-only-once");
        this.waitSecs = this.getConfig().getInt("clan.homebase-teleport-wait-secs");
        this.confirmationForPromote = this.getConfig().getBoolean("clan.confirmation-for-demote");
        this.confirmationForDemote = this.getConfig().getBoolean("clan.confirmation-for-promote");
        this.clanTrustByDefault = this.getConfig().getBoolean("clan.trust-members-by-default");
        this.clanMinSizeToAlly = this.getConfig().getInt("clan.min-size-to-set-ally");
        this.clanMinSizeToRival = this.getConfig().getInt("clan.min-size-to-set-rival");
        this.clanMinLength = this.getConfig().getInt("clan.min-length");
        this.clanMaxLength = this.getConfig().getInt("clan.max-length");
        this.clanFFOnByDefault = this.getConfig().getBoolean("clan.ff-on-by-default");
        this.tagMinLength = this.getConfig().getInt("tag.min-length");
        this.tagMaxLength = this.getConfig().getInt("tag.max-length");
        this.tagDefaultColor = this.getConfig().getString("tag.default-color");
        this.tagSeparator = this.getConfig().getString("tag.separator.char");
        this.tagSeparatorColor = this.getConfig().getString("tag.separator.color");
        this.tagBracketColor = this.getConfig().getString("tag.bracket.color");
        this.tagBracketLeft = this.getConfig().getString("tag.bracket.left");
        this.tagBracketRight = this.getConfig().getString("tag.bracket.right");
        this.allyChatEnable = this.getConfig().getBoolean("allychat.enable");
        this.allyChatMessageColor = this.getConfig().getString("allychat.message-color");
        this.allyChatTagColor = this.getConfig().getString("allychat.tag-color");
        this.allyChatNameColor = this.getConfig().getString("allychat.name-color");
        this.allyChatBracketColor = this.getConfig().getString("allychat.tag-bracket.color");
        this.allyChatTagBracketLeft = this.getConfig().getString("allychat.tag-bracket.left");
        this.allyChatTagBracketRight = this.getConfig().getString("allychat.tag-bracket.right");
        this.allyChatPlayerBracketLeft = this.getConfig().getString("allychat.player-bracket.left");
        this.allyChatPlayerBracketRight = this.getConfig().getString("allychat.player-bracket.right");
        this.clanChatEnable = this.getConfig().getBoolean("clanchat.enable");
        this.tagBasedClanChat = this.getConfig().getBoolean("clanchat.tag-based-clan-chat");
        this.clanChatAnnouncementColor = this.getConfig().getString("clanchat.announcement-color");
        this.clanChatMessageColor = this.getConfig().getString("clanchat.message-color");
        this.clanChatNameColor = this.getConfig().getString("clanchat.name-color");
        this.clanChatRankColor = this.getConfig().getString("clanchat.rank.color");
        this.clanChatBracketColor = this.getConfig().getString("clanchat.tag-bracket.color");
        this.clanChatTagBracketLeft = this.getConfig().getString("clanchat.tag-bracket.left");
        this.clanChatTagBracketRight = this.getConfig().getString("clanchat.tag-bracket.right");
        this.clanChatPlayerBracketLeft = this.getConfig().getString("clanchat.player-bracket.left");
        this.clanChatPlayerBracketRight = this.getConfig().getString("clanchat.player-bracket.right");
        this.kwRival = this.getConfig().getDouble("kill-weights.rival");
        this.kwNeutral = this.getConfig().getDouble("kill-weights.neutral");
        this.kwCivilian = this.getConfig().getDouble("kill-weights.civilian");
        this.useMysql = this.getConfig().getBoolean("mysql.enable");
        this.host = this.getConfig().getString("mysql.host");
        this.database = this.getConfig().getString("mysql.database");
        this.username = this.getConfig().getString("mysql.username");
        this.password = this.getConfig().getString("mysql.password");
        this.safeCivilians = this.getConfig().getBoolean("safe-civilians");
        this.moneyperkill = this.getConfig().getBoolean("economy.money-per-kill");
        this.KDRMultipliesPerKill = this.getConfig().getDouble("economy.money-per-kill-kdr-multipier");
        this.teleportBlocks = this.getConfig().getBoolean("settings.teleport-blocks");
        this.AutoGroupGroupName = this.getConfig().getBoolean("permissions.auto-group-groupname");
        this.tamableMobsSharing = this.getConfig().getBoolean("settings.tameable-mobs-sharing");
        this.strifeLimit = this.getConfig().getInt("war.strife-limit");
        this.autoWar = this.getConfig().getBoolean("war.auto-war-start");
        this.save();
    }

    public void save() {
        try {
            this.getConfig().save(this.main);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isItemInList(int typeId) {
        return this.itemsList.contains(typeId);
    }

    public boolean isBlacklistedWorld(String world) {
        for (String w : this.blacklistedWorlds) {
            if (!w.equalsIgnoreCase(world)) continue;
            return true;
        }
        return false;
    }

    public boolean isDisallowedWord(String word) {
        for (String w : this.disallowedWords) {
            if (!w.equalsIgnoreCase(word)) continue;
            return true;
        }
        return word.equalsIgnoreCase("clan") || word.equalsIgnoreCase(this.commandMore) || word.equalsIgnoreCase(this.commandDeny) || word.equalsIgnoreCase(this.commandAccept);
    }

    public boolean hasDisallowedColor(String str) {
        for (String c : this.getDisallowedColors()) {
            if (!str.contains("&" + c)) continue;
            return true;
        }
        return false;
    }

    public String getDisallowedColorString() {
        String out = "";
        for (String c : this.getDisallowedColors()) {
            out = out + c + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public boolean isUnrivable(String tag) {
        for (String t : this.getunRivableClans()) {
            if (!t.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isBanned(String playerName) {
        for (String pl : this.getBannedPlayers()) {
            if (!pl.equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    public void addBanned(String playerName) {
        if (!this.bannedPlayers.contains(playerName)) {
            this.getBannedPlayers().add(playerName);
        }
        this.save();
    }

    public void removeBanned(String playerName) {
        if (this.getBannedPlayers().contains(playerName)) {
            this.getBannedPlayers().remove(playerName);
        }
        this.save();
    }

    public SimpleClans getPlugin() {
        return this.plugin;
    }

    public boolean isRequireVerification() {
        return this.requireVerification;
    }

    public List<String> getBannedPlayers() {
        return Collections.unmodifiableList(this.bannedPlayers);
    }

    public List<String> getDisallowedColors() {
        return Collections.unmodifiableList(this.disallowedColors);
    }

    public List<String> getunRivableClans() {
        return Collections.unmodifiableList(this.unRivableClans);
    }

    public int getRivalLimitPercent() {
        return this.rivalLimitPercent;
    }

    public String getAlertUrl() {
        return this.alertUrl;
    }

    public boolean isInGameTags() {
        return this.inGameTags;
    }

    public boolean isClanCapes() {
        return this.clanCapes;
    }

    public String getDefaultCapeUrl() {
        return this.defaultCapeUrl;
    }

    public String getServerName() {
        return Helper.parseColors(this.serverName);
    }

    public boolean isChatTags() {
        return this.chatTags;
    }

    public int getPurgeClan() {
        return this.purgeClan;
    }

    public int getPurgeUnverified() {
        return this.purgeUnverified;
    }

    public int getPurgePlayers() {
        return this.purgePlayers;
    }

    public int getRequestFreqencySecs() {
        return this.requestFreqencySecs;
    }

    public String getRequestMessageColor() {
        return Helper.toColor(this.requestMessageColor);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getPageSep() {
        return this.pageSep;
    }

    public String getPageHeadingsColor() {
        return Helper.toColor(this.pageHeadingsColor);
    }

    public String getPageSubTitleColor() {
        return Helper.toColor(this.pageSubTitleColor);
    }

    public String getPageLeaderColor() {
        return Helper.toColor(this.pageLeaderColor);
    }

    public int getBbSize() {
        return this.bbSize;
    }

    public String getBbColor() {
        return Helper.toColor(this.bbColor);
    }

    public String getBbAccentColor() {
        return Helper.toColor(this.bbAccentColor);
    }

    public String getCommandClan() {
        return this.commandClan;
    }

    public String getCommandMore() {
        return this.commandMore;
    }

    public String getCommandDeny() {
        return this.commandDeny;
    }

    public String getCommandAccept() {
        return this.commandAccept;
    }

    public int getClanMinSizeToAlly() {
        return this.clanMinSizeToAlly;
    }

    public int getClanMinSizeToRival() {
        return this.clanMinSizeToRival;
    }

    public int getClanMinLength() {
        return this.clanMinLength;
    }

    public int getClanMaxLength() {
        return this.clanMaxLength;
    }

    public String getPageClanNameColor() {
        return Helper.toColor(this.pageClanNameColor);
    }

    public int getTagMinLength() {
        return this.tagMinLength;
    }

    public int getTagMaxLength() {
        return this.tagMaxLength;
    }

    public String getTagDefaultColor() {
        return Helper.toColor(this.tagDefaultColor);
    }

    public String getTagSeparator() {
        if (this.tagSeparator.equals(" .")) {
            return ".";
        }
        if (this.tagSeparator == null) {
            return "";
        }
        return this.tagSeparator;
    }

    public String getTagSeparatorColor() {
        return Helper.toColor(this.tagSeparatorColor);
    }

    public String getClanChatAnnouncementColor() {
        return Helper.toColor(this.clanChatAnnouncementColor);
    }

    public String getClanChatMessageColor() {
        return Helper.toColor(this.clanChatMessageColor);
    }

    public String getClanChatNameColor() {
        return Helper.toColor(this.clanChatNameColor);
    }

    public String getClanChatTagBracketLeft() {
        return this.clanChatTagBracketLeft;
    }

    public String getClanChatTagBracketRight() {
        return this.clanChatTagBracketRight;
    }

    public String getClanChatBracketColor() {
        return Helper.toColor(this.clanChatBracketColor);
    }

    public String getClanChatPlayerBracketLeft() {
        return this.clanChatPlayerBracketLeft;
    }

    public String getClanChatPlayerBracketRight() {
        return this.clanChatPlayerBracketRight;
    }

    public double getKwRival() {
        return this.kwRival;
    }

    public double getKwNeutral() {
        return this.kwNeutral;
    }

    public double getKwCivilian() {
        return this.kwCivilian;
    }

    public boolean isUseMysql() {
        return this.useMysql;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isInGameTagsColored() {
        return this.inGameTagsColored;
    }

    public boolean isShowUnverifiedOnList() {
        return this.showUnverifiedOnList;
    }

    public boolean isClanTrustByDefault() {
        return this.clanTrustByDefault;
    }

    public String getPageTrustedColor() {
        return Helper.toColor(this.pageTrustedColor);
    }

    public String getPageUnTrustedColor() {
        return Helper.toColor(this.pageUnTrustedColor);
    }

    public boolean isGlobalff() {
        return this.globalff;
    }

    public void setGlobalff(boolean globalff) {
        this.globalff = globalff;
    }

    public boolean getClanChatEnable() {
        return this.clanChatEnable;
    }

    public String getTagBracketLeft() {
        return this.tagBracketLeft;
    }

    public String getTagBracketRight() {
        return this.tagBracketRight;
    }

    public String getTagBracketColor() {
        return Helper.toColor(this.tagBracketColor);
    }

    public boolean isePurchaseCreation() {
        return this.ePurchaseCreation;
    }

    public boolean isePurchaseVerification() {
        return this.ePurchaseVerification;
    }

    public boolean isePurchaseInvite() {
        return this.ePurchaseInvite;
    }

    public double getCreationPrice() {
        return this.eCreationPrice;
    }

    public double getVerificationPrice() {
        return this.eVerificationPrice;
    }

    public double getInvitePrice() {
        return this.eInvitePrice;
    }

    public boolean isBbShowOnLogin() {
        return this.bbShowOnLogin;
    }

    public boolean getSafeCivilians() {
        return this.safeCivilians;
    }

    public boolean isConfirmationForPromote() {
        return this.confirmationForPromote;
    }

    public boolean isConfirmationForDemote() {
        return this.confirmationForDemote;
    }

    public boolean isUseColorCodeFromPrefix() {
        return this.useColorCodeFromPrefix;
    }

    public String getCommandAlly() {
        return this.commandAlly;
    }

    public boolean isAllyChatEnable() {
        return this.allyChatEnable;
    }

    public String getAllyChatMessageColor() {
        return Helper.toColor(this.allyChatMessageColor);
    }

    public String getAllyChatNameColor() {
        return Helper.toColor(this.allyChatNameColor);
    }

    public String getAllyChatTagBracketLeft() {
        return this.allyChatTagBracketLeft;
    }

    public String getAllyChatTagBracketRight() {
        return this.allyChatTagBracketRight;
    }

    public String getAllyChatBracketColor() {
        return Helper.toColor(this.allyChatBracketColor);
    }

    public String getAllyChatPlayerBracketLeft() {
        return this.allyChatPlayerBracketLeft;
    }

    public String getAllyChatPlayerBracketRight() {
        return this.allyChatPlayerBracketRight;
    }

    public String getCommandGlobal() {
        return this.commandGlobal;
    }

    public String getAllyChatTagColor() {
        return Helper.toColor(this.allyChatTagColor);
    }

    public boolean isClanFFOnByDefault() {
        return this.clanFFOnByDefault;
    }

    public boolean isCompatMode() {
        return this.compatMode;
    }

    public void setCompatMode(boolean compatMode) {
        this.compatMode = compatMode;
    }

    public boolean isHomebaseSetOnce() {
        return this.homebaseSetOnce;
    }

    public int getWaitSecs() {
        return this.waitSecs;
    }

    public void setWaitSecs(int waitSecs) {
        this.waitSecs = waitSecs;
    }

    public boolean isEnableAutoGroups() {
        return this.enableAutoGroups;
    }

    public boolean isPvpOnlywhileInWar() {
        return this.pvpOnlywhileInWar;
    }

    public boolean ismChatIntegration() {
        return this.mChatIntegration;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public boolean isKeepOnHome() {
        return this.keepOnHome;
    }

    public boolean isDropOnHome() {
        return this.dropOnHome;
    }

    public List<Integer> getItemsList() {
        return Collections.unmodifiableList(this.itemsList);
    }

    public boolean isTeleportOnSpawn() {
        return this.teleportOnSpawn;
    }

    public boolean isTagBasedClanChat() {
        return this.tagBasedClanChat;
    }

    public String getClanChatRankColor() {
        return Helper.toColor(this.clanChatRankColor);
    }

    public boolean isePurchaseHomeTeleport() {
        return this.ePurchaseHomeTeleport;
    }

    public double getHomeTeleportPrice() {
        return this.eHomeTeleportPrice;
    }

    public boolean isePurchaseHomeTeleportSet() {
        return this.ePurchaseHomeTeleportSet;
    }

    public double getHomeTeleportPriceSet() {
        return this.eHomeTeleportPriceSet;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean isMoneyPerKill() {
        return this.moneyperkill;
    }

    public double getKDRMultipliesPerKill() {
        return this.KDRMultipliesPerKill;
    }

    public boolean isTeleportBlocks() {
        return this.teleportBlocks;
    }

    public boolean isAutoGroupGroupName() {
        return this.AutoGroupGroupName;
    }

    public boolean isTamableMobsSharing() {
        return this.tamableMobsSharing;
    }

    public int getStrifeLimit() {
        return this.strifeLimit;
    }

    public boolean isAutoWar() {
        return this.autoWar;
    }

    public boolean isDisableMessages() {
        return this.disableMessages;
    }
}

