/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.storage.DBCore;
import net.sacredlabyrinth.phaed.simpleclans.storage.MySQLCore;
import net.sacredlabyrinth.phaed.simpleclans.storage.SQLiteCore;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class StorageManager {
    private SimpleClans plugin;
    private DBCore core;
    private HashMap<String, ChatBlock> chatBlocks = new HashMap();

    public StorageManager() {
        this.plugin = SimpleClans.getInstance();
        this.initiateDB();
        this.updateDatabase();
        this.importFromDatabase();
    }

    public ChatBlock getChatBlock(Player player) {
        return this.chatBlocks.get(player.getName());
    }

    public void addChatBlock(CommandSender player, ChatBlock cb) {
        this.chatBlocks.put(player.getName(), cb);
    }

    public void initiateDB() {
        if (this.plugin.getSettingsManager().isUseMysql()) {
            this.core = new MySQLCore(this.plugin.getSettingsManager().getHost(), this.plugin.getSettingsManager().getDatabase(), this.plugin.getSettingsManager().getUsername(), this.plugin.getSettingsManager().getPassword());
            if (this.core.checkConnection().booleanValue()) {
                String query;
                SimpleClans.log("[SimpleClans] " + this.plugin.getLang("mysql.connection.successful"), new Object[0]);
                if (!this.core.existsTable("sc_clans").booleanValue()) {
                    SimpleClans.log("Creating table: sc_clans", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_clans` ( `id` bigint(20) NOT NULL auto_increment, `verified` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `color_tag` varchar(25) NOT NULL, `name` varchar(100) NOT NULL, `friendly_fire` tinyint(1) default '0', `founded` bigint NOT NULL, `last_used` bigint NOT NULL, `packed_allies` text NOT NULL, `packed_rivals` text NOT NULL, `packed_bb` mediumtext NOT NULL, `cape_url` varchar(255) NOT NULL, `flags` text NOT NULL, `balance` double(64,2), PRIMARY KEY  (`id`), UNIQUE KEY `uq_simpleclans_1` (`tag`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_players").booleanValue()) {
                    SimpleClans.log("Creating table: sc_players", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_players` ( `id` bigint(20) NOT NULL auto_increment, `name` varchar(16) NOT NULL, `leader` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `friendly_fire` tinyint(1) default '0', `neutral_kills` int(11) default NULL, `rival_kills` int(11) default NULL, `civilian_kills` int(11) default NULL, `deaths` int(11) default NULL, `last_seen` bigint NOT NULL, `join_date` bigint NOT NULL, `trusted` tinyint(1) default '0', `flags` text NOT NULL, `packed_past_clans` text, PRIMARY KEY  (`id`), UNIQUE KEY `uq_sc_players_1` (`name`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_kills").booleanValue()) {
                    SimpleClans.log("Creating table: sc_kills", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_kills` ( `kill_id` bigint(20) NOT NULL auto_increment, `attacker` varchar(16) NOT NULL, `attacker_tag` varchar(16) NOT NULL, `victim` varchar(16) NOT NULL, `victim_tag` varchar(16) NOT NULL, `kill_type` varchar(1) NOT NULL, PRIMARY KEY  (`kill_id`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_war").booleanValue()) {
                    SimpleClans.log("Creating table: sc_war", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_war` ( `clan_name` varchar(16) NOT NULL, PRIMARY KEY  (`clan_name`));";
                    this.core.execute(query);
                }
            } else {
                SimpleClans.getInstance().getServer().getConsoleSender().sendMessage("[SimpleClans] " + ChatColor.RED + this.plugin.getLang("mysql.connection.failed"));
            }
        } else {
            this.core = new SQLiteCore(this.plugin.getDataFolder().getPath());
            if (this.core.checkConnection().booleanValue()) {
                String query;
                SimpleClans.log("[SimpleClans] " + this.plugin.getLang("sqlite.connection.successful"), new Object[0]);
                if (!this.core.existsTable("sc_clans").booleanValue()) {
                    SimpleClans.log("Creating table: sc_clans", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_clans` ( `id` bigint(20), `verified` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `color_tag` varchar(25) NOT NULL, `name` varchar(100) NOT NULL, `friendly_fire` tinyint(1) default '0', `founded` bigint NOT NULL, `last_used` bigint NOT NULL, `packed_allies` text NOT NULL, `packed_rivals` text NOT NULL, `packed_bb` mediumtext NOT NULL, `cape_url` varchar(255) NOT NULL, `flags` text NOT NULL, `balance` double(64,2) default 0.0,  PRIMARY KEY  (`id`), UNIQUE (`tag`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_players").booleanValue()) {
                    SimpleClans.log("Creating table: sc_players", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_players` ( `id` bigint(20), `name` varchar(16) NOT NULL, `leader` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `friendly_fire` tinyint(1) default '0', `neutral_kills` int(11) default NULL, `rival_kills` int(11) default NULL, `civilian_kills` int(11) default NULL, `deaths` int(11) default NULL, `last_seen` bigint NOT NULL, `join_date` bigint NOT NULL, `trusted` tinyint(1) default '0', `flags` text NOT NULL, `packed_past_clans` text, PRIMARY KEY  (`id`), UNIQUE (`name`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_kills").booleanValue()) {
                    SimpleClans.log("Creating table: sc_kills", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_kills` ( `kill_id` bigint(20), `attacker` varchar(16) NOT NULL, `attacker_tag` varchar(16) NOT NULL, `victim` varchar(16) NOT NULL, `victim_tag` varchar(16) NOT NULL, `kill_type` varchar(1) NOT NULL, PRIMARY KEY  (`kill_id`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_war").booleanValue()) {
                    SimpleClans.log("Creating table: sc_war", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_war` ( `clan_name` varchar(16) NOT NULL, PRIMARY KEY  (`clan_name`));";
                    this.core.execute(query);
                }
            } else {
                SimpleClans.getInstance().getServer().getConsoleSender().sendMessage("[SimpleClans] " + ChatColor.RED + this.plugin.getLang("sqlite.connection.failed"));
            }
        }
    }

    public void closeConnection() {
        this.core.close();
    }

    public void importFromDatabase() {
        this.plugin.getClanManager().cleanData();
        List<Clan> clans = this.retrieveClans();
        this.purgeClans(clans);
        for (Clan clan : clans) {
            this.plugin.getClanManager().importClan(clan);
        }
        for (Clan clan : clans) {
            clan.validateWarring();
        }
        if (clans.size() > 0) {
            SimpleClans.log(MessageFormat.format("[SimpleClans] " + this.plugin.getLang("clans"), clans.size()), new Object[0]);
        }
        List<ClanPlayer> cps = this.retrieveClanPlayers();
        this.purgeClanPlayers(cps);
        for (ClanPlayer cp : cps) {
            Clan tm = cp.getClan();
            if (tm != null) {
                tm.importMember(cp);
            }
            this.plugin.getClanManager().importClanPlayer(cp);
        }
        if (cps.size() > 0) {
            SimpleClans.log(MessageFormat.format("[SimpleClans] " + this.plugin.getLang("clan.players"), cps.size()), new Object[0]);
        }
    }

    private void purgeClans(List<Clan> clans) {
        ArrayList<Clan> purge = new ArrayList<Clan>();
        for (Clan clan : clans) {
            if (clan.isVerified()) {
                if (clan.getInactiveDays() <= this.plugin.getSettingsManager().getPurgeClan()) continue;
                purge.add(clan);
                continue;
            }
            if (clan.getInactiveDays() <= this.plugin.getSettingsManager().getPurgeUnverified()) continue;
            purge.add(clan);
        }
        for (Clan clan : purge) {
            SimpleClans.log("[SimpleClans] " + MessageFormat.format(this.plugin.getLang("purging.clan"), clan.getName()), new Object[0]);
            this.deleteClan(clan);
            clans.remove(clan);
        }
    }

    private void purgeClanPlayers(List<ClanPlayer> cps) {
        ArrayList<ClanPlayer> purge = new ArrayList<ClanPlayer>();
        for (ClanPlayer cp : cps) {
            if (cp.getInactiveDays() <= this.plugin.getSettingsManager().getPurgePlayers() || cp.isLeader()) continue;
            purge.add(cp);
        }
        for (ClanPlayer cp : purge) {
            SimpleClans.log("[SimpleClans] " + MessageFormat.format(this.plugin.getLang("purging.player.data"), cp.getName()), new Object[0]);
            this.deleteClanPlayer(cp);
            cps.remove(cp);
        }
    }

    public List<Clan> retrieveClans() {
        ArrayList<Clan> out = new ArrayList<Clan>();
        String query = "SELECT * FROM  `sc_clans`;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        boolean verified = res.getBoolean("verified");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        String tag = res.getString("tag");
                        String color_tag = Helper.parseColors(res.getString("color_tag"));
                        String name = res.getString("name");
                        String packed_allies = res.getString("packed_allies");
                        String packed_rivals = res.getString("packed_rivals");
                        String packed_bb = res.getString("packed_bb");
                        String cape_url = res.getString("cape_url");
                        String flags = res.getString("flags");
                        long founded = res.getLong("founded");
                        long last_used = res.getLong("last_used");
                        double balance = res.getDouble("balance");
                        if (founded == 0L) {
                            founded = new Date().getTime();
                        }
                        if (last_used == 0L) {
                            last_used = new Date().getTime();
                        }
                        Clan clan = new Clan();
                        clan.setFlags(flags);
                        clan.setVerified(verified);
                        clan.setFriendlyFire(friendly_fire);
                        clan.setTag(tag);
                        clan.setColorTag(color_tag);
                        clan.setName(name);
                        clan.setPackedAllies(packed_allies);
                        clan.setPackedRivals(packed_rivals);
                        clan.setPackedBb(packed_bb);
                        clan.setCapeUrl(cape_url);
                        clan.setFounded(founded);
                        clan.setLastUsed(last_used);
                        clan.setBalance(balance);
                        out.add(clan);
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public Integer retrieveStrifes(Clan attackerclan, Clan victimclan) {
        int strifes = 0;
        String query = null;
        String row = null;
        if (this.core.existsColumn("sc_war", attackerclan.getTag()).booleanValue()) {
            query = "SELECT * FROM `sc_war` WHERE `sc_war`.`clan_name` =  '" + victimclan.getTag() + "';";
            row = attackerclan.getTag();
        } else if (this.core.existsColumn("sc_war", victimclan.getTag()).booleanValue()) {
            row = victimclan.getTag();
            query = "SELECT * FROM `sc_war` WHERE `sc_war`.`clan_name` =  '" + attackerclan.getTag() + "';";
        }
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        strifes = res.getInt(row);
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            SimpleClans.getLog().severe(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return strifes;
    }

    public List<ClanPlayer> retrieveClanPlayers() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        String query = "SELECT * FROM  `sc_players`;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        Clan clan;
                        String name = res.getString("name");
                        String tag = res.getString("tag");
                        boolean leader = res.getBoolean("leader");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        boolean trusted = res.getBoolean("trusted");
                        int neutral_kills = res.getInt("neutral_kills");
                        int rival_kills = res.getInt("rival_kills");
                        int civilian_kills = res.getInt("civilian_kills");
                        int deaths = res.getInt("deaths");
                        long last_seen = res.getLong("last_seen");
                        long join_date = res.getLong("join_date");
                        String flags = res.getString("flags");
                        String packed_past_clans = Helper.parseColors(res.getString("packed_past_clans"));
                        if (last_seen == 0L) {
                            last_seen = new Date().getTime();
                        }
                        if (join_date == 0L) {
                            join_date = new Date().getTime();
                        }
                        ClanPlayer cp = new ClanPlayer();
                        cp.setFlags(flags);
                        cp.setName(name);
                        cp.setLeader(leader);
                        cp.setFriendlyFire(friendly_fire);
                        cp.setNeutralKills(neutral_kills);
                        cp.setRivalKills(rival_kills);
                        cp.setCivilianKills(civilian_kills);
                        cp.setDeaths(deaths);
                        cp.setLastSeen(last_seen);
                        cp.setJoinDate(join_date);
                        cp.setPackedPastClans(packed_past_clans);
                        cp.setTrusted(leader || trusted);
                        if (!tag.isEmpty() && (clan = SimpleClans.getInstance().getClanManager().getClan(tag)) != null) {
                            cp.setClan(clan);
                        }
                        out.add(cp);
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public void insertClan(Clan clan) {
        String query = "INSERT INTO `sc_clans` (  `verified`, `tag`, `color_tag`, `name`, `friendly_fire`, `founded`, `last_used`, `packed_allies`, `packed_rivals`, `packed_bb`, `cape_url`, `flags`, `balance`) ";
        String values = "VALUES ( " + (clan.isVerified() ? 1 : 0) + ",'" + Helper.escapeQuotes(clan.getTag()) + "','" + Helper.escapeQuotes(clan.getColorTag()) + "','" + Helper.escapeQuotes(clan.getName()) + "'," + (clan.isFriendlyFire() ? 1 : 0) + ",'" + clan.getFounded() + "','" + clan.getLastUsed() + "','" + Helper.escapeQuotes(clan.getPackedAllies()) + "','" + Helper.escapeQuotes(clan.getPackedRivals()) + "','" + Helper.escapeQuotes(clan.getPackedBb()) + "','" + Helper.escapeQuotes(clan.getCapeUrl()) + "','" + Helper.escapeQuotes(clan.getFlags()) + "','" + Helper.escapeQuotes(String.valueOf(clan.getBalance())) + "');";
        this.core.insert(query + values);
    }

    public void addStrife(Clan attackerclan, Clan victimclan, int amount) {
        try {
            String query = null;
            if (!this.core.existsColumn("sc_war", attackerclan.getTag()).booleanValue() && !this.core.existsColumn("sc_war", victimclan.getTag()).booleanValue()) {
                String addcol = "ALTER TABLE sc_war ADD COLUMN " + attackerclan.getTag() + " int(255);";
                this.core.execute(addcol);
            }
            if (!Helper.existsEntry(this.core, "sc_war", "clan_name", victimclan.getTag()).booleanValue() && !Helper.existsEntry(this.core, "sc_war", "clan_name", attackerclan.getTag()).booleanValue()) {
                String insert = "INSERT INTO  `sc_war` (`clan_name`) VALUES ('" + victimclan.getTag() + "');";
                this.core.insert(insert);
            }
            if (this.core.existsColumn("sc_war", attackerclan.getTag()).booleanValue() && Helper.existsEntry(this.core, "sc_war", "clan_name", victimclan.getTag()).booleanValue()) {
                query = "UPDATE  `sc_war` SET  `" + attackerclan.getTag() + "` =  '" + (this.retrieveStrifes(attackerclan, victimclan) + amount) + "' WHERE  `sc_war`.`clan_name` =  '" + victimclan.getTag() + "';";
            } else if (this.core.existsColumn("sc_war", victimclan.getTag()).booleanValue() && Helper.existsEntry(this.core, "sc_war", "clan_name", attackerclan.getTag()).booleanValue()) {
                query = "UPDATE  `sc_war` SET  `" + victimclan.getTag() + "` =  '" + (this.retrieveStrifes(attackerclan, victimclan) + amount) + "' WHERE  `sc_war`.`clan_name` =  '" + attackerclan.getTag() + "';";
            }
            this.core.execute(query);
        }
        catch (SQLException ex) {
            SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
            SimpleClans.getLog().log(Level.SEVERE, null, ex);
        }
    }

    public void updateClan(Clan clan) {
        clan.updateLastUsed();
        String query = "UPDATE `sc_clans` SET verified = " + (clan.isVerified() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(clan.getTag()) + "', color_tag = '" + Helper.escapeQuotes(clan.getColorTag()) + "', name = '" + Helper.escapeQuotes(clan.getName()) + "', friendly_fire = " + (clan.isFriendlyFire() ? 1 : 0) + ", founded = '" + clan.getFounded() + "', last_used = '" + clan.getLastUsed() + "', packed_allies = '" + Helper.escapeQuotes(clan.getPackedAllies()) + "', packed_rivals = '" + Helper.escapeQuotes(clan.getPackedRivals()) + "', packed_bb = '" + Helper.escapeQuotes(clan.getPackedBb()) + "', cape_url = '" + Helper.escapeQuotes(clan.getCapeUrl()) + "', cape_url = '" + Helper.escapeQuotes(String.valueOf(clan.getCapeUrl())) + "', balance = '" + clan.getBalance() + "', flags = '" + Helper.escapeQuotes(clan.getFlags()) + "' WHERE tag = '" + Helper.escapeQuotes(clan.getTag()) + "';";
        this.core.update(query);
    }

    public void deleteClan(Clan clan) {
        String query = "DELETE FROM `sc_clans` WHERE tag = '" + clan.getTag() + "';";
        String war = null;
        if (this.core.existsColumn("sc_war", clan.getTag()).booleanValue()) {
            String warc = "ALTER TABLE `sc_war` DROP COLUMN `" + clan.getTag() + "`;";
        }
        try {
            if (Helper.existsEntry(this.core, "sc_war", "clan_name", clan.getTag()).booleanValue()) {
                war = war + "DELETE FROM `sc_war` WHERE clan_name = '" + clan.getTag() + "';";
            }
        }
        catch (SQLException ex) {
            SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
            SimpleClans.getLog().log(Level.SEVERE, null, ex);
        }
        if (war != null) {
            this.core.delete(war);
        }
        this.core.delete(query);
    }

    public void insertClanPlayer(ClanPlayer cp) {
        String query = "INSERT INTO `sc_players` (  `name`, `leader`, `tag`, `friendly_fire`, `neutral_kills`, `rival_kills`, `civilian_kills`, `deaths`, `last_seen`, `join_date`, `packed_past_clans`, `flags`) ";
        String values = "VALUES ( '" + cp.getName() + "'," + (cp.isLeader() ? 1 : 0) + ",'" + Helper.escapeQuotes(cp.getTag()) + "'," + (cp.isFriendlyFire() ? 1 : 0) + "," + cp.getNeutralKills() + "," + cp.getRivalKills() + "," + cp.getCivilianKills() + "," + cp.getDeaths() + ",'" + cp.getLastSeen() + "',' " + cp.getJoinDate() + "','" + Helper.escapeQuotes(cp.getPackedPastClans()) + "','" + Helper.escapeQuotes(cp.getFlags()) + "');";
        this.core.insert(query + values);
    }

    public void updateClanPlayer(ClanPlayer cp) {
        cp.updateLastSeen();
        String query = "UPDATE `sc_players` SET leader = " + (cp.isLeader() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(cp.getTag()) + "' , friendly_fire = " + (cp.isFriendlyFire() ? 1 : 0) + ", neutral_kills = " + cp.getNeutralKills() + ", rival_kills = " + cp.getRivalKills() + ", civilian_kills = " + cp.getCivilianKills() + ", deaths = " + cp.getDeaths() + ", last_seen = '" + cp.getLastSeen() + "', packed_past_clans = '" + Helper.escapeQuotes(cp.getPackedPastClans()) + "', trusted = " + (cp.isTrusted() ? 1 : 0) + ", flags='" + Helper.escapeQuotes(cp.getFlags()) + "' WHERE name = '" + cp.getName() + "';";
        this.core.update(query);
    }

    public void deleteClanPlayer(ClanPlayer cp) {
        String query = "DELETE FROM `sc_players` WHERE name = '" + cp.getName() + "';";
        this.core.delete(query);
        this.deleteKills(cp.getName());
    }

    public void insertKill(Player attacker, String attackerTag, Player victim, String victimTag, String type) {
        String query = "INSERT INTO `sc_kills` (  `attacker`, `attacker_tag`, `victim`, `victim_tag`, `kill_type`) ";
        String values = "VALUES ( '" + attacker.getName() + "','" + attackerTag + "','" + victim.getName() + "','" + victimTag + "','" + type + "');";
        this.core.insert(query + values);
    }

    public void deleteKills(String playerName) {
        String query = "DELETE FROM `sc_kills` WHERE `attacker` = '" + playerName + "'";
        this.core.delete(query);
    }

    public HashMap<String, Integer> getKillsPerPlayer(String playerName) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT victim, count(victim) AS kills FROM `sc_kills` WHERE attacker = '" + playerName + "' GROUP BY victim ORDER BY count(victim) DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String victim = res.getString("victim");
                        int kills = res.getInt("kills");
                        out.put(victim, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public HashMap<String, Integer> getMostKilled() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT attacker, victim, count(victim) AS kills FROM `sc_kills` GROUP BY attacker, victim ORDER BY 3 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String attacker = res.getString("attacker");
                        String victim = res.getString("victim");
                        int kills = res.getInt("kills");
                        out.put(attacker + " " + victim, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public HashMap<String, Integer> getTotalDeathsPerClan() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT victim_tag, count(victim_tag) AS kills FROM `sc_kills` GROUP BY victim_tag ORDER BY 2 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String victimTag = res.getString("victim_tag");
                        int kills = res.getInt("kills");
                        out.put(victimTag, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public HashMap<String, Integer> getTotalKillsPerClan() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT attacker_tag, count(attacker_tag) AS kills FROM `sc_kills` GROUP BY attacker_tag ORDER BY 2 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String victimTag = res.getString("attacker_tag");
                        int kills = res.getInt("kills");
                        out.put(victimTag, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public HashMap<String, Integer> getTotalKillsPerPlayer() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT attacker, count(attacker) AS kills FROM `sc_kills` GROUP BY attacker ORDER BY 2 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String attacker = res.getString("attacker");
                        int kills = res.getInt("kills");
                        out.put(attacker, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public HashMap<String, Integer> getTotalDeathsPerPlayer() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT victim, count(victim) AS kills FROM `sc_kills` GROUP BY victim ORDER BY 2 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String victim = res.getString("victim");
                        int kills = res.getInt("kills");
                        out.put(victim, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    private void updateDatabase() {
        String query = null;
        if (!this.core.existsColumn("sc_clans", "balance").booleanValue()) {
            query = "ALTER TABLE sc_clans ADD COLUMN `balance` double(64,2);";
        }
        if (query != null) {
            this.core.execute(query);
        }
    }
}

