/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.TeleportState;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public final class TeleportManager {
    private SimpleClans plugin;
    private HashMap<String, TeleportState> waitingPlayers = new HashMap();

    public TeleportManager() {
        this.plugin = SimpleClans.getInstance();
        this.startCounter();
    }

    public void addPlayer(Player player, Location dest, String clanName) {
        int secs = SimpleClans.getInstance().getSettingsManager().getWaitSecs();
        this.waitingPlayers.put(player.getName(), new TeleportState(player, dest, clanName));
        if (secs > 0) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(this.plugin.getLang("waiting.for.teleport.stand.still.for.0.seconds"), secs));
        }
    }

    private void dropItems(Player player) {
        block5: {
            block4: {
                ItemStack[] contents;
                if (!this.plugin.getSettingsManager().isDropOnHome()) break block4;
                PlayerInventory inv = player.getInventory();
                for (ItemStack item : contents = inv.getContents()) {
                    List<Integer> itemsList;
                    if (item == null || !(itemsList = this.plugin.getSettingsManager().getItemsList()).contains(item.getTypeId())) continue;
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                    inv.remove(item);
                }
                break block5;
            }
            if (!this.plugin.getSettingsManager().isKeepOnHome()) break block5;
            try {
                ItemStack[] contents;
                PlayerInventory inv = player.getInventory();
                for (ItemStack item : contents = (ItemStack[])inv.getContents().clone()) {
                    List<Integer> itemsList;
                    if (item == null || (itemsList = this.plugin.getSettingsManager().getItemsList()).contains(item.getTypeId())) continue;
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                    inv.remove(item);
                }
            }
            catch (Exception ex) {
                Helper.dumpStackTrace();
            }
        }
    }

    private void startCounter() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Iterator iter = TeleportManager.this.waitingPlayers.values().iterator();
                while (iter.hasNext()) {
                    TeleportState state = (TeleportState)iter.next();
                    if (state.isProcessing()) continue;
                    state.setProcessing(true);
                    Player player = state.getPlayer();
                    if (player != null) {
                        if (state.isTeleportTime()) {
                            if (Helper.isSameBlock(player.getLocation(), state.getLocation())) {
                                Location loc = state.getDestination();
                                int x = loc.getBlockX();
                                int z = loc.getBlockZ();
                                if (TeleportManager.this.plugin.getSettingsManager().isTeleportBlocks()) {
                                    player.sendBlockChange(new Location(loc.getWorld(), (double)(x + 1), (double)(loc.getBlockY() - 1), (double)(z + 1)), Material.GLASS, (byte)0);
                                    player.sendBlockChange(new Location(loc.getWorld(), (double)(x - 1), (double)(loc.getBlockY() - 1), (double)(z - 1)), Material.GLASS, (byte)0);
                                    player.sendBlockChange(new Location(loc.getWorld(), (double)(x + 1), (double)(loc.getBlockY() - 1), (double)(z - 1)), Material.GLASS, (byte)0);
                                    player.sendBlockChange(new Location(loc.getWorld(), (double)(x - 1), (double)(loc.getBlockY() - 1), (double)(z + 1)), Material.GLASS, (byte)0);
                                }
                                if (!TeleportManager.this.plugin.getPermissionsManager().has(player, "simpleclans.mod.keep-items")) {
                                    TeleportManager.this.dropItems(player);
                                }
                                SimpleClans.debug("teleporting");
                                player.teleport(new Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY(), (double)loc.getBlockZ() + 0.5));
                                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + MessageFormat.format(TeleportManager.this.plugin.getLang("now.at.homebase"), state.getClanName()));
                            } else {
                                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + TeleportManager.this.plugin.getLang("you.moved.teleport.cancelled"));
                            }
                            iter.remove();
                        } else if (!Helper.isSameBlock(player.getLocation(), state.getLocation())) {
                            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + TeleportManager.this.plugin.getLang("you.moved.teleport.cancelled"));
                            iter.remove();
                        } else {
                            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "" + state.getCounter());
                        }
                    } else {
                        iter.remove();
                    }
                    state.setProcessing(false);
                }
            }
        }, 0L, 20L);
    }
}

