/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.storage.DBCore;

public class MySQLCore
implements DBCore {
    private Logger log;
    private Connection connection;
    private String host;
    private String username;
    private String password;
    private String database;

    public MySQLCore(String host, String database, String username, String password) {
        this.database = database;
        this.host = host;
        this.username = username;
        this.password = password;
        this.log = SimpleClans.getLog();
        this.initialize();
    }

    private void initialize() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + "/" + this.database, this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            this.log.severe("ClassNotFoundException! " + e.getMessage());
        }
        catch (SQLException e) {
            this.log.severe("SQLException! " + e.getMessage());
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.initialize();
            }
        }
        catch (SQLException e) {
            this.initialize();
        }
        return this.connection;
    }

    @Override
    public Boolean checkConnection() {
        return this.getConnection() != null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.log.severe("Failed to close database connection! " + e.getMessage());
        }
    }

    @Override
    public ResultSet select(String query) {
        try {
            return this.getConnection().createStatement().executeQuery(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            this.log.severe("Query: " + query);
            return null;
        }
    }

    @Override
    public void insert(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL INSERT Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public void update(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL UPDATE Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public void delete(String query) {
        block2: {
            try {
                this.getConnection().createStatement().executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block2;
                this.log.severe("Error at SQL DELETE Query: " + ex);
                this.log.severe("Query: " + query);
            }
        }
    }

    @Override
    public Boolean execute(String query) {
        try {
            this.getConnection().createStatement().execute(query);
            return true;
        }
        catch (SQLException ex) {
            this.log.severe(ex.getMessage());
            this.log.severe("Query: " + query);
            return false;
        }
    }

    @Override
    public Boolean existsTable(String table) {
        try {
            ResultSet tables = this.getConnection().getMetaData().getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.log.severe("Failed to check if table '" + table + "' exists: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean existsColumn(String tabell, String colum) {
        try {
            ResultSet colums = this.getConnection().getMetaData().getColumns(null, null, tabell, colum);
            return colums.next();
        }
        catch (SQLException e) {
            SimpleClans.getLog().severe("Failed to check if colum '" + colum + "' exists: " + e.getMessage());
            return false;
        }
    }
}

