/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.ItemList;

public class JSONObject
extends HashMap {
    @Override
    public String toString() {
        ItemList list = new ItemList();
        for (Map.Entry entry : this.entrySet()) {
            list.add(JSONObject.toString(entry.getKey().toString(), entry.getValue()));
        }
        return "{" + list.toString() + "}";
    }

    public static String toString(String key, Object value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(JSONObject.escape(key));
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return sb.toString();
        }
        if (value instanceof String) {
            sb.append("\"");
            sb.append(JSONObject.escape((String)value));
            sb.append("\"");
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

