/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.parser;

import java.io.Reader;
import java.util.LinkedList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.Yylex;
import org.json.simple.parser.Yytoken;

public class JSONParser {
    public static final int S_INIT = 0;
    public static final int S_IN_FINISHED_VALUE = 1;
    public static final int S_IN_OBJECT = 2;
    public static final int S_IN_ARRAY = 3;
    public static final int S_PASSED_PAIR_KEY = 4;
    public static final int S_IN_ERROR = -1;
    private LinkedList statusStack = new LinkedList();
    private LinkedList valueStack = new LinkedList();
    private Yylex lexer = new Yylex((Reader)null);
    private Yytoken token = null;
    private int status = 0;

    private int peekStatus(LinkedList statusStack) {
        if (statusStack.size() == 0) {
            return -1;
        }
        Integer status = (Integer)statusStack.getFirst();
        return status;
    }

    private void reset(Reader in) throws Exception {
        this.statusStack.clear();
        this.valueStack.clear();
        this.lexer.yyreset(in);
        this.token = null;
        this.status = 0;
    }

    public Object parse(Reader in) throws Exception {
        this.reset(in);
        do {
            this.token = this.lexer.yylex();
            if (this.token == null) {
                this.token = new Yytoken(-1, null);
            }
            block1 : switch (this.status) {
                case 0: {
                    switch (this.token.type) {
                        case 0: {
                            this.status = 1;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(this.token.value);
                            break block1;
                        }
                        case 1: {
                            this.status = 2;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(new JSONObject());
                            break block1;
                        }
                        case 3: {
                            this.status = 3;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(new JSONArray());
                            break block1;
                        }
                    }
                    this.status = -1;
                    break;
                }
                case 1: {
                    if (this.token.type == -1) {
                        return this.valueStack.removeFirst();
                    }
                    return null;
                }
                case 2: {
                    String key;
                    switch (this.token.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            if (this.token.value instanceof String) {
                                key = (String)this.token.value;
                                this.valueStack.addFirst(key);
                                this.status = 4;
                                this.statusStack.addFirst(new Integer(this.status));
                                break block1;
                            }
                            this.status = -1;
                            break block1;
                        }
                        case 2: {
                            if (this.valueStack.size() > 1) {
                                this.statusStack.removeFirst();
                                this.valueStack.removeFirst();
                                this.status = this.peekStatus(this.statusStack);
                                break block1;
                            }
                            this.status = 1;
                            break block1;
                        }
                    }
                    this.status = -1;
                    break;
                }
                case 4: {
                    JSONArray newArray;
                    String key;
                    switch (this.token.type) {
                        case 6: {
                            break block1;
                        }
                        case 0: {
                            this.statusStack.removeFirst();
                            key = (String)this.valueStack.removeFirst();
                            JSONObject parent = (JSONObject)this.valueStack.getFirst();
                            parent.put(key, this.token.value);
                            this.status = this.peekStatus(this.statusStack);
                            break block1;
                        }
                        case 3: {
                            this.statusStack.removeFirst();
                            key = (String)this.valueStack.removeFirst();
                            JSONObject parent = (JSONObject)this.valueStack.getFirst();
                            newArray = new JSONArray();
                            parent.put(key, newArray);
                            this.status = 3;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(newArray);
                            break block1;
                        }
                        case 1: {
                            this.statusStack.removeFirst();
                            key = (String)this.valueStack.removeFirst();
                            JSONObject parent = (JSONObject)this.valueStack.getFirst();
                            JSONObject newObject = new JSONObject();
                            parent.put(key, newObject);
                            this.status = 2;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(newObject);
                            break block1;
                        }
                    }
                    this.status = -1;
                    break;
                }
                case 3: {
                    JSONArray newArray;
                    switch (this.token.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            JSONArray val = (JSONArray)this.valueStack.getFirst();
                            val.add(this.token.value);
                            break block1;
                        }
                        case 4: {
                            if (this.valueStack.size() > 1) {
                                this.statusStack.removeFirst();
                                this.valueStack.removeFirst();
                                this.status = this.peekStatus(this.statusStack);
                                break block1;
                            }
                            this.status = 1;
                            break block1;
                        }
                        case 1: {
                            JSONArray val = (JSONArray)this.valueStack.getFirst();
                            JSONObject newObject = new JSONObject();
                            val.add(newObject);
                            this.status = 2;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(newObject);
                            break block1;
                        }
                        case 3: {
                            JSONArray val = (JSONArray)this.valueStack.getFirst();
                            newArray = new JSONArray();
                            val.add(newArray);
                            this.status = 3;
                            this.statusStack.addFirst(new Integer(this.status));
                            this.valueStack.addFirst(newArray);
                            break block1;
                        }
                    }
                    this.status = -1;
                    break;
                }
                case -1: {
                    return null;
                }
            }
            if (this.status != -1) continue;
            return null;
        } while (this.token.type != -1);
        return null;
    }
}

