/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.PointGroupS;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.INamable;
import net.minecraft.util.SystemUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3i;
import org.jspecify.annotations.Nullable;

public final class PointGroupO
extends Enum<PointGroupO>
implements INamable {
    public static final /* enum */ PointGroupO IDENTITY = new PointGroupO("identity", PointGroupS.P123, false, false, false);
    public static final /* enum */ PointGroupO ROT_180_FACE_XY = new PointGroupO("rot_180_face_xy", PointGroupS.P123, true, true, false);
    public static final /* enum */ PointGroupO ROT_180_FACE_XZ = new PointGroupO("rot_180_face_xz", PointGroupS.P123, true, false, true);
    public static final /* enum */ PointGroupO ROT_180_FACE_YZ = new PointGroupO("rot_180_face_yz", PointGroupS.P123, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_NNN = new PointGroupO("rot_120_nnn", PointGroupS.P231, false, false, false);
    public static final /* enum */ PointGroupO ROT_120_NNP = new PointGroupO("rot_120_nnp", PointGroupS.P312, true, false, true);
    public static final /* enum */ PointGroupO ROT_120_NPN = new PointGroupO("rot_120_npn", PointGroupS.P312, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_NPP = new PointGroupO("rot_120_npp", PointGroupS.P231, true, false, true);
    public static final /* enum */ PointGroupO ROT_120_PNN = new PointGroupO("rot_120_pnn", PointGroupS.P312, true, true, false);
    public static final /* enum */ PointGroupO ROT_120_PNP = new PointGroupO("rot_120_pnp", PointGroupS.P231, true, true, false);
    public static final /* enum */ PointGroupO ROT_120_PPN = new PointGroupO("rot_120_ppn", PointGroupS.P231, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_PPP = new PointGroupO("rot_120_ppp", PointGroupS.P312, false, false, false);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XY_NEG = new PointGroupO("rot_180_edge_xy_neg", PointGroupS.P213, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XY_POS = new PointGroupO("rot_180_edge_xy_pos", PointGroupS.P213, false, false, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XZ_NEG = new PointGroupO("rot_180_edge_xz_neg", PointGroupS.P321, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XZ_POS = new PointGroupO("rot_180_edge_xz_pos", PointGroupS.P321, false, true, false);
    public static final /* enum */ PointGroupO ROT_180_EDGE_YZ_NEG = new PointGroupO("rot_180_edge_yz_neg", PointGroupS.P132, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_YZ_POS = new PointGroupO("rot_180_edge_yz_pos", PointGroupS.P132, true, false, false);
    public static final /* enum */ PointGroupO ROT_90_X_NEG = new PointGroupO("rot_90_x_neg", PointGroupS.P132, false, false, true);
    public static final /* enum */ PointGroupO ROT_90_X_POS = new PointGroupO("rot_90_x_pos", PointGroupS.P132, false, true, false);
    public static final /* enum */ PointGroupO ROT_90_Y_NEG = new PointGroupO("rot_90_y_neg", PointGroupS.P321, true, false, false);
    public static final /* enum */ PointGroupO ROT_90_Y_POS = new PointGroupO("rot_90_y_pos", PointGroupS.P321, false, false, true);
    public static final /* enum */ PointGroupO ROT_90_Z_NEG = new PointGroupO("rot_90_z_neg", PointGroupS.P213, false, true, false);
    public static final /* enum */ PointGroupO ROT_90_Z_POS = new PointGroupO("rot_90_z_pos", PointGroupS.P213, true, false, false);
    public static final /* enum */ PointGroupO INVERSION = new PointGroupO("inversion", PointGroupS.P123, true, true, true);
    public static final /* enum */ PointGroupO INVERT_X = new PointGroupO("invert_x", PointGroupS.P123, true, false, false);
    public static final /* enum */ PointGroupO INVERT_Y = new PointGroupO("invert_y", PointGroupS.P123, false, true, false);
    public static final /* enum */ PointGroupO INVERT_Z = new PointGroupO("invert_z", PointGroupS.P123, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NNN = new PointGroupO("rot_60_ref_nnn", PointGroupS.P312, true, true, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NNP = new PointGroupO("rot_60_ref_nnp", PointGroupS.P231, true, false, false);
    public static final /* enum */ PointGroupO ROT_60_REF_NPN = new PointGroupO("rot_60_ref_npn", PointGroupS.P231, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NPP = new PointGroupO("rot_60_ref_npp", PointGroupS.P312, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_PNN = new PointGroupO("rot_60_ref_pnn", PointGroupS.P231, false, true, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PNP = new PointGroupO("rot_60_ref_pnp", PointGroupS.P312, true, false, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PPN = new PointGroupO("rot_60_ref_ppn", PointGroupS.P312, false, true, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PPP = new PointGroupO("rot_60_ref_ppp", PointGroupS.P231, true, true, true);
    public static final /* enum */ PointGroupO SWAP_XY = new PointGroupO("swap_xy", PointGroupS.P213, false, false, false);
    public static final /* enum */ PointGroupO SWAP_YZ = new PointGroupO("swap_yz", PointGroupS.P132, false, false, false);
    public static final /* enum */ PointGroupO SWAP_XZ = new PointGroupO("swap_xz", PointGroupS.P321, false, false, false);
    public static final /* enum */ PointGroupO SWAP_NEG_XY = new PointGroupO("swap_neg_xy", PointGroupS.P213, true, true, false);
    public static final /* enum */ PointGroupO SWAP_NEG_YZ = new PointGroupO("swap_neg_yz", PointGroupS.P132, false, true, true);
    public static final /* enum */ PointGroupO SWAP_NEG_XZ = new PointGroupO("swap_neg_xz", PointGroupS.P321, true, false, true);
    public static final /* enum */ PointGroupO ROT_90_REF_X_NEG = new PointGroupO("rot_90_ref_x_neg", PointGroupS.P132, true, false, true);
    public static final /* enum */ PointGroupO ROT_90_REF_X_POS = new PointGroupO("rot_90_ref_x_pos", PointGroupS.P132, true, true, false);
    public static final /* enum */ PointGroupO ROT_90_REF_Y_NEG = new PointGroupO("rot_90_ref_y_neg", PointGroupS.P321, true, true, false);
    public static final /* enum */ PointGroupO ROT_90_REF_Y_POS = new PointGroupO("rot_90_ref_y_pos", PointGroupS.P321, false, true, true);
    public static final /* enum */ PointGroupO ROT_90_REF_Z_NEG = new PointGroupO("rot_90_ref_z_neg", PointGroupS.P213, false, true, true);
    public static final /* enum */ PointGroupO ROT_90_REF_Z_POS = new PointGroupO("rot_90_ref_z_pos", PointGroupS.P213, true, false, true);
    public static final PointGroupO BLOCK_ROT_X_270;
    public static final PointGroupO BLOCK_ROT_X_180;
    public static final PointGroupO BLOCK_ROT_X_90;
    public static final PointGroupO BLOCK_ROT_Y_270;
    public static final PointGroupO BLOCK_ROT_Y_180;
    public static final PointGroupO BLOCK_ROT_Y_90;
    public static final PointGroupO BLOCK_ROT_Z_270;
    public static final PointGroupO BLOCK_ROT_Z_180;
    public static final PointGroupO BLOCK_ROT_Z_90;
    private final Matrix3fc transformation;
    private final String name;
    private @Nullable Map<EnumDirection, EnumDirection> rotatedDirections;
    private final boolean invertX;
    private final boolean invertY;
    private final boolean invertZ;
    private final PointGroupS permutation;
    private static final PointGroupO[][] CAYLEY_TABLE;
    private static final PointGroupO[] INVERSE_TABLE;
    private static final /* synthetic */ PointGroupO[] ap;

    public static PointGroupO[] values() {
        return (PointGroupO[])ap.clone();
    }

    public static PointGroupO valueOf(String var0) {
        return Enum.valueOf(PointGroupO.class, var0);
    }

    private PointGroupO(String var2, PointGroupS var3, boolean var4, boolean var5, boolean var6) {
        this.name = var2;
        this.invertX = var4;
        this.invertY = var5;
        this.invertZ = var6;
        this.permutation = var3;
        this.transformation = new Matrix3f().scaling(var4 ? -1.0f : 1.0f, var5 ? -1.0f : 1.0f, var6 ? -1.0f : 1.0f).mul(var3.transformation());
    }

    private static int trace(boolean var0, boolean var1, boolean var2, PointGroupS var3) {
        int var4 = (var2 ? 4 : 0) + (var1 ? 2 : 0) + (var0 ? 1 : 0);
        return var3.ordinal() << 3 | var4;
    }

    private int trace() {
        return PointGroupO.trace(this.invertX, this.invertY, this.invertZ, this.permutation);
    }

    public PointGroupO compose(PointGroupO var0) {
        return CAYLEY_TABLE[this.ordinal()][var0.ordinal()];
    }

    public PointGroupO inverse() {
        return INVERSE_TABLE[this.ordinal()];
    }

    public Matrix3fc transformation() {
        return this.transformation;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public EnumDirection rotate(EnumDirection var02) {
        if (this.rotatedDirections == null) {
            this.rotatedDirections = SystemUtils.makeEnumMap(EnumDirection.class, var0 -> {
                EnumDirection.EnumAxis var1 = var0.getAxis();
                EnumDirection.EnumAxisDirection var2 = var0.getAxisDirection();
                EnumDirection.EnumAxis var3 = this.permutation.inverse().permuteAxis(var1);
                EnumDirection.EnumAxisDirection var4 = this.inverts(var3) ? var2.opposite() : var2;
                return EnumDirection.fromAxisAndDirection(var3, var4);
            });
        }
        return this.rotatedDirections.get(var02);
    }

    public Vector3i rotate(Vector3i var0) {
        this.permutation.permuteVector(var0);
        var0.x = var0.x * (this.invertX ? -1 : 1);
        var0.y = var0.y * (this.invertY ? -1 : 1);
        var0.z = var0.z * (this.invertZ ? -1 : 1);
        return var0;
    }

    public boolean inverts(EnumDirection.EnumAxis var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumDirection.EnumAxis.X -> this.invertX;
            case EnumDirection.EnumAxis.Y -> this.invertY;
            case EnumDirection.EnumAxis.Z -> this.invertZ;
        };
    }

    public PointGroupS permutation() {
        return this.permutation;
    }

    public BlockPropertyJigsawOrientation rotate(BlockPropertyJigsawOrientation var0) {
        return BlockPropertyJigsawOrientation.fromFrontAndTop(this.rotate(var0.front()), this.rotate(var0.top()));
    }

    private static /* synthetic */ PointGroupO[] g() {
        return new PointGroupO[]{IDENTITY, ROT_180_FACE_XY, ROT_180_FACE_XZ, ROT_180_FACE_YZ, ROT_120_NNN, ROT_120_NNP, ROT_120_NPN, ROT_120_NPP, ROT_120_PNN, ROT_120_PNP, ROT_120_PPN, ROT_120_PPP, ROT_180_EDGE_XY_NEG, ROT_180_EDGE_XY_POS, ROT_180_EDGE_XZ_NEG, ROT_180_EDGE_XZ_POS, ROT_180_EDGE_YZ_NEG, ROT_180_EDGE_YZ_POS, ROT_90_X_NEG, ROT_90_X_POS, ROT_90_Y_NEG, ROT_90_Y_POS, ROT_90_Z_NEG, ROT_90_Z_POS, INVERSION, INVERT_X, INVERT_Y, INVERT_Z, ROT_60_REF_NNN, ROT_60_REF_NNP, ROT_60_REF_NPN, ROT_60_REF_NPP, ROT_60_REF_PNN, ROT_60_REF_PNP, ROT_60_REF_PPN, ROT_60_REF_PPP, SWAP_XY, SWAP_YZ, SWAP_XZ, SWAP_NEG_XY, SWAP_NEG_YZ, SWAP_NEG_XZ, ROT_90_REF_X_NEG, ROT_90_REF_X_POS, ROT_90_REF_Y_NEG, ROT_90_REF_Y_POS, ROT_90_REF_Z_NEG, ROT_90_REF_Z_POS};
    }

    static {
        ap = PointGroupO.g();
        BLOCK_ROT_X_270 = ROT_90_X_POS;
        BLOCK_ROT_X_180 = ROT_180_FACE_YZ;
        BLOCK_ROT_X_90 = ROT_90_X_NEG;
        BLOCK_ROT_Y_270 = ROT_90_Y_POS;
        BLOCK_ROT_Y_180 = ROT_180_FACE_XZ;
        BLOCK_ROT_Y_90 = ROT_90_Y_NEG;
        BLOCK_ROT_Z_270 = ROT_90_Z_POS;
        BLOCK_ROT_Z_180 = ROT_180_FACE_XY;
        BLOCK_ROT_Z_90 = ROT_90_Z_NEG;
        CAYLEY_TABLE = SystemUtils.make(() -> {
            PointGroupO[] var02 = PointGroupO.values();
            PointGroupO[][] var1 = new PointGroupO[var02.length][var02.length];
            Map<Integer, PointGroupO> var2 = Arrays.stream(var02).collect(Collectors.toMap(PointGroupO::trace, var0 -> var0));
            for (PointGroupO var6 : var02) {
                for (PointGroupO var10 : var02) {
                    PointGroupS var11 = var10.permutation.compose(var6.permutation);
                    boolean var12 = var6.inverts(EnumDirection.EnumAxis.X) ^ var10.inverts(var6.permutation.permuteAxis(EnumDirection.EnumAxis.X));
                    boolean var13 = var6.inverts(EnumDirection.EnumAxis.Y) ^ var10.inverts(var6.permutation.permuteAxis(EnumDirection.EnumAxis.Y));
                    boolean var14 = var6.inverts(EnumDirection.EnumAxis.Z) ^ var10.inverts(var6.permutation.permuteAxis(EnumDirection.EnumAxis.Z));
                    var1[var6.ordinal()][var10.ordinal()] = var2.get(PointGroupO.trace(var12, var13, var14, var11));
                }
            }
            return var1;
        });
        INVERSE_TABLE = (PointGroupO[])Arrays.stream(PointGroupO.values()).map(var0 -> Arrays.stream(PointGroupO.values()).filter(var1 -> var0.compose((PointGroupO)var1) == IDENTITY).findAny().get()).toArray(PointGroupO[]::new);
    }
}

