/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionConditionNBT;
import net.minecraft.advancements.criterion.CriterionTriggerProperties;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.jspecify.annotations.Nullable;

public record CriterionConditionBlock(Optional<HolderSet<Block>> blocks, Optional<CriterionTriggerProperties> properties, Optional<CriterionConditionNBT> nbt, DataComponentMatchers components) {
    public static final Codec<CriterionConditionBlock> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.BLOCK).optionalFieldOf("blocks").forGetter(CriterionConditionBlock::blocks), (App)CriterionTriggerProperties.CODEC.optionalFieldOf("state").forGetter(CriterionConditionBlock::properties), (App)CriterionConditionNBT.CODEC.optionalFieldOf("nbt").forGetter(CriterionConditionBlock::nbt), (App)DataComponentMatchers.CODEC.forGetter(CriterionConditionBlock::components)).apply((Applicative)var0, CriterionConditionBlock::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CriterionConditionBlock> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.holderSet(Registries.BLOCK)), CriterionConditionBlock::blocks, ByteBufCodecs.optional(CriterionTriggerProperties.STREAM_CODEC), CriterionConditionBlock::properties, ByteBufCodecs.optional(CriterionConditionNBT.STREAM_CODEC), CriterionConditionBlock::nbt, DataComponentMatchers.STREAM_CODEC, CriterionConditionBlock::components, CriterionConditionBlock::new);

    public boolean matches(WorldServer var0, BlockPosition var1) {
        if (!var0.isLoaded(var1)) {
            return false;
        }
        if (!this.matchesState(var0.getBlockState(var1))) {
            return false;
        }
        if (this.nbt.isPresent() || !this.components.isEmpty()) {
            TileEntity var2 = var0.getBlockEntity(var1);
            if (this.nbt.isPresent() && !CriterionConditionBlock.matchesBlockEntity(var0, var2, this.nbt.get())) {
                return false;
            }
            if (!this.components.isEmpty() && !CriterionConditionBlock.matchesComponents(var2, this.components)) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(ShapeDetectorBlock var0) {
        if (!this.matchesState(var0.getState())) {
            return false;
        }
        return !this.nbt.isPresent() || CriterionConditionBlock.matchesBlockEntity(var0.getLevel(), var0.getEntity(), this.nbt.get());
    }

    private boolean matchesState(IBlockData var0) {
        if (this.blocks.isPresent() && !var0.is(this.blocks.get())) {
            return false;
        }
        return !this.properties.isPresent() || this.properties.get().matches(var0);
    }

    private static boolean matchesBlockEntity(IWorldReader var0, @Nullable TileEntity var1, CriterionConditionNBT var2) {
        return var1 != null && var2.matches(var1.saveWithFullMetadata(var0.registryAccess()));
    }

    private static boolean matchesComponents(@Nullable TileEntity var0, DataComponentMatchers var1) {
        return var0 != null && var1.test(var0.collectComponents());
    }

    public boolean requiresNbt() {
        return this.nbt.isPresent();
    }

    public static class a {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<CriterionTriggerProperties> properties = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        private a() {
        }

        public static a block() {
            return new a();
        }

        public a of(HolderGetter<Block> var0, Block ... var1) {
            return this.of(var0, Arrays.asList(var1));
        }

        public a of(HolderGetter<Block> var0, Collection<Block> var1) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, var1));
            return this;
        }

        public a of(HolderGetter<Block> var0, TagKey<Block> var1) {
            this.blocks = Optional.of(var0.getOrThrow(var1));
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = Optional.of(new CriterionConditionNBT(var0));
            return this;
        }

        public a setProperties(CriterionTriggerProperties.a var0) {
            this.properties = var0.build();
            return this;
        }

        public a components(DataComponentMatchers var0) {
            this.components = var0;
            return this;
        }

        public CriterionConditionBlock build() {
            return new CriterionConditionBlock(this.blocks, this.properties, this.nbt, this.components);
        }
    }
}

