/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.TagPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3D;

public record CriterionConditionDamageSource(List<TagPredicate<DamageType>> tags, Optional<CriterionConditionEntity> directEntity, Optional<CriterionConditionEntity> sourceEntity, Optional<Boolean> isDirect) {
    public static final Codec<CriterionConditionDamageSource> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)TagPredicate.codec(Registries.DAMAGE_TYPE).listOf().optionalFieldOf("tags", List.of()).forGetter(CriterionConditionDamageSource::tags), (App)CriterionConditionEntity.CODEC.optionalFieldOf("direct_entity").forGetter(CriterionConditionDamageSource::directEntity), (App)CriterionConditionEntity.CODEC.optionalFieldOf("source_entity").forGetter(CriterionConditionDamageSource::sourceEntity), (App)Codec.BOOL.optionalFieldOf("is_direct").forGetter(CriterionConditionDamageSource::isDirect)).apply((Applicative)var0, CriterionConditionDamageSource::new));

    public boolean matches(EntityPlayer var0, DamageSource var1) {
        return this.matches(var0.level(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, Vec3D var1, DamageSource var2) {
        for (TagPredicate<DamageType> var4 : this.tags) {
            if (var4.matches(var2.typeHolder())) continue;
            return false;
        }
        if (this.directEntity.isPresent() && !this.directEntity.get().matches(var0, var1, var2.getDirectEntity())) {
            return false;
        }
        if (this.sourceEntity.isPresent() && !this.sourceEntity.get().matches(var0, var1, var2.getEntity())) {
            return false;
        }
        return !this.isDirect.isPresent() || this.isDirect.get().booleanValue() == var2.isDirect();
    }

    public static class a {
        private final ImmutableList.Builder<TagPredicate<DamageType>> tags = ImmutableList.builder();
        private Optional<CriterionConditionEntity> directEntity = Optional.empty();
        private Optional<CriterionConditionEntity> sourceEntity = Optional.empty();
        private Optional<Boolean> isDirect = Optional.empty();

        public static a damageType() {
            return new a();
        }

        public a tag(TagPredicate<DamageType> var0) {
            this.tags.add(var0);
            return this;
        }

        public a direct(CriterionConditionEntity.a var0) {
            this.directEntity = Optional.of(var0.build());
            return this;
        }

        public a source(CriterionConditionEntity.a var0) {
            this.sourceEntity = Optional.of(var0.build());
            return this;
        }

        public a isDirect(boolean var0) {
            this.isDirect = Optional.of(var0);
            return this;
        }

        public CriterionConditionDamageSource build() {
            return new CriterionConditionDamageSource((List<TagPredicate<DamageType>>)this.tags.build(), this.directEntity, this.sourceEntity, this.isDirect);
        }
    }
}

