/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionDistance;
import net.minecraft.advancements.criterion.CriterionConditionEntityEquipment;
import net.minecraft.advancements.criterion.CriterionConditionEntityFlags;
import net.minecraft.advancements.criterion.CriterionConditionEntityType;
import net.minecraft.advancements.criterion.CriterionConditionLocation;
import net.minecraft.advancements.criterion.CriterionConditionMobEffect;
import net.minecraft.advancements.criterion.CriterionConditionNBT;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.EntitySubPredicate;
import net.minecraft.advancements.criterion.MovementPredicate;
import net.minecraft.advancements.criterion.SlotsPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.jspecify.annotations.Nullable;

public record CriterionConditionEntity(Optional<CriterionConditionEntityType> entityType, Optional<CriterionConditionDistance> distanceToPlayer, Optional<MovementPredicate> movement, b location, Optional<CriterionConditionMobEffect> effects, Optional<CriterionConditionNBT> nbt, Optional<CriterionConditionEntityFlags> flags, Optional<CriterionConditionEntityEquipment> equipment, Optional<EntitySubPredicate> subPredicate, Optional<Integer> periodicTick, Optional<CriterionConditionEntity> vehicle, Optional<CriterionConditionEntity> passenger, Optional<CriterionConditionEntity> targetedEntity, Optional<String> team, Optional<SlotsPredicate> slots, DataComponentMatchers components) {
    public static final Codec<CriterionConditionEntity> CODEC = Codec.recursive((String)"EntityPredicate", var0 -> RecordCodecBuilder.create(var1 -> var1.group((App)CriterionConditionEntityType.CODEC.optionalFieldOf("type").forGetter(CriterionConditionEntity::entityType), (App)CriterionConditionDistance.CODEC.optionalFieldOf("distance").forGetter(CriterionConditionEntity::distanceToPlayer), (App)MovementPredicate.CODEC.optionalFieldOf("movement").forGetter(CriterionConditionEntity::movement), (App)b.CODEC.forGetter(CriterionConditionEntity::location), (App)CriterionConditionMobEffect.CODEC.optionalFieldOf("effects").forGetter(CriterionConditionEntity::effects), (App)CriterionConditionNBT.CODEC.optionalFieldOf("nbt").forGetter(CriterionConditionEntity::nbt), (App)CriterionConditionEntityFlags.CODEC.optionalFieldOf("flags").forGetter(CriterionConditionEntity::flags), (App)CriterionConditionEntityEquipment.CODEC.optionalFieldOf("equipment").forGetter(CriterionConditionEntity::equipment), (App)EntitySubPredicate.CODEC.optionalFieldOf("type_specific").forGetter(CriterionConditionEntity::subPredicate), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("periodic_tick").forGetter(CriterionConditionEntity::periodicTick), (App)var0.optionalFieldOf("vehicle").forGetter(CriterionConditionEntity::vehicle), (App)var0.optionalFieldOf("passenger").forGetter(CriterionConditionEntity::passenger), (App)var0.optionalFieldOf("targeted_entity").forGetter(CriterionConditionEntity::targetedEntity), (App)Codec.STRING.optionalFieldOf("team").forGetter(CriterionConditionEntity::team), (App)SlotsPredicate.CODEC.optionalFieldOf("slots").forGetter(CriterionConditionEntity::slots), (App)DataComponentMatchers.CODEC.forGetter(CriterionConditionEntity::components)).apply((Applicative)var1, CriterionConditionEntity::new)));
    public static final Codec<ContextAwarePredicate> ADVANCEMENT_CODEC = Codec.withAlternative(ContextAwarePredicate.CODEC, CODEC, CriterionConditionEntity::wrap);

    public static ContextAwarePredicate wrap(a var0) {
        return CriterionConditionEntity.wrap(var0.build());
    }

    public static Optional<ContextAwarePredicate> wrap(Optional<CriterionConditionEntity> var0) {
        return var0.map(CriterionConditionEntity::wrap);
    }

    public static List<ContextAwarePredicate> wrap(a ... var0) {
        return Stream.of(var0).map(CriterionConditionEntity::wrap).toList();
    }

    public static ContextAwarePredicate wrap(CriterionConditionEntity var0) {
        LootItemCondition var1 = LootItemConditionEntityProperty.hasProperties(LootTableInfo.EntityTarget.THIS, var0).build();
        return new ContextAwarePredicate(List.of(var1));
    }

    public boolean matches(EntityPlayer var0, @Nullable Entity var1) {
        return this.matches(var0.level(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, @Nullable Vec3D var1, @Nullable Entity var22) {
        Object var3;
        if (var22 == null) {
            return false;
        }
        if (this.entityType.isPresent() && !this.entityType.get().matches(var22.getType())) {
            return false;
        }
        if (var1 == null ? this.distanceToPlayer.isPresent() : this.distanceToPlayer.isPresent() && !this.distanceToPlayer.get().matches(var1.x, var1.y, var1.z, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.movement.isPresent()) {
            var3 = var22.getKnownMovement();
            Vec3D var4 = ((Vec3D)var3).scale(20.0);
            if (!this.movement.get().matches(var4.x, var4.y, var4.z, var22.fallDistance)) {
                return false;
            }
        }
        if (this.location.located.isPresent() && !this.location.located.get().matches(var0, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.location.steppingOn.isPresent()) {
            var3 = Vec3D.atCenterOf(var22.getOnPos());
            if (!var22.onGround() || !this.location.steppingOn.get().matches(var0, ((Vec3D)var3).x(), ((Vec3D)var3).y(), ((Vec3D)var3).z())) {
                return false;
            }
        }
        if (this.location.affectsMovement.isPresent()) {
            var3 = Vec3D.atCenterOf(var22.getBlockPosBelowThatAffectsMyMovement());
            if (!this.location.affectsMovement.get().matches(var0, ((Vec3D)var3).x(), ((Vec3D)var3).y(), ((Vec3D)var3).z())) {
                return false;
            }
        }
        if (this.effects.isPresent() && !this.effects.get().matches(var22)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches(var22)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().matches(var22)) {
            return false;
        }
        if (this.subPredicate.isPresent() && !this.subPredicate.get().matches(var22, var0, var1)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().matches(var0, var1, var22.getVehicle())) {
            return false;
        }
        if (this.passenger.isPresent() && var22.getPassengers().stream().noneMatch(var2 -> this.passenger.get().matches(var0, var1, (Entity)var2))) {
            return false;
        }
        if (this.targetedEntity.isPresent() && !this.targetedEntity.get().matches(var0, var1, var22 instanceof EntityInsentient ? ((EntityInsentient)var22).getTarget() : null)) {
            return false;
        }
        if (this.periodicTick.isPresent() && var22.tickCount % this.periodicTick.get() != 0) {
            return false;
        }
        if (this.team.isPresent() && ((var3 = var22.getTeam()) == null || !this.team.get().equals(((ScoreboardTeamBase)var3).getName()))) {
            return false;
        }
        if (this.slots.isPresent() && !this.slots.get().matches(var22)) {
            return false;
        }
        if (!this.components.test(var22)) {
            return false;
        }
        return this.nbt.isEmpty() || this.nbt.get().matches(var22);
    }

    public static LootTableInfo createContext(EntityPlayer var0, Entity var1) {
        LootParams var2 = new LootParams.a(var0.level()).withParameter(LootContextParameters.THIS_ENTITY, var1).withParameter(LootContextParameters.ORIGIN, var0.position()).create(LootContextParameterSets.ADVANCEMENT_ENTITY);
        return new LootTableInfo.Builder(var2).create(Optional.empty());
    }

    public static final class b
    extends Record {
        final Optional<CriterionConditionLocation> located;
        final Optional<CriterionConditionLocation> steppingOn;
        final Optional<CriterionConditionLocation> affectsMovement;
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CriterionConditionLocation.CODEC.optionalFieldOf("location").forGetter(b::located), (App)CriterionConditionLocation.CODEC.optionalFieldOf("stepping_on").forGetter(b::steppingOn), (App)CriterionConditionLocation.CODEC.optionalFieldOf("movement_affected_by").forGetter(b::affectsMovement)).apply((Applicative)var0, b::new));

        public b(Optional<CriterionConditionLocation> var0, Optional<CriterionConditionLocation> var1, Optional<CriterionConditionLocation> var2) {
            this.located = var0;
            this.steppingOn = var1;
            this.affectsMovement = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this, var0);
        }

        public Optional<CriterionConditionLocation> located() {
            return this.located;
        }

        public Optional<CriterionConditionLocation> steppingOn() {
            return this.steppingOn;
        }

        public Optional<CriterionConditionLocation> affectsMovement() {
            return this.affectsMovement;
        }
    }

    public static class a {
        private Optional<CriterionConditionEntityType> entityType = Optional.empty();
        private Optional<CriterionConditionDistance> distanceToPlayer = Optional.empty();
        private Optional<MovementPredicate> movement = Optional.empty();
        private Optional<CriterionConditionLocation> located = Optional.empty();
        private Optional<CriterionConditionLocation> steppingOnLocation = Optional.empty();
        private Optional<CriterionConditionLocation> movementAffectedBy = Optional.empty();
        private Optional<CriterionConditionMobEffect> effects = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();
        private Optional<CriterionConditionEntityFlags> flags = Optional.empty();
        private Optional<CriterionConditionEntityEquipment> equipment = Optional.empty();
        private Optional<EntitySubPredicate> subPredicate = Optional.empty();
        private Optional<Integer> periodicTick = Optional.empty();
        private Optional<CriterionConditionEntity> vehicle = Optional.empty();
        private Optional<CriterionConditionEntity> passenger = Optional.empty();
        private Optional<CriterionConditionEntity> targetedEntity = Optional.empty();
        private Optional<String> team = Optional.empty();
        private Optional<SlotsPredicate> slots = Optional.empty();
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        public static a entity() {
            return new a();
        }

        public a of(HolderGetter<EntityTypes<?>> var0, EntityTypes<?> var1) {
            this.entityType = Optional.of(CriterionConditionEntityType.of(var0, var1));
            return this;
        }

        public a of(HolderGetter<EntityTypes<?>> var0, TagKey<EntityTypes<?>> var1) {
            this.entityType = Optional.of(CriterionConditionEntityType.of(var0, var1));
            return this;
        }

        public a entityType(CriterionConditionEntityType var0) {
            this.entityType = Optional.of(var0);
            return this;
        }

        public a distance(CriterionConditionDistance var0) {
            this.distanceToPlayer = Optional.of(var0);
            return this;
        }

        public a moving(MovementPredicate var0) {
            this.movement = Optional.of(var0);
            return this;
        }

        public a located(CriterionConditionLocation.a var0) {
            this.located = Optional.of(var0.build());
            return this;
        }

        public a steppingOn(CriterionConditionLocation.a var0) {
            this.steppingOnLocation = Optional.of(var0.build());
            return this;
        }

        public a movementAffectedBy(CriterionConditionLocation.a var0) {
            this.movementAffectedBy = Optional.of(var0.build());
            return this;
        }

        public a effects(CriterionConditionMobEffect.a var0) {
            this.effects = var0.build();
            return this;
        }

        public a nbt(CriterionConditionNBT var0) {
            this.nbt = Optional.of(var0);
            return this;
        }

        public a flags(CriterionConditionEntityFlags.a var0) {
            this.flags = Optional.of(var0.build());
            return this;
        }

        public a equipment(CriterionConditionEntityEquipment.a var0) {
            this.equipment = Optional.of(var0.build());
            return this;
        }

        public a equipment(CriterionConditionEntityEquipment var0) {
            this.equipment = Optional.of(var0);
            return this;
        }

        public a subPredicate(EntitySubPredicate var0) {
            this.subPredicate = Optional.of(var0);
            return this;
        }

        public a periodicTick(int var0) {
            this.periodicTick = Optional.of(var0);
            return this;
        }

        public a vehicle(a var0) {
            this.vehicle = Optional.of(var0.build());
            return this;
        }

        public a passenger(a var0) {
            this.passenger = Optional.of(var0.build());
            return this;
        }

        public a targetedEntity(a var0) {
            this.targetedEntity = Optional.of(var0.build());
            return this;
        }

        public a team(String var0) {
            this.team = Optional.of(var0);
            return this;
        }

        public a slots(SlotsPredicate var0) {
            this.slots = Optional.of(var0);
            return this;
        }

        public a components(DataComponentMatchers var0) {
            this.components = var0;
            return this;
        }

        public CriterionConditionEntity build() {
            return new CriterionConditionEntity(this.entityType, this.distanceToPlayer, this.movement, new b(this.located, this.steppingOnLocation, this.movementAffectedBy), this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.periodicTick, this.vehicle, this.passenger, this.targetedEntity, this.team, this.slots, this.components);
        }
    }
}

