/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionTriggerAbstract;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class CriterionTriggerFishingRodHooked
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, ItemStack var1, EntityFishingHook var2, Collection<ItemStack> var32) {
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var2.getHookedIn() != null ? var2.getHookedIn() : var2);
        this.trigger(var0, var3 -> var3.matches(var1, var4, var32));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionItem> rod, Optional<ContextAwarePredicate> entity, Optional<CriterionConditionItem> item) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionItem.CODEC.optionalFieldOf("rod").forGetter(a::rod), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(a::entity), (App)CriterionConditionItem.CODEC.optionalFieldOf("item").forGetter(a::item)).apply((Applicative)var0, a::new));

        public static Criterion<a> fishedItem(Optional<CriterionConditionItem> var0, Optional<CriterionConditionEntity> var1, Optional<CriterionConditionItem> var2) {
            return CriterionTriggers.FISHING_ROD_HOOKED.createCriterion(new a(Optional.empty(), var0, CriterionConditionEntity.wrap(var1), var2));
        }

        public boolean matches(ItemStack var0, LootTableInfo var1, Collection<ItemStack> var2) {
            if (this.rod.isPresent() && !this.rod.get().test(var0)) {
                return false;
            }
            if (this.entity.isPresent() && !this.entity.get().matches(var1)) {
                return false;
            }
            if (this.item.isPresent()) {
                boolean var3 = false;
                Entity var4 = var1.getOptionalParameter(LootContextParameters.THIS_ENTITY);
                if (var4 instanceof EntityItem) {
                    EntityItem var5 = (EntityItem)var4;
                    if (this.item.get().test(var5.getItem())) {
                        var3 = true;
                    }
                }
                for (ItemStack var6 : var2) {
                    if (!this.item.get().test(var6)) continue;
                    var3 = true;
                    break;
                }
                if (!var3) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.entity, "entity");
        }
    }
}

