/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;

public class CompletionProviders {
    private static final Map<MinecraftKey, SuggestionProvider<ICompletionProvider>> PROVIDERS_BY_NAME = new HashMap<MinecraftKey, SuggestionProvider<ICompletionProvider>>();
    private static final MinecraftKey ID_ASK_SERVER = MinecraftKey.withDefaultNamespace("ask_server");
    public static final SuggestionProvider<ICompletionProvider> ASK_SERVER = CompletionProviders.register(ID_ASK_SERVER, (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var1) -> ((ICompletionProvider)var0.getSource()).customSuggestion(var0)));
    public static final SuggestionProvider<ICompletionProvider> AVAILABLE_SOUNDS = CompletionProviders.register(MinecraftKey.withDefaultNamespace("available_sounds"), (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var1) -> ICompletionProvider.suggestResource(((ICompletionProvider)var0.getSource()).getAvailableSounds(), var1)));
    public static final SuggestionProvider<ICompletionProvider> SUMMONABLE_ENTITIES = CompletionProviders.register(MinecraftKey.withDefaultNamespace("summonable_entities"), (SuggestionProvider<ICompletionProvider>)((SuggestionProvider)(var0, var12) -> ICompletionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.stream().filter(var1 -> var1.isEnabled(((ICompletionProvider)var0.getSource()).enabledFeatures()) && var1.canSummon()), var12, EntityTypes::getKey, EntityTypes::getDescription)));

    public static <S extends ICompletionProvider> SuggestionProvider<S> register(MinecraftKey var0, SuggestionProvider<ICompletionProvider> var1) {
        SuggestionProvider<ICompletionProvider> var2 = PROVIDERS_BY_NAME.putIfAbsent(var0, var1);
        if (var2 != null) {
            throw new IllegalArgumentException("A command suggestion provider is already registered with the name '" + String.valueOf(var0) + "'");
        }
        return new a(var0, var1);
    }

    public static <S extends ICompletionProvider> SuggestionProvider<S> cast(SuggestionProvider<ICompletionProvider> var0) {
        return var0;
    }

    public static <S extends ICompletionProvider> SuggestionProvider<S> getProvider(MinecraftKey var0) {
        return CompletionProviders.cast(PROVIDERS_BY_NAME.getOrDefault(var0, ASK_SERVER));
    }

    public static MinecraftKey getName(SuggestionProvider<?> var0) {
        MinecraftKey minecraftKey;
        if (var0 instanceof a) {
            a var1 = (a)var0;
            minecraftKey = var1.name;
        } else {
            minecraftKey = ID_ASK_SERVER;
        }
        return minecraftKey;
    }

    static final class a
    extends Record
    implements SuggestionProvider<ICompletionProvider> {
        final MinecraftKey name;
        private final SuggestionProvider<ICompletionProvider> delegate;

        a(MinecraftKey var0, SuggestionProvider<ICompletionProvider> var1) {
            this.name = var0;
            this.delegate = var1;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<ICompletionProvider> var0, SuggestionsBuilder var1) throws CommandSyntaxException {
            return this.delegate.getSuggestions(var0, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;delegate", "name", "delegate"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;delegate", "name", "delegate"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;delegate", "name", "delegate"}, this, var0);
        }

        public MinecraftKey name() {
            return this.name;
        }

        public SuggestionProvider<ICompletionProvider> delegate() {
            return this.delegate;
        }
    }
}

