/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import org.jspecify.annotations.Nullable;

public class RegistryBlockID<T>
implements Registry<T> {
    private int nextId;
    private final Reference2IntMap<T> tToId;
    private final List<T> idToT;

    public RegistryBlockID() {
        this(512);
    }

    public RegistryBlockID(int var0) {
        this.idToT = Lists.newArrayListWithExpectedSize((int)var0);
        this.tToId = new Reference2IntOpenHashMap(var0);
        this.tToId.defaultReturnValue(-1);
    }

    public void addMapping(T var0, int var1) {
        this.tToId.put(var0, var1);
        while (this.idToT.size() <= var1) {
            this.idToT.add(null);
        }
        this.idToT.set(var1, var0);
        if (this.nextId <= var1) {
            this.nextId = var1 + 1;
        }
    }

    public void add(T var0) {
        this.addMapping(var0, this.nextId);
    }

    @Override
    public int getId(T var0) {
        return this.tToId.getInt(var0);
    }

    @Override
    public final @Nullable T byId(int var0) {
        if (var0 >= 0 && var0 < this.idToT.size()) {
            return this.idToT.get(var0);
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter(this.idToT.iterator(), Objects::nonNull);
    }

    public boolean contains(int var0) {
        return this.byId(var0) != null;
    }

    @Override
    public int size() {
        return this.tToId.size();
    }
}

