/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;

public class RegistrySetBuilder {
    private final List<k<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.b<T> var0) {
        return new c<T>(var0){

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return var0.get(var02);
            }
        };
    }

    static <T> HolderLookup.b<T> lookupFromMap(final ResourceKey<? extends IRegistry<? extends T>> var0, final Lifecycle var1, HolderOwner<T> var2, final Map<ResourceKey<T>, Holder.c<T>> var3) {
        return new e<T>(var2){

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> key() {
                return var0;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return var1;
            }

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return Optional.ofNullable((Holder.c)var3.get(var02));
            }

            @Override
            public Stream<Holder.c<T>> listElements() {
                return var3.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, i<T> var2) {
        this.entries.add(new k<T>(var0, var1, var2));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends IRegistry<T>> var0, i<T> var1) {
        return this.add(var0, Lifecycle.stable(), var1);
    }

    private b createState(IRegistryCustom var0) {
        b var12 = b.create(var0, this.entries.stream().map(k::key));
        this.entries.forEach(var1 -> var1.apply(var12));
        return var12;
    }

    private static HolderLookup.a buildProviderWithContext(m var0, IRegistryCustom var12, Stream<HolderLookup.b<?>> var22) {
        record A<T>(HolderLookup.b<T> lookup, RegistryOps.b<T> opsInfo) {
            public static <T> A<T> createForContextRegistry(HolderLookup.b<T> var0) {
                return new A<T>(new d<T>(var0, var0), RegistryOps.b.fromRegistryLookup(var0));
            }

            public static <T> A<T> createForNewRegistry(m var0, HolderLookup.b<T> var1) {
                return new A(new d(var0.cast(), var1), new RegistryOps.b(var0.cast(), var1, var1.registryLifecycle()));
            }
        }
        final HashMap var3 = new HashMap();
        var12.registries().forEach(var1 -> var3.put(var1.key(), A.createForContextRegistry(var1.value())));
        var22.forEach(var2 -> var3.put(var2.key(), A.createForNewRegistry(var0, var2)));
        return new HolderLookup.a(){

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> listRegistryKeys() {
                return var3.keySet().stream();
            }

            <T> Optional<A<T>> getEntry(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((A)var3.get(var0));
            }

            public <T> Optional<HolderLookup.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return this.getEntry(var0).map(A::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> var0) {
                return RegistryOps.create(var0, new RegistryOps.c(){

                    @Override
                    public <T> Optional<RegistryOps.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                        return this.getEntry(var0).map(A::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.a build(IRegistryCustom var0) {
        b var12 = this.createState(var0);
        Stream<HolderLookup.b<?>> var2 = this.entries.stream().map(var1 -> var1.collectRegisteredValues(var12).buildAsLookup(var0.owner));
        HolderLookup.a var3 = RegistrySetBuilder.buildProviderWithContext(var12.owner, var0, var2);
        var12.reportNotCollectedHolders();
        var12.reportUnclaimedRegisteredValues();
        var12.throwOnError();
        return var3;
    }

    private HolderLookup.a createLazyFullPatchedRegistries(IRegistryCustom var0, HolderLookup.a var1, Cloner.a var2, Map<ResourceKey<? extends IRegistry<?>>, j<?>> var3, HolderLookup.a var4) {
        m var52 = new m();
        MutableObject var6 = new MutableObject();
        List var7 = var3.keySet().stream().map(var5 -> this.createLazyFullPatchedRegistries(var52, var2, (ResourceKey)var5, var4, var1, (MutableObject<HolderLookup.a>)var6)).collect(Collectors.toUnmodifiableList());
        HolderLookup.a var8 = RegistrySetBuilder.buildProviderWithContext(var52, var0, var7.stream());
        var6.setValue((Object)var8);
        return var8;
    }

    private <T> HolderLookup.b<T> createLazyFullPatchedRegistries(HolderOwner<T> var0, Cloner.a var1, ResourceKey<? extends IRegistry<? extends T>> var2, HolderLookup.a var3, HolderLookup.a var4, MutableObject<HolderLookup.a> var52) {
        Cloner var6 = var1.cloner(var2);
        if (var6 == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(var2.identifier()));
        }
        HashMap var7 = new HashMap();
        HolderGetter var8 = var3.lookupOrThrow(var2);
        var8.listElements().forEach(var5 -> {
            ResourceKey var6 = var5.key();
            f var7 = new f(var0, var6);
            var7.supplier = () -> var6.clone(var5.value(), var3, (HolderLookup.a)var52.get());
            var7.put(var6, var7);
        });
        HolderGetter var9 = var4.lookupOrThrow(var2);
        var9.listElements().forEach(var5 -> {
            ResourceKey var62 = var5.key();
            var7.computeIfAbsent(var62, var6 -> {
                f var7 = new f(var0, var62);
                var7.supplier = () -> var6.clone(var5.value(), var4, (HolderLookup.a)var52.get());
                return var7;
            });
        });
        Lifecycle var10 = var8.registryLifecycle().add(var9.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(var2, var10, var0, var7);
    }

    public g buildPatch(IRegistryCustom var0, HolderLookup.a var12, Cloner.a var2) {
        b var3 = this.createState(var0);
        HashMap var4 = new HashMap();
        this.entries.stream().map(var1 -> var1.collectRegisteredValues(var3)).forEach(var1 -> var4.put((ResourceKey<IRegistry<?>>)var1.key, (j<?>)var1));
        Set var5 = var0.listRegistryKeys().collect(Collectors.toUnmodifiableSet());
        var12.listRegistryKeys().filter(var1 -> !var5.contains(var1)).forEach(var1 -> var4.putIfAbsent((ResourceKey<IRegistry<?>>)var1, new j(var1, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.b<?>> var6 = var4.values().stream().map(var1 -> var1.buildAsLookup(var0.owner));
        HolderLookup.a var7 = RegistrySetBuilder.buildProviderWithContext(var3.owner, var0, var6);
        var3.reportUnclaimedRegisteredValues();
        var3.throwOnError();
        HolderLookup.a var8 = this.createLazyFullPatchedRegistries(var0, var12, var2, var4, var7);
        return new g(var8, var7);
    }

    record k<T>(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, i<T> bootstrap) {
        void apply(b var0) {
            this.bootstrap.run(var0.bootstrapContext());
        }

        public j<T> collectRegisteredValues(b var0) {
            HashMap var1 = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, h<?>>> var2 = var0.registeredValues.entrySet().iterator();
            while (var2.hasNext()) {
                Map.Entry<ResourceKey<?>, h<?>> var3 = var2.next();
                ResourceKey<?> var4 = var3.getKey();
                if (!var4.isFor(this.key)) continue;
                ResourceKey<?> var5 = var4;
                h<?> var6 = var3.getValue();
                Holder.c<Object> var7 = var0.lookup.holders.remove(var4);
                var1.put(var5, new n(var6, Optional.ofNullable(var7)));
                var2.remove();
            }
            return new j(this.key, this.lifecycle, var1);
        }
    }

    @FunctionalInterface
    public static interface i<T> {
        public void run(BootstrapContext<T> var1);
    }

    static final class b
    extends Record {
        final m owner;
        final l lookup;
        final Map<MinecraftKey, HolderGetter<?>> registries;
        final Map<ResourceKey<?>, h<?>> registeredValues;
        final List<RuntimeException> errors;

        private b(m var0, l var1, Map<MinecraftKey, HolderGetter<?>> var2, Map<ResourceKey<?>, h<?>> var3, List<RuntimeException> var4) {
            this.owner = var0;
            this.lookup = var1;
            this.registries = var2;
            this.registeredValues = var3;
            this.errors = var4;
        }

        public static b create(IRegistryCustom var0, Stream<ResourceKey<? extends IRegistry<?>>> var12) {
            m var22 = new m();
            ArrayList<RuntimeException> var3 = new ArrayList<RuntimeException>();
            l var4 = new l(var22);
            ImmutableMap.Builder var5 = ImmutableMap.builder();
            var0.registries().forEach(var1 -> var5.put((Object)var1.key().identifier(), RegistrySetBuilder.wrapContextLookup(var1.value())));
            var12.forEach(var2 -> var5.put((Object)var2.identifier(), (Object)var4));
            return new b(var22, var4, (Map<MinecraftKey, HolderGetter<?>>)var5.build(), new HashMap(), (List<RuntimeException>)var3);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.c<T> register(ResourceKey<T> var0, T var1, Lifecycle var2) {
                    h var3 = registeredValues.put(var0, new h(var1, var2));
                    if (var3 != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(var0) + ", new=" + String.valueOf(var1) + ", old=" + String.valueOf(var3.value)));
                    }
                    return lookup.getOrCreate(var0);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends IRegistry<? extends S>> var0) {
                    return registries.getOrDefault(var0.identifier(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((var0, var1) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(var1.value) + " for key " + String.valueOf(var0))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> var1 : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(var1)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException var0 = new IllegalStateException("Errors during registry creation");
                for (RuntimeException var2 : this.errors) {
                    var0.addSuppressed(var2);
                }
                throw var0;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this, var0);
        }

        public m owner() {
            return this.owner;
        }

        public l lookup() {
            return this.lookup;
        }

        public Map<MinecraftKey, HolderGetter<?>> registries() {
            return this.registries;
        }

        public Map<ResourceKey<?>, h<?>> registeredValues() {
            return this.registeredValues;
        }

        public List<RuntimeException> errors() {
            return this.errors;
        }
    }

    static class m
    implements HolderOwner<Object> {
        m() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record g(HolderLookup.a full, HolderLookup.a patches) {
    }

    static final class j<T>
    extends Record {
        final ResourceKey<? extends IRegistry<? extends T>> key;
        private final Lifecycle lifecycle;
        private final Map<ResourceKey<T>, n<T>> values;

        j(ResourceKey<? extends IRegistry<? extends T>> var0, Lifecycle var1, Map<ResourceKey<T>, n<T>> var2) {
            this.key = var0;
            this.lifecycle = var1;
            this.values = var2;
        }

        public HolderLookup.b<T> buildAsLookup(m var0) {
            Map var12 = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, var1 -> {
                n var2 = (n)var1.getValue();
                Holder.c var3 = var2.holder().orElseGet(() -> Holder.c.createStandAlone(var0.cast(), (ResourceKey)var1.getKey()));
                var3.bindValue(var2.value().value());
                return var3;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, var0.cast(), var12);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<? extends T>> key() {
            return this.key;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }

        public Map<ResourceKey<T>, n<T>> values() {
            return this.values;
        }
    }

    static class f<T>
    extends Holder.c<T> {
        @Nullable Supplier<T> supplier;

        protected f(HolderOwner<T> var0, @Nullable ResourceKey<T> var1) {
            super(Holder.c.a.STAND_ALONE, var0, var1, null);
        }

        @Override
        protected void bindValue(T var0) {
            super.bindValue(var0);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record n<T>(h<T> value, Optional<Holder.c<T>> holder) {
    }

    static final class h<T>
    extends Record {
        final T value;
        private final Lifecycle lifecycle;

        h(T var0, Lifecycle var1) {
            this.value = var0;
            this.lifecycle = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value;lifecycle", "value", "lifecycle"}, this, var0);
        }

        public T value() {
            return this.value;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }
    }

    static class l
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> holders = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public l(HolderOwner<Object> var0) {
            super(var0);
        }

        @Override
        public Optional<Holder.c<Object>> get(ResourceKey<Object> var0) {
            return Optional.of(this.getOrCreate(var0));
        }

        <T> Holder.c<T> getOrCreate(ResourceKey<T> var02) {
            return this.holders.computeIfAbsent(var02, var0 -> Holder.c.createStandAlone(this.owner, var0));
        }
    }

    static class d<T>
    extends e<T>
    implements HolderLookup.b.a<T> {
        private final HolderLookup.b<T> parent;

        d(HolderOwner<T> var0, HolderLookup.b<T> var1) {
            super(var0);
            this.parent = var1;
        }

        @Override
        public HolderLookup.b<T> parent() {
            return this.parent;
        }
    }

    static abstract class e<T>
    extends c<T>
    implements HolderLookup.b<T> {
        protected e(HolderOwner<T> var0) {
            super(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected c(HolderOwner<T> var0) {
            this.owner = var0;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return Optional.of(HolderSet.emptyNamed(this.owner, var0));
        }
    }
}

