/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.SystemUtils;

public final class Vector3f
extends Record {
    final float x;
    final float y;
    final float z;
    public static final Codec<Vector3f> CODEC = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new Vector3f(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue())), var0 -> List.of(Float.valueOf(var0.x()), Float.valueOf(var0.y()), Float.valueOf(var0.z())));
    public static final StreamCodec<ByteBuf, Vector3f> STREAM_CODEC = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf var0) {
            return new Vector3f(var0.readFloat(), var0.readFloat(), var0.readFloat());
        }

        @Override
        public void encode(ByteBuf var0, Vector3f var1) {
            var0.writeFloat(var1.x);
            var0.writeFloat(var1.y);
            var0.writeFloat(var1.z);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3f)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };

    public Vector3f(float var0, float var1, float var2) {
        var0 = Float.isInfinite(var0) || Float.isNaN(var0) ? 0.0f : var0 % 360.0f;
        var1 = Float.isInfinite(var1) || Float.isNaN(var1) ? 0.0f : var1 % 360.0f;
        var2 = Float.isInfinite(var2) || Float.isNaN(var2) ? 0.0f : var2 % 360.0f;
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Vector3f.class, "x;y;z", "x", "y", "z"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Vector3f.class, "x;y;z", "x", "y", "z"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Vector3f.class, "x;y;z", "x", "y", "z"}, this, var0);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }
}

