/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;

public interface DataComponentType<T> {
    public static final Codec<DataComponentType<?>> CODEC = Codec.lazyInitialized(() -> BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec());
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentType<?>> STREAM_CODEC = StreamCodec.recursive(var0 -> ByteBufCodecs.registry(Registries.DATA_COMPONENT_TYPE));
    public static final Codec<DataComponentType<?>> PERSISTENT_CODEC = CODEC.validate(var0 -> var0.isTransient() ? DataResult.error(() -> "Encountered transient component " + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((DataComponentType<?>)var0))) : DataResult.success((Object)var0));
    public static final Codec<Map<DataComponentType<?>, Object>> VALUE_MAP_CODEC = Codec.dispatchedMap(PERSISTENT_CODEC, DataComponentType::codecOrThrow);

    public static <T> a<T> builder() {
        return new a();
    }

    public @Nullable Codec<T> codec();

    default public Codec<T> codecOrThrow() {
        Codec<T> var0 = this.codec();
        if (var0 == null) {
            throw new IllegalStateException(String.valueOf(this) + " is not a persistent component");
        }
        return var0;
    }

    default public boolean isTransient() {
        return this.codec() == null;
    }

    public boolean ignoreSwapAnimation();

    public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec();

    public static class net.minecraft.core.component.DataComponentType$a<T> {
        private @Nullable Codec<T> codec;
        private @Nullable StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
        private boolean cacheEncoding;
        private boolean ignoreSwapAnimation;

        public net.minecraft.core.component.DataComponentType$a<T> persistent(Codec<T> var0) {
            this.codec = var0;
            return this;
        }

        public net.minecraft.core.component.DataComponentType$a<T> networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, T> var0) {
            this.streamCodec = var0;
            return this;
        }

        public net.minecraft.core.component.DataComponentType$a<T> cacheEncoding() {
            this.cacheEncoding = true;
            return this;
        }

        public DataComponentType<T> build() {
            StreamCodec var0 = Objects.requireNonNullElseGet(this.streamCodec, () -> ByteBufCodecs.fromCodecWithRegistries(Objects.requireNonNull(this.codec, "Missing Codec for component")));
            Codec<T> var1 = this.cacheEncoding && this.codec != null ? DataComponents.ENCODER_CACHE.wrap(this.codec) : this.codec;
            return new a<T>(var1, var0, this.ignoreSwapAnimation);
        }

        public net.minecraft.core.component.DataComponentType$a<T> ignoreSwapAnimation() {
            this.ignoreSwapAnimation = true;
            return this;
        }

        static class a<T>
        implements DataComponentType<T> {
            private final @Nullable Codec<T> codec;
            private final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
            private final boolean ignoreSwapAnimation;

            a(@Nullable Codec<T> var0, StreamCodec<? super RegistryFriendlyByteBuf, T> var1, boolean var2) {
                this.codec = var0;
                this.streamCodec = var1;
                this.ignoreSwapAnimation = var2;
            }

            @Override
            public boolean ignoreSwapAnimation() {
                return this.ignoreSwapAnimation;
            }

            @Override
            public @Nullable Codec<T> codec() {
                return this.codec;
            }

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return this.streamCodec;
            }

            public String toString() {
                return SystemUtils.getRegisteredName(BuiltInRegistries.DATA_COMPONENT_TYPE, this);
            }
        }
    }
}

