/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.predicates.AnyValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface DataComponentPredicate {
    public static final Codec<Map<d<?>, DataComponentPredicate>> CODEC = Codec.dispatchedMap(d.CODEC, d::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, c<?>> SINGLE_STREAM_CODEC = d.STREAM_CODEC.dispatch(c::type, d::singleStreamCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<d<?>, DataComponentPredicate>> STREAM_CODEC = SINGLE_STREAM_CODEC.apply(ByteBufCodecs.list(64)).map(var0 -> var0.stream().collect(Collectors.toMap(c::type, c::predicate)), var0 -> var0.entrySet().stream().map(c::fromEntry).toList());

    public static MapCodec<c<?>> singleCodec(String var0) {
        return d.CODEC.dispatchMap(var0, c::type, d::wrappedCodec);
    }

    public boolean matches(DataComponentGetter var1);

    public static interface d<T extends DataComponentPredicate> {
        public static final Codec<d<?>> CODEC = Codec.either(BuiltInRegistries.DATA_COMPONENT_PREDICATE_TYPE.byNameCodec(), BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec()).xmap(d::copyOrCreateType, d::unpackType);
        public static final StreamCodec<RegistryFriendlyByteBuf, d<?>> STREAM_CODEC = ByteBufCodecs.either(ByteBufCodecs.registry(Registries.DATA_COMPONENT_PREDICATE_TYPE), ByteBufCodecs.registry(Registries.DATA_COMPONENT_TYPE)).map(d::copyOrCreateType, d::unpackType);

        private static <T extends d<?>> Either<T, DataComponentType<?>> unpackType(T var0) {
            Either either;
            if (var0 instanceof a) {
                a var1 = (a)var0;
                either = Either.right(var1.componentType());
            } else {
                either = Either.left(var0);
            }
            return either;
        }

        private static d<?> copyOrCreateType(Either<d<?>, DataComponentType<?>> var02) {
            return (d)var02.map(var0 -> var0, a::create);
        }

        public Codec<T> codec();

        public MapCodec<c<T>> wrappedCodec();

        public StreamCodec<RegistryFriendlyByteBuf, c<T>> singleStreamCodec();
    }

    public record c<T extends DataComponentPredicate>(d<T> type, T predicate) {
        static <T extends DataComponentPredicate> MapCodec<c<T>> wrapCodec(d<T> var0, Codec<T> var1) {
            return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)var1.fieldOf("value").forGetter(c::predicate)).apply((Applicative)var2, var1 -> new c<DataComponentPredicate>(var0, (DataComponentPredicate)var1)));
        }

        private static <T extends DataComponentPredicate> c<T> fromEntry(Map.Entry<d<?>, T> var0) {
            return new c<DataComponentPredicate>(var0.getKey(), (DataComponentPredicate)var0.getValue());
        }
    }

    public static final class a
    extends e<AnyValue> {
        private final AnyValue predicate;

        public a(AnyValue var0) {
            super(MapCodec.unitCodec((Object)var0));
            this.predicate = var0;
        }

        public AnyValue predicate() {
            return this.predicate;
        }

        public DataComponentType<?> componentType() {
            return this.predicate.type();
        }

        public static a create(DataComponentType<?> var0) {
            return new a(new AnyValue(var0));
        }
    }

    public static final class b<T extends DataComponentPredicate>
    extends e<T> {
        public b(Codec<T> var0) {
            super(var0);
        }
    }

    public static abstract class e<T extends DataComponentPredicate>
    implements d<T> {
        private final Codec<T> codec;
        private final MapCodec<c<T>> wrappedCodec;
        private final StreamCodec<RegistryFriendlyByteBuf, c<T>> singleStreamCodec;

        public e(Codec<T> var02) {
            this.codec = var02;
            this.wrappedCodec = c.wrapCodec(this, var02);
            this.singleStreamCodec = ByteBufCodecs.fromCodecWithRegistries(var02).map(var0 -> new c<DataComponentPredicate>(this, (DataComponentPredicate)var0), c::predicate);
        }

        @Override
        public Codec<T> codec() {
            return this.codec;
        }

        @Override
        public MapCodec<c<T>> wrappedCodec() {
            return this.wrappedCodec;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, c<T>> singleStreamCodec() {
            return this.singleStreamCodec;
        }
    }
}

