/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.criterion.CollectionPredicate;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.FireworkExplosionPredicate;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public record FireworksPredicate(Optional<CollectionPredicate<FireworkExplosion, FireworkExplosionPredicate.a>> explosions, CriterionConditionValue.IntegerRange flightDuration) implements SingleComponentItemPredicate<Fireworks>
{
    public static final Codec<FireworksPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CollectionPredicate.codec(FireworkExplosionPredicate.a.CODEC).optionalFieldOf("explosions").forGetter(FireworksPredicate::explosions), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("flight_duration", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(FireworksPredicate::flightDuration)).apply((Applicative)var0, FireworksPredicate::new));

    @Override
    public DataComponentType<Fireworks> componentType() {
        return DataComponents.FIREWORKS;
    }

    @Override
    public boolean matches(Fireworks var0) {
        if (this.explosions.isPresent() && !this.explosions.get().test(var0.explosions())) {
            return false;
        }
        return this.flightDuration.matches(var0.flightDuration());
    }
}

