/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.util.MathHelper;

public abstract class DustParticleOptionsBase
implements ParticleParam {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 4.0f;
    protected static final Codec<Float> SCALE = Codec.FLOAT.validate(var0 -> var0.floatValue() >= 0.01f && var0.floatValue() <= 4.0f ? DataResult.success((Object)var0) : DataResult.error(() -> "Value must be within range [0.01;4.0]: " + var0));
    private final float scale;

    public DustParticleOptionsBase(float var0) {
        this.scale = MathHelper.clamp(var0, 0.01f, 4.0f);
    }

    public float getScale() {
        return this.scale;
    }
}

