/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;

public class SpellParticleOption
implements ParticleParam {
    private final Particle<SpellParticleOption> type;
    private final int color;
    private final float power;

    public static MapCodec<SpellParticleOption> codec(Particle<SpellParticleOption> var0) {
        return RecordCodecBuilder.mapCodec(var12 -> var12.group((App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("color", (Object)-1).forGetter(var0 -> var0.color), (App)Codec.FLOAT.optionalFieldOf("power", (Object)Float.valueOf(1.0f)).forGetter(var0 -> Float.valueOf(var0.power))).apply((Applicative)var12, (var1, var2) -> new SpellParticleOption(var0, (int)var1, var2.floatValue())));
    }

    public static StreamCodec<? super ByteBuf, SpellParticleOption> streamCodec(Particle<SpellParticleOption> var02) {
        return StreamCodec.composite(ByteBufCodecs.INT, var0 -> var0.color, ByteBufCodecs.FLOAT, var0 -> Float.valueOf(var0.power), (var1, var2) -> new SpellParticleOption(var02, (int)var1, var2.floatValue()));
    }

    private SpellParticleOption(Particle<SpellParticleOption> var0, int var1, float var2) {
        this.type = var0;
        this.color = var1;
        this.power = var2;
    }

    public Particle<SpellParticleOption> getType() {
        return this.type;
    }

    public float getRed() {
        return (float)ARGB.red(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ARGB.green(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ARGB.blue(this.color) / 255.0f;
    }

    public float getPower() {
        return this.power;
    }

    public static SpellParticleOption create(Particle<SpellParticleOption> var0, int var1, float var2) {
        return new SpellParticleOption(var0, var1, var2);
    }

    public static SpellParticleOption create(Particle<SpellParticleOption> var0, float var1, float var2, float var3, float var4) {
        return SpellParticleOption.create(var0, ARGB.colorFromFloat(1.0f, var1, var2, var3), var4);
    }
}

