/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private int attempts = 0;
    private int successes = 0;

    @Override
    public void testStructureLoaded(GameTestHarnessInfo var0) {
        ++this.attempts;
    }

    private void handleRetry(GameTestHarnessInfo var0, GameTestHarnessRunner var1, boolean var2) {
        RetryOptions var3 = var0.retryOptions();
        Object var4 = String.format(Locale.ROOT, "[Run: %4d, Ok: %4d, Fail: %4d", this.attempts, this.successes, this.attempts - this.successes);
        if (!var3.unlimitedTries()) {
            var4 = (String)var4 + String.format(Locale.ROOT, ", Left: %4d", var3.numberOfTries() - this.attempts);
        }
        var4 = (String)var4 + "]";
        String var5 = String.valueOf(var0.id()) + " " + (var2 ? "passed" : "failed") + "! " + var0.getRunTime() + "ms";
        String var6 = String.format(Locale.ROOT, "%-53s%s", var4, var5);
        if (var2) {
            ReportGameListener.reportPassed(var0, var6);
        } else {
            ReportGameListener.say(var0.getLevel(), EnumChatFormat.RED, var6);
        }
        if (var3.hasTriesLeft(this.attempts, this.successes)) {
            var1.rerunTest(var0);
        }
    }

    @Override
    public void testPassed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
        ++this.successes;
        if (var0.retryOptions().hasRetries()) {
            this.handleRetry(var0, var1, true);
            return;
        }
        if (!var0.isFlaky()) {
            ReportGameListener.reportPassed(var0, String.valueOf(var0.id()) + " passed! (" + var0.getRunTime() + "ms / " + var0.getTick() + "gameticks)");
            return;
        }
        if (this.successes >= var0.requiredSuccesses()) {
            ReportGameListener.reportPassed(var0, String.valueOf(var0) + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(var0.getLevel(), EnumChatFormat.GREEN, "Flaky test " + String.valueOf(var0) + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            var1.rerunTest(var0);
        }
    }

    @Override
    public void testFailed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
        if (!var0.isFlaky()) {
            ReportGameListener.reportFailure(var0, var0.getError());
            if (var0.retryOptions().hasRetries()) {
                this.handleRetry(var0, var1, false);
            }
            return;
        }
        GameTestInstance var2 = var0.getTest();
        String var3 = "Flaky test " + String.valueOf(var0) + " failed, attempt: " + this.attempts + "/" + var2.maxAttempts();
        if (var2.requiredSuccesses() > 1) {
            var3 = var3 + ", successes: " + this.successes + " (" + var2.requiredSuccesses() + " required)";
        }
        ReportGameListener.say(var0.getLevel(), EnumChatFormat.YELLOW, var3);
        if (var0.maxAttempts() - this.attempts + this.successes >= var0.requiredSuccesses()) {
            var1.rerunTest(var0);
        } else {
            ReportGameListener.reportFailure(var0, new ExhaustedAttemptsException(this.attempts, this.successes, var0));
        }
    }

    @Override
    public void testAddedForRerun(GameTestHarnessInfo var0, GameTestHarnessInfo var1, GameTestHarnessRunner var2) {
        var1.addListener(this);
    }

    public static void reportPassed(GameTestHarnessInfo var02, String var1) {
        ReportGameListener.getTestInstanceBlockEntity(var02).ifPresent(var0 -> var0.setSuccess());
        ReportGameListener.visualizePassedTest(var02, var1);
    }

    private static void visualizePassedTest(GameTestHarnessInfo var0, String var1) {
        ReportGameListener.say(var0.getLevel(), EnumChatFormat.GREEN, var1);
        GlobalTestReporter.onTestSuccess(var0);
    }

    protected static void reportFailure(GameTestHarnessInfo var0, Throwable var12) {
        IChatBaseComponent var2;
        if (var12 instanceof GameTestHarnessAssertion) {
            GameTestHarnessAssertion var3 = (GameTestHarnessAssertion)var12;
            var2 = var3.getDescription();
        } else {
            var2 = IChatBaseComponent.literal(SystemUtils.describeError(var12));
        }
        ReportGameListener.getTestInstanceBlockEntity(var0).ifPresent(var1 -> var1.setErrorMessage(var2));
        ReportGameListener.visualizeFailedTest(var0, var12);
    }

    protected static void visualizeFailedTest(GameTestHarnessInfo var0, Throwable var1) {
        String var2 = var1.getMessage() + (String)(var1.getCause() == null ? "" : " cause: " + SystemUtils.describeError(var1.getCause()));
        String var3 = (var0.isRequired() ? "" : "(optional) ") + String.valueOf(var0.id()) + " failed! " + var2;
        ReportGameListener.say(var0.getLevel(), var0.isRequired() ? EnumChatFormat.RED : EnumChatFormat.YELLOW, var3);
        Throwable var4 = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)var1), (Object)var1);
        if (var4 instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition var5 = (GameTestHarnessAssertionPosition)var4;
            var0.getTestInstanceBlockEntity().markError(var5.getAbsolutePos(), var5.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(var0);
    }

    private static Optional<TestInstanceBlockEntity> getTestInstanceBlockEntity(GameTestHarnessInfo var0) {
        WorldServer var12 = var0.getLevel();
        Optional<BlockPosition> var2 = Optional.ofNullable(var0.getTestBlockPos());
        Optional<TestInstanceBlockEntity> var3 = var2.flatMap(var1 -> var12.getBlockEntity((BlockPosition)var1, TileEntityTypes.TEST_INSTANCE_BLOCK));
        return var3;
    }

    protected static void say(WorldServer var02, EnumChatFormat var1, String var22) {
        var02.getPlayers(var0 -> true).forEach(var2 -> var2.sendSystemMessage(IChatBaseComponent.literal(var22).withStyle(var1)));
    }
}

