/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;

public sealed interface NBTList
extends Iterable<NBTBase>,
NBTBase
permits NBTTagList, NBTTagByteArray, NBTTagIntArray, NBTTagLongArray {
    public void clear();

    public boolean setTag(int var1, NBTBase var2);

    public boolean addTag(int var1, NBTBase var2);

    public NBTBase remove(int var1);

    public NBTBase get(int var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public Iterator<NBTBase> iterator() {
        return new Iterator<NBTBase>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < NBTList.this.size();
            }

            @Override
            public NBTBase next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NBTList.this.get(this.index++);
            }

            @Override
            public /* synthetic */ Object next() {
                return this.next();
            }
        };
    }

    default public Stream<NBTBase> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

