/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;

public record NBTTagInt(int value) implements NBTNumber
{
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final NBTTagType<NBTTagInt> TYPE = new NBTTagType.a<NBTTagInt>(){

        @Override
        public NBTTagInt load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagInt.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static int readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(12L);
            return var0.readInt();
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String getName() {
            return "INT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };

    public static NBTTagInt valueOf(int var0) {
        if (var0 >= -128 && var0 <= 1024) {
            return a.cache[var0 - -128];
        }
        return new NBTTagInt(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    public byte getId() {
        return 3;
    }

    public NBTTagType<NBTTagInt> getType() {
        return TYPE;
    }

    @Override
    public NBTTagInt copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitInt(this);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return this.value;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitInt(this);
        return var0.build();
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    static class a {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final NBTTagInt[] cache = new NBTTagInt[1153];

        private a() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                a.cache[var0] = new NBTTagInt(-128 + var0);
            }
        }
    }
}

