/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.jspecify.annotations.Nullable;

public final class NBTTagList
extends AbstractList<NBTBase>
implements NBTList {
    private static final String WRAPPER_MARKER = "";
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final NBTTagType<NBTTagList> TYPE = new NBTTagType.b<NBTTagList>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NBTTagList load(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.pushDepth();
            try {
                NBTTagList nBTTagList = 1.loadList(var0, var1);
                return nBTTagList;
            }
            finally {
                var1.popDepth();
            }
        }

        private static NBTTagList loadList(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(36L);
            byte var2 = var0.readByte();
            int var3 = 1.readListCount(var0);
            if (var2 == 0 && var3 > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            var1.accountBytes(4L, var3);
            NBTTagType<?> var4 = NBTTagTypes.getType(var2);
            NBTTagList var5 = new NBTTagList(new ArrayList<NBTBase>(var3));
            for (int var6 = 0; var6 < var3; ++var6) {
                var5.addAndUnwrap((NBTBase)var4.load(var0, var1));
            }
            return var5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            var2.pushDepth();
            try {
                StreamTagVisitor.b b2 = 1.parseList(var0, var1, var2);
                return b2;
            }
            finally {
                var2.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        private static StreamTagVisitor.b parseList(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 4[SWITCH]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static int readListCount(DataInput var0) throws IOException {
            int var1 = var0.readInt();
            if (var1 < 0) {
                throw new NbtFormatException("ListTag length cannot be negative: " + var1);
            }
            return var1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.pushDepth();
            try {
                NBTTagType<?> var2 = NBTTagTypes.getType(var0.readByte());
                int var3 = var0.readInt();
                var2.skip(var0, var3, var1);
            }
            finally {
                var1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private final List<NBTBase> list;

    public NBTTagList() {
        this(new ArrayList<NBTBase>());
    }

    public NBTTagList(List<NBTBase> var0) {
        this.list = var0;
    }

    private static NBTBase tryUnwrap(NBTTagCompound var0) {
        NBTBase var1;
        if (var0.size() == 1 && (var1 = var0.get(WRAPPER_MARKER)) != null) {
            return var1;
        }
        return var0;
    }

    private static boolean isWrapper(NBTTagCompound var0) {
        return var0.size() == 1 && var0.contains(WRAPPER_MARKER);
    }

    private static NBTBase wrapIfNeeded(byte var0, NBTBase var1) {
        NBTTagCompound var2;
        if (var0 != 10) {
            return var1;
        }
        if (var1 instanceof NBTTagCompound && !NBTTagList.isWrapper(var2 = (NBTTagCompound)var1)) {
            return var2;
        }
        return NBTTagList.wrapElement(var1);
    }

    private static NBTTagCompound wrapElement(NBTBase var0) {
        return new NBTTagCompound(Map.of(WRAPPER_MARKER, var0));
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        byte var1 = this.identifyRawElementType();
        var0.writeByte(var1);
        var0.writeInt(this.list.size());
        for (NBTBase var3 : this.list) {
            NBTTagList.wrapIfNeeded(var1, var3).write(var0);
        }
    }

    @VisibleForTesting
    public byte identifyRawElementType() {
        byte var0 = 0;
        for (NBTBase var2 : this.list) {
            byte var3 = var2.getId();
            if (var0 == 0) {
                var0 = var3;
                continue;
            }
            if (var0 == var3) continue;
            return 10;
        }
        return var0;
    }

    public void addAndUnwrap(NBTBase var0) {
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var1 = (NBTTagCompound)var0;
            this.add(NBTTagList.tryUnwrap(var1));
        } else {
            this.add(var0);
        }
    }

    @Override
    public int sizeInBytes() {
        int var0 = 36;
        var0 += 4 * this.list.size();
        for (NBTBase var2 : this.list) {
            var0 += var2.sizeInBytes();
        }
        return var0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public NBTTagType<NBTTagList> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitList(this);
        return var0.build();
    }

    @Override
    public NBTBase remove(int var0) {
        return this.list.remove(var0);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Optional<NBTTagCompound> getCompound(int var0) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound var1 = (NBTTagCompound)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagCompound getCompoundOrEmpty(int var0) {
        return this.getCompound(var0).orElseGet(NBTTagCompound::new);
    }

    public Optional<NBTTagList> getList(int var0) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTTagList) {
            NBTTagList var1 = (NBTTagList)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagList getListOrEmpty(int var0) {
        return this.getList(var0).orElseGet(NBTTagList::new);
    }

    public Optional<Short> getShort(int var0) {
        return this.getOptional(var0).flatMap(NBTBase::asShort);
    }

    public short getShortOr(int var0, short var1) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.shortValue();
        }
        return var1;
    }

    public Optional<Integer> getInt(int var0) {
        return this.getOptional(var0).flatMap(NBTBase::asInt);
    }

    public int getIntOr(int var0, int var1) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.intValue();
        }
        return var1;
    }

    public Optional<int[]> getIntArray(int var0) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray var1 = (NBTTagIntArray)nBTBase;
            return Optional.of(var1.getAsIntArray());
        }
        return Optional.empty();
    }

    public Optional<long[]> getLongArray(int var0) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray var1 = (NBTTagLongArray)nBTBase;
            return Optional.of(var1.getAsLongArray());
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(int var0) {
        return this.getOptional(var0).flatMap(NBTBase::asDouble);
    }

    public double getDoubleOr(int var0, double var1) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var3 = (NBTNumber)nBTBase;
            return var3.doubleValue();
        }
        return var1;
    }

    public Optional<Float> getFloat(int var0) {
        return this.getOptional(var0).flatMap(NBTBase::asFloat);
    }

    public float getFloatOr(int var0, float var1) {
        NBTBase nBTBase = this.getNullable(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.floatValue();
        }
        return var1;
    }

    public Optional<String> getString(int var0) {
        return this.getOptional(var0).flatMap(NBTBase::asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringOr(int var0, String var1) {
        NBTBase var2 = this.getNullable(var0);
        if (!(var2 instanceof NBTTagString)) return var1;
        NBTTagString nBTTagString = (NBTTagString)var2;
        try {
            String string = nBTTagString.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private @Nullable NBTBase getNullable(int var0) {
        return var0 >= 0 && var0 < this.list.size() ? this.list.get(var0) : null;
    }

    private Optional<NBTBase> getOptional(int var0) {
        return Optional.ofNullable(this.getNullable(var0));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public NBTBase get(int var0) {
        return this.list.get(var0);
    }

    @Override
    public NBTBase set(int var0, NBTBase var1) {
        return this.list.set(var0, var1);
    }

    @Override
    public void add(int var0, NBTBase var1) {
        this.list.add(var0, var1);
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        this.list.set(var0, var1);
        return true;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        this.list.add(var0, var1);
        return true;
    }

    @Override
    public NBTTagList copy() {
        ArrayList<NBTBase> var0 = new ArrayList<NBTBase>(this.list.size());
        for (NBTBase var2 : this.list) {
            var0.add(var2.copy());
        }
        return new NBTTagList(var0);
    }

    @Override
    public Optional<NBTTagList> asList() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagList && Objects.equals(this.list, ((NBTTagList)var0).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public Stream<NBTBase> stream() {
        return super.stream();
    }

    public Stream<NBTTagCompound> compoundStream() {
        return this.stream().mapMulti((var0, var1) -> {
            if (var0 instanceof NBTTagCompound) {
                NBTTagCompound var2 = (NBTTagCompound)var0;
                var1.accept(var2);
            }
        });
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitList(this);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        byte var1 = this.identifyRawElementType();
        switch (var0.visitList(NBTTagTypes.getType(var1), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.b.HALT;
            }
            case BREAK: {
                return var0.visitContainerEnd();
            }
        }
        block13: for (int var2 = 0; var2 < this.list.size(); ++var2) {
            NBTBase var3 = NBTTagList.wrapIfNeeded(var1, this.list.get(var2));
            switch (var0.visitElement(var3.getType(), var2)) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                default: {
                    switch (var3.accept(var0)) {
                        case HALT: {
                            return StreamTagVisitor.b.HALT;
                        }
                        case BREAK: {
                            return var0.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return var0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Object remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ void add(int n2, Object object) {
        this.add(n2, (NBTBase)object);
    }

    @Override
    public /* synthetic */ Object set(int n2, Object object) {
        return this.set(n2, (NBTBase)object);
    }

    @Override
    public /* synthetic */ Object get(int n2) {
        return this.get(n2);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

